/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import com.mojang.serialization.Codec;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringRepresentable;

public abstract class BossEvent {
    private final UUID id;
    public Component name;
    protected float progress;
    public BossBarColor color;
    public BossBarOverlay overlay;
    protected boolean darkenScreen;
    protected boolean playBossMusic;
    protected boolean createWorldFog;

    public BossEvent(UUID var0, Component var1, BossBarColor var2, BossBarOverlay var3) {
        this.id = var0;
        this.name = var1;
        this.color = var2;
        this.overlay = var3;
        this.progress = 1.0f;
    }

    public UUID getId() {
        return this.id;
    }

    public Component getName() {
        return this.name;
    }

    public void setName(Component var0) {
        this.name = var0;
    }

    public float getProgress() {
        return this.progress;
    }

    public void setProgress(float var0) {
        this.progress = var0;
    }

    public BossBarColor getColor() {
        return this.color;
    }

    public void setColor(BossBarColor var0) {
        this.color = var0;
    }

    public BossBarOverlay getOverlay() {
        return this.overlay;
    }

    public void setOverlay(BossBarOverlay var0) {
        this.overlay = var0;
    }

    public boolean shouldDarkenScreen() {
        return this.darkenScreen;
    }

    public BossEvent setDarkenScreen(boolean var0) {
        this.darkenScreen = var0;
        return this;
    }

    public boolean shouldPlayBossMusic() {
        return this.playBossMusic;
    }

    public BossEvent setPlayBossMusic(boolean var0) {
        this.playBossMusic = var0;
        return this;
    }

    public BossEvent setCreateWorldFog(boolean var0) {
        this.createWorldFog = var0;
        return this;
    }

    public boolean shouldCreateWorldFog() {
        return this.createWorldFog;
    }

    public static enum BossBarColor implements StringRepresentable
    {
        PINK("pink", ChatFormatting.RED),
        BLUE("blue", ChatFormatting.BLUE),
        RED("red", ChatFormatting.DARK_RED),
        GREEN("green", ChatFormatting.GREEN),
        YELLOW("yellow", ChatFormatting.YELLOW),
        PURPLE("purple", ChatFormatting.DARK_BLUE),
        WHITE("white", ChatFormatting.WHITE);

        public static final Codec<BossBarColor> CODEC;
        private final String name;
        private final ChatFormatting formatting;

        private BossBarColor(String var2, ChatFormatting var3) {
            this.name = var2;
            this.formatting = var3;
        }

        public ChatFormatting getFormatting() {
            return this.formatting;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.fromEnum(BossBarColor::values);
        }
    }

    public static enum BossBarOverlay implements StringRepresentable
    {
        PROGRESS("progress"),
        NOTCHED_6("notched_6"),
        NOTCHED_10("notched_10"),
        NOTCHED_12("notched_12"),
        NOTCHED_20("notched_20");

        public static final Codec<BossBarOverlay> CODEC;
        private final String name;

        private BossBarOverlay(String var2) {
            this.name = var2;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.fromEnum(BossBarOverlay::values);
        }
    }
}

