/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.Container;
import net.minecraft.world.entity.ContainerUser;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftHumanEntity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.InventoryHolder;

public class CompoundContainer
implements Container {
    public final Container container1;
    public final Container container2;
    public List<HumanEntity> transaction = new ArrayList<HumanEntity>();

    @Override
    public List<ItemStack> getContents() {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>(this.getContainerSize());
        for (int i = 0; i < this.getContainerSize(); ++i) {
            result.add(this.getItem(i));
        }
        return result;
    }

    @Override
    public void onOpen(CraftHumanEntity who) {
        this.container1.onOpen(who);
        this.container2.onOpen(who);
        this.transaction.add(who);
    }

    @Override
    public void onClose(CraftHumanEntity who) {
        this.container1.onClose(who);
        this.container2.onClose(who);
        this.transaction.remove(who);
    }

    @Override
    public List<HumanEntity> getViewers() {
        return this.transaction;
    }

    @Override
    public InventoryHolder getOwner() {
        return null;
    }

    @Override
    public void setMaxStackSize(int size) {
        this.container1.setMaxStackSize(size);
        this.container2.setMaxStackSize(size);
    }

    @Override
    public Location getLocation() {
        return this.container1.getLocation();
    }

    public CompoundContainer(Container iinventory, Container iinventory1) {
        this.container1 = iinventory;
        this.container2 = iinventory1;
    }

    @Override
    public int getContainerSize() {
        return this.container1.getContainerSize() + this.container2.getContainerSize();
    }

    @Override
    public boolean isEmpty() {
        return this.container1.isEmpty() && this.container2.isEmpty();
    }

    public boolean contains(Container iinventory) {
        return this.container1 == iinventory || this.container2 == iinventory;
    }

    @Override
    public ItemStack getItem(int i) {
        return i >= this.container1.getContainerSize() ? this.container2.getItem(i - this.container1.getContainerSize()) : this.container1.getItem(i);
    }

    @Override
    public ItemStack removeItem(int i, int j) {
        return i >= this.container1.getContainerSize() ? this.container2.removeItem(i - this.container1.getContainerSize(), j) : this.container1.removeItem(i, j);
    }

    @Override
    public ItemStack removeItemNoUpdate(int i) {
        return i >= this.container1.getContainerSize() ? this.container2.removeItemNoUpdate(i - this.container1.getContainerSize()) : this.container1.removeItemNoUpdate(i);
    }

    @Override
    public void setItem(int i, ItemStack itemstack) {
        if (i >= this.container1.getContainerSize()) {
            this.container2.setItem(i - this.container1.getContainerSize(), itemstack);
        } else {
            this.container1.setItem(i, itemstack);
        }
    }

    @Override
    public int getMaxStackSize() {
        return Math.min(this.container1.getMaxStackSize(), this.container2.getMaxStackSize());
    }

    @Override
    public void setChanged() {
        this.container1.setChanged();
        this.container2.setChanged();
    }

    @Override
    public boolean stillValid(Player entityhuman) {
        return this.container1.stillValid(entityhuman) && this.container2.stillValid(entityhuman);
    }

    @Override
    public void startOpen(ContainerUser containeruser) {
        this.container1.startOpen(containeruser);
        this.container2.startOpen(containeruser);
    }

    @Override
    public void stopOpen(ContainerUser containeruser) {
        this.container1.stopOpen(containeruser);
        this.container2.stopOpen(containeruser);
    }

    @Override
    public boolean canPlaceItem(int i, ItemStack itemstack) {
        return i >= this.container1.getContainerSize() ? this.container2.canPlaceItem(i - this.container1.getContainerSize(), itemstack) : this.container1.canPlaceItem(i, itemstack);
    }

    @Override
    public void clearContent() {
        this.container1.clearContent();
        this.container2.clearContent();
    }
}

