/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import javax.annotation.concurrent.Immutable;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;

@Immutable
public class DifficultyInstance {
    private static final float DIFFICULTY_TIME_GLOBAL_OFFSET = -72000.0f;
    private static final float MAX_DIFFICULTY_TIME_GLOBAL = 1440000.0f;
    private static final float MAX_DIFFICULTY_TIME_LOCAL = 3600000.0f;
    private final Difficulty base;
    private final float effectiveDifficulty;

    public DifficultyInstance(Difficulty var0, long var1, long var3, float var5) {
        this.base = var0;
        this.effectiveDifficulty = this.calculateDifficulty(var0, var1, var3, var5);
    }

    public Difficulty getDifficulty() {
        return this.base;
    }

    public float getEffectiveDifficulty() {
        return this.effectiveDifficulty;
    }

    public boolean isHard() {
        return this.effectiveDifficulty >= (float)Difficulty.HARD.ordinal();
    }

    public boolean isHarderThan(float var0) {
        return this.effectiveDifficulty > var0;
    }

    public float getSpecialMultiplier() {
        if (this.effectiveDifficulty < 2.0f) {
            return 0.0f;
        }
        if (this.effectiveDifficulty > 4.0f) {
            return 1.0f;
        }
        return (this.effectiveDifficulty - 2.0f) / 2.0f;
    }

    private float calculateDifficulty(Difficulty var0, long var1, long var3, float var5) {
        if (var0 == Difficulty.PEACEFUL) {
            return 0.0f;
        }
        boolean var6 = var0 == Difficulty.HARD;
        float var7 = 0.75f;
        float var8 = Mth.clamp(((float)var1 + -72000.0f) / 1440000.0f, 0.0f, 1.0f) * 0.25f;
        var7 += var8;
        float var9 = 0.0f;
        var9 += Mth.clamp((float)var3 / 3600000.0f, 0.0f, 1.0f) * (var6 ? 1.0f : 0.75f);
        var9 += Mth.clamp(var5 * 0.25f, 0.0f, var8);
        if (var0 == Difficulty.EASY) {
            var9 *= 0.5f;
        }
        return (float)var0.getId() * (var7 += var9);
    }
}

