/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.UnaryOperator;
import net.minecraft.resources.Identifier;
import net.minecraft.util.Util;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.Stopwatch;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.SavedDataType;
import org.jspecify.annotations.Nullable;

public class Stopwatches
extends SavedData {
    private static final Codec<Stopwatches> CODEC = Codec.unboundedMap(Identifier.CODEC, (Codec)Codec.LONG).fieldOf("stopwatches").codec().xmap(Stopwatches::unpack, Stopwatches::pack);
    public static final SavedDataType<Stopwatches> TYPE = new SavedDataType<Stopwatches>("stopwatches", Stopwatches::new, CODEC, DataFixTypes.SAVED_DATA_STOPWATCHES);
    private final Map<Identifier, Stopwatch> stopwatches = new Object2ObjectOpenHashMap();

    private Stopwatches() {
    }

    private static Stopwatches unpack(Map<Identifier, Long> var0) {
        Stopwatches var1 = new Stopwatches();
        long var2 = Stopwatches.currentTime();
        var0.forEach((var3, var4) -> var0.stopwatches.put((Identifier)var3, new Stopwatch(var2, (long)var4)));
        return var1;
    }

    private Map<Identifier, Long> pack() {
        long var0 = Stopwatches.currentTime();
        TreeMap<Identifier, Long> var2 = new TreeMap<Identifier, Long>();
        this.stopwatches.forEach((var3, var4) -> var2.put((Identifier)var3, var4.elapsedMilliseconds(var0)));
        return var2;
    }

    public @Nullable Stopwatch get(Identifier var0) {
        return this.stopwatches.get(var0);
    }

    public boolean add(Identifier var0, Stopwatch var1) {
        if (this.stopwatches.putIfAbsent(var0, var1) == null) {
            this.setDirty();
            return true;
        }
        return false;
    }

    public boolean update(Identifier var0, UnaryOperator<Stopwatch> var12) {
        if (this.stopwatches.computeIfPresent(var0, (var1, var2) -> (Stopwatch)var12.apply((Stopwatch)var2)) != null) {
            this.setDirty();
            return true;
        }
        return false;
    }

    public boolean remove(Identifier var0) {
        boolean var1;
        boolean bl = var1 = this.stopwatches.remove(var0) != null;
        if (var1) {
            this.setDirty();
        }
        return var1;
    }

    @Override
    public boolean isDirty() {
        return super.isDirty() || !this.stopwatches.isEmpty();
    }

    public List<Identifier> ids() {
        return List.copyOf(this.stopwatches.keySet());
    }

    public static long currentTime() {
        return Util.getMillis();
    }
}

