/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.attribute;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.bukkit.event.player.PlayerBedEnterEvent;

public record BedRule(Rule canSleep, Rule canSetSpawn, boolean explodes, Optional<Component> errorMessage, PlayerBedEnterEvent.BedEnterResult bukkit) {
    public static final BedRule CAN_SLEEP_WHEN_DARK = new BedRule(Rule.WHEN_DARK, Rule.ALWAYS, false, Optional.of(Component.translatable("block.minecraft.bed.no_sleep")), PlayerBedEnterEvent.BedEnterResult.NOT_POSSIBLE_NOW);
    public static final BedRule EXPLODES = new BedRule(Rule.NEVER, Rule.NEVER, true, Optional.empty(), PlayerBedEnterEvent.BedEnterResult.NOT_POSSIBLE_HERE);
    public static final Codec<BedRule> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Rule.CODEC.fieldOf("can_sleep").forGetter(BedRule::canSleep), (App)Rule.CODEC.fieldOf("can_set_spawn").forGetter(BedRule::canSetSpawn), (App)Codec.BOOL.optionalFieldOf("explodes", (Object)false).forGetter(BedRule::explodes), (App)ComponentSerialization.CODEC.optionalFieldOf("error_message").forGetter(BedRule::errorMessage)).apply((Applicative)instance, BedRule::new));

    public BedRule(Rule canSleep, Rule canSetSpawn, boolean explodes, Optional<Component> errorMessage) {
        this(canSleep, canSetSpawn, explodes, errorMessage, PlayerBedEnterEvent.BedEnterResult.OTHER_PROBLEM);
    }

    public boolean canSleep(Level world) {
        return this.canSleep.test(world);
    }

    public boolean canSetSpawn(Level world) {
        return this.canSetSpawn.test(world);
    }

    public Player.BedSleepingProblem asProblem() {
        return new Player.BedSleepingProblem(this.errorMessage.orElse(null), this.bukkit);
    }

    public static enum Rule implements StringRepresentable
    {
        ALWAYS("always"),
        WHEN_DARK("when_dark"),
        NEVER("never");

        public static final Codec<Rule> CODEC;
        private final String name;

        private Rule(String s) {
            this.name = s;
        }

        public boolean test(Level world) {
            return switch (this.ordinal()) {
                case 0 -> true;
                case 1 -> world.isDarkOutside();
                case 2 -> false;
                default -> throw new MatchException(null, null);
            };
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.fromEnum(Rule::values);
        }
    }
}

