/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.attribute;

import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.util.Util;
import net.minecraft.world.attribute.EnvironmentAttribute;
import net.minecraft.world.attribute.EnvironmentAttributes;
import net.minecraft.world.attribute.modifier.AttributeModifier;
import org.jspecify.annotations.Nullable;

public final class EnvironmentAttributeMap {
    public static final EnvironmentAttributeMap EMPTY = new EnvironmentAttributeMap(Map.of());
    public static final Codec<EnvironmentAttributeMap> CODEC = Codec.lazyInitialized(() -> Codec.dispatchedMap(EnvironmentAttributes.CODEC, Util.memoize(Entry::createCodec)).xmap(EnvironmentAttributeMap::new, var0 -> var0.entries));
    public static final Codec<EnvironmentAttributeMap> NETWORK_CODEC = CODEC.xmap(EnvironmentAttributeMap::filterSyncable, EnvironmentAttributeMap::filterSyncable);
    public static final Codec<EnvironmentAttributeMap> CODEC_ONLY_POSITIONAL = CODEC.validate(var02 -> {
        List<EnvironmentAttribute> var1 = var02.keySet().stream().filter(var0 -> !var0.isPositional()).toList();
        if (!var1.isEmpty()) {
            return DataResult.error(() -> "The following attributes cannot be positional: " + String.valueOf(var1));
        }
        return DataResult.success((Object)var02);
    });
    final Map<EnvironmentAttribute<?>, Entry<?, ?>> entries;

    private static EnvironmentAttributeMap filterSyncable(EnvironmentAttributeMap var0) {
        return new EnvironmentAttributeMap(Map.copyOf(Maps.filterKeys(var0.entries, EnvironmentAttribute::isSyncable)));
    }

    EnvironmentAttributeMap(Map<EnvironmentAttribute<?>, Entry<?, ?>> var0) {
        this.entries = var0;
    }

    public static Builder builder() {
        return new Builder();
    }

    public <Value> @Nullable Entry<Value, ?> get(EnvironmentAttribute<Value> var0) {
        return this.entries.get(var0);
    }

    public <Value> Value applyModifier(EnvironmentAttribute<Value> var0, Value var1) {
        Entry<Value, ?> var2 = this.get(var0);
        return var2 != null ? var2.applyModifier(var1) : var1;
    }

    public boolean contains(EnvironmentAttribute<?> var0) {
        return this.entries.containsKey(var0);
    }

    public Set<EnvironmentAttribute<?>> keySet() {
        return this.entries.keySet();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object var0) {
        if (var0 == this) {
            return true;
        }
        if (!(var0 instanceof EnvironmentAttributeMap)) return false;
        EnvironmentAttributeMap var1 = (EnvironmentAttributeMap)var0;
        if (!this.entries.equals(var1.entries)) return false;
        return true;
    }

    public int hashCode() {
        return this.entries.hashCode();
    }

    public String toString() {
        return this.entries.toString();
    }

    public static class Builder {
        private final Map<EnvironmentAttribute<?>, Entry<?, ?>> entries = new HashMap();

        Builder() {
        }

        public Builder putAll(EnvironmentAttributeMap var0) {
            this.entries.putAll(var0.entries);
            return this;
        }

        public <Value, Parameter> Builder modify(EnvironmentAttribute<Value> var0, AttributeModifier<Value, Parameter> var1, Parameter var2) {
            var0.type().checkAllowedModifier(var1);
            this.entries.put(var0, new Entry<Value, Parameter>(var2, var1));
            return this;
        }

        public <Value> Builder set(EnvironmentAttribute<Value> var0, Value var1) {
            return this.modify(var0, AttributeModifier.override(), var1);
        }

        public EnvironmentAttributeMap build() {
            if (this.entries.isEmpty()) {
                return EMPTY;
            }
            return new EnvironmentAttributeMap(Map.copyOf(this.entries));
        }
    }

    public record Entry<Value, Argument>(Argument argument, AttributeModifier<Value, Argument> modifier) {
        private static <Value> Codec<Entry<Value, ?>> createCodec(EnvironmentAttribute<Value> var03) {
            Codec var12 = var03.type().modifierCodec().dispatch("modifier", Entry::modifier, Util.memoize(var1 -> Entry.createFullCodec(var03, var1)));
            return Codec.either(var03.valueCodec(), (Codec)var12).xmap(var02 -> (Entry)var02.map(var0 -> new Entry(var0, AttributeModifier.override()), var0 -> var0), var0 -> {
                if (var0.modifier == AttributeModifier.override()) {
                    return Either.left(var0.argument());
                }
                return Either.right((Object)var0);
            });
        }

        private static <Value, Argument> MapCodec<Entry<Value, Argument>> createFullCodec(EnvironmentAttribute<Value> var0, AttributeModifier<Value, Argument> var1) {
            return RecordCodecBuilder.mapCodec(var2 -> var2.group((App)var1.argumentCodec(var0).fieldOf("argument").forGetter(Entry::argument)).apply((Applicative)var2, var1 -> new Entry(var1, var1)));
        }

        public Value applyModifier(Value var0) {
            return this.modifier.apply(var0, this.argument);
        }
    }
}

