/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.attribute;

import com.google.common.annotations.VisibleForTesting;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.LongSupplier;
import java.util.stream.Stream;
import net.minecraft.SharedConstants;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.attribute.EnvironmentAttribute;
import net.minecraft.world.attribute.EnvironmentAttributeLayer;
import net.minecraft.world.attribute.EnvironmentAttributeMap;
import net.minecraft.world.attribute.EnvironmentAttributeReader;
import net.minecraft.world.attribute.SpatialAttributeInterpolator;
import net.minecraft.world.attribute.WeatherAttributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.timeline.Timeline;
import org.jspecify.annotations.Nullable;

public class EnvironmentAttributeSystem
implements EnvironmentAttributeReader {
    private final Map<EnvironmentAttribute<?>, ValueSampler<?>> attributeSamplers = new Reference2ObjectOpenHashMap();

    EnvironmentAttributeSystem(Map<EnvironmentAttribute<?>, List<EnvironmentAttributeLayer<?>>> var02) {
        var02.forEach((var0, var1) -> this.attributeSamplers.put((EnvironmentAttribute<?>)var0, this.bakeLayerSampler((EnvironmentAttribute)var0, (List<? extends EnvironmentAttributeLayer<?>>)var1)));
    }

    private <Value> ValueSampler<Value> bakeLayerSampler(EnvironmentAttribute<Value> var02, List<? extends EnvironmentAttributeLayer<?>> var1) {
        Object e;
        ArrayList var2 = new ArrayList(var1);
        Value var3 = var02.defaultValue();
        while (!var2.isEmpty() && (e = var2.getFirst()) instanceof EnvironmentAttributeLayer.Constant) {
            EnvironmentAttributeLayer.Constant var4 = (EnvironmentAttributeLayer.Constant)e;
            var3 = var4.applyConstant(var3);
            var2.removeFirst();
        }
        boolean var4 = var2.stream().anyMatch(var0 -> var0 instanceof EnvironmentAttributeLayer.Positional);
        return new ValueSampler<Value>(var02, var3, List.copyOf(var2), var4);
    }

    public static Builder builder() {
        return new Builder();
    }

    static void addDefaultLayers(Builder var0, Level var1) {
        RegistryAccess var22 = var1.registryAccess();
        BiomeManager var3 = var1.getBiomeManager();
        LongSupplier var4 = var1::getDayTime;
        EnvironmentAttributeSystem.addDimensionLayer(var0, var1.dimensionType());
        EnvironmentAttributeSystem.addBiomeLayer(var0, var22.lookupOrThrow(Registries.BIOME), var3);
        var1.dimensionType().timelines().forEach(var2 -> var0.addTimelineLayer((Holder<Timeline>)var2, var4));
        if (var1.canHaveWeather()) {
            WeatherAttributes.addBuiltinLayers(var0, WeatherAttributes.WeatherAccess.from(var1));
        }
    }

    private static void addDimensionLayer(Builder var0, DimensionType var1) {
        var0.addConstantLayer(var1.attributes());
    }

    private static void addBiomeLayer(Builder var02, HolderLookup<Biome> var1, BiomeManager var22) {
        Stream var3 = var1.listElements().flatMap(var0 -> ((Biome)var0.value()).getAttributes().keySet().stream()).distinct();
        var3.forEach(var2 -> EnvironmentAttributeSystem.addBiomeLayerForAttribute(var02, var2, var22));
    }

    private static <Value> void addBiomeLayerForAttribute(Builder var0, EnvironmentAttribute<Value> var1, BiomeManager var22) {
        var0.addPositionalLayer(var1, (var2, var3, var4) -> {
            if (var4 != null && var1.isSpatiallyInterpolated()) {
                return var4.applyAttributeLayer(var1, var2);
            }
            Holder<Biome> var5 = var22.getNoiseBiomeAtPosition(var3.x, var3.y, var3.z);
            return var5.value().getAttributes().applyModifier(var1, var2);
        });
    }

    public void invalidateTickCache() {
        this.attributeSamplers.values().forEach(ValueSampler::invalidateTickCache);
    }

    private <Value> @Nullable ValueSampler<Value> getValueSampler(EnvironmentAttribute<Value> var0) {
        return this.attributeSamplers.get(var0);
    }

    @Override
    public <Value> Value getDimensionValue(EnvironmentAttribute<Value> var0) {
        if (SharedConstants.IS_RUNNING_IN_IDE && var0.isPositional()) {
            throw new IllegalStateException("Position must always be provided for positional attribute " + String.valueOf(var0));
        }
        ValueSampler<Value> var1 = this.getValueSampler(var0);
        if (var1 == null) {
            return var0.defaultValue();
        }
        return var1.getDimensionValue();
    }

    @Override
    public <Value> Value getValue(EnvironmentAttribute<Value> var0, Vec3 var1, @Nullable SpatialAttributeInterpolator var2) {
        ValueSampler<Value> var3 = this.getValueSampler(var0);
        if (var3 == null) {
            return var0.defaultValue();
        }
        return var3.getValue(var1, var2);
    }

    @VisibleForTesting
    <Value> Value getConstantBaseValue(EnvironmentAttribute<Value> var0) {
        ValueSampler<Value> var1 = this.getValueSampler(var0);
        return var1 != null ? var1.baseValue : var0.defaultValue();
    }

    @VisibleForTesting
    boolean isAffectedByPosition(EnvironmentAttribute<?> var0) {
        ValueSampler<?> var1 = this.getValueSampler(var0);
        return var1 != null && var1.isAffectedByPosition;
    }

    static class ValueSampler<Value> {
        private final EnvironmentAttribute<Value> attribute;
        final Value baseValue;
        private final List<EnvironmentAttributeLayer<Value>> layers;
        final boolean isAffectedByPosition;
        private @Nullable Value cachedTickValue;
        private int cacheTickId;

        ValueSampler(EnvironmentAttribute<Value> var0, Value var1, List<EnvironmentAttributeLayer<Value>> var2, boolean var3) {
            this.attribute = var0;
            this.baseValue = var1;
            this.layers = var2;
            this.isAffectedByPosition = var3;
        }

        public void invalidateTickCache() {
            this.cachedTickValue = null;
            ++this.cacheTickId;
        }

        public Value getDimensionValue() {
            if (this.cachedTickValue != null) {
                return this.cachedTickValue;
            }
            Value var0 = this.computeValueNotPositional();
            this.cachedTickValue = var0;
            return var0;
        }

        public Value getValue(Vec3 var0, @Nullable SpatialAttributeInterpolator var1) {
            if (!this.isAffectedByPosition) {
                return this.getDimensionValue();
            }
            return this.computeValuePositional(var0, var1);
        }

        private Value computeValuePositional(Vec3 var0, @Nullable SpatialAttributeInterpolator var1) {
            Value var2 = this.baseValue;
            for (EnvironmentAttributeLayer<Value> var4 : this.layers) {
                EnvironmentAttributeLayer<Value> environmentAttributeLayer;
                Objects.requireNonNull(var4);
                int n = 0;
                var2 = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{EnvironmentAttributeLayer.Constant.class, EnvironmentAttributeLayer.TimeBased.class, EnvironmentAttributeLayer.Positional.class}, environmentAttributeLayer, n)) {
                    default -> throw new MatchException(null, null);
                    case 0 -> {
                        EnvironmentAttributeLayer.Constant var7 = (EnvironmentAttributeLayer.Constant)environmentAttributeLayer;
                        yield var7.applyConstant(var2);
                    }
                    case 1 -> {
                        EnvironmentAttributeLayer.TimeBased var8 = (EnvironmentAttributeLayer.TimeBased)environmentAttributeLayer;
                        yield var8.applyTimeBased(var2, this.cacheTickId);
                    }
                    case 2 -> {
                        EnvironmentAttributeLayer.Positional var9 = (EnvironmentAttributeLayer.Positional)environmentAttributeLayer;
                        yield var9.applyPositional(var2, Objects.requireNonNull(var0), var1);
                    }
                };
            }
            return this.attribute.sanitizeValue(var2);
        }

        private Value computeValueNotPositional() {
            Value var0 = this.baseValue;
            for (EnvironmentAttributeLayer<Value> var2 : this.layers) {
                EnvironmentAttributeLayer<Value> environmentAttributeLayer;
                Objects.requireNonNull(var2);
                int n = 0;
                var0 = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{EnvironmentAttributeLayer.Constant.class, EnvironmentAttributeLayer.TimeBased.class, EnvironmentAttributeLayer.Positional.class}, environmentAttributeLayer, n)) {
                    default -> throw new MatchException(null, null);
                    case 0 -> {
                        EnvironmentAttributeLayer.Constant var5 = (EnvironmentAttributeLayer.Constant)environmentAttributeLayer;
                        yield var5.applyConstant(var0);
                    }
                    case 1 -> {
                        EnvironmentAttributeLayer.TimeBased var6 = (EnvironmentAttributeLayer.TimeBased)environmentAttributeLayer;
                        yield var6.applyTimeBased(var0, this.cacheTickId);
                    }
                    case 2 -> {
                        EnvironmentAttributeLayer.Positional var7 = (EnvironmentAttributeLayer.Positional)environmentAttributeLayer;
                        yield var0;
                    }
                };
            }
            return this.attribute.sanitizeValue(var0);
        }
    }

    public static class Builder {
        private final Map<EnvironmentAttribute<?>, List<EnvironmentAttributeLayer<?>>> layersByAttribute = new HashMap();

        Builder() {
        }

        public Builder addDefaultLayers(Level var0) {
            EnvironmentAttributeSystem.addDefaultLayers(this, var0);
            return this;
        }

        public Builder addConstantLayer(EnvironmentAttributeMap var0) {
            for (EnvironmentAttribute<?> var2 : var0.keySet()) {
                this.addConstantEntry(var2, var0);
            }
            return this;
        }

        private <Value> Builder addConstantEntry(EnvironmentAttribute<Value> var0, EnvironmentAttributeMap var1) {
            EnvironmentAttributeMap.Entry<Value, ?> var2 = var1.get(var0);
            if (var2 == null) {
                throw new IllegalArgumentException("Missing attribute " + String.valueOf(var0));
            }
            return this.addConstantLayer(var0, var2::applyModifier);
        }

        public <Value> Builder addConstantLayer(EnvironmentAttribute<Value> var0, EnvironmentAttributeLayer.Constant<Value> var1) {
            return this.addLayer(var0, var1);
        }

        public <Value> Builder addTimeBasedLayer(EnvironmentAttribute<Value> var0, EnvironmentAttributeLayer.TimeBased<Value> var1) {
            return this.addLayer(var0, var1);
        }

        public <Value> Builder addPositionalLayer(EnvironmentAttribute<Value> var0, EnvironmentAttributeLayer.Positional<Value> var1) {
            return this.addLayer(var0, var1);
        }

        private <Value> Builder addLayer(EnvironmentAttribute<Value> var02, EnvironmentAttributeLayer<Value> var1) {
            this.layersByAttribute.computeIfAbsent(var02, var0 -> new ArrayList()).add(var1);
            return this;
        }

        public Builder addTimelineLayer(Holder<Timeline> var0, LongSupplier var1) {
            for (EnvironmentAttribute<?> var3 : var0.value().attributes()) {
                this.addTimelineLayerForAttribute(var0, var3, var1);
            }
            return this;
        }

        private <Value> void addTimelineLayerForAttribute(Holder<Timeline> var0, EnvironmentAttribute<Value> var1, LongSupplier var2) {
            this.addTimeBasedLayer(var1, var0.value().createTrackSampler(var1, var2));
        }

        public EnvironmentAttributeSystem build() {
            return new EnvironmentAttributeSystem(this.layersByAttribute);
        }
    }
}

