/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.effect;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.function.ToIntFunction;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gamerules.GameRules;
import org.bukkit.event.entity.CreatureSpawnEvent;

class OozingMobEffect
extends MobEffect {
    private static final int RADIUS_TO_CHECK_SLIMES = 2;
    public static final int SLIME_SIZE = 2;
    private final ToIntFunction<RandomSource> spawnedCount;

    protected OozingMobEffect(MobEffectCategory mobeffectinfo, int i, ToIntFunction<RandomSource> tointfunction) {
        super(mobeffectinfo, i, ParticleTypes.ITEM_SLIME);
        this.spawnedCount = tointfunction;
    }

    @VisibleForTesting
    protected static int numberOfSlimesToSpawn(int i, NearbySlimes oozingmobeffect_a, int j) {
        return i < 1 ? j : Mth.clamp(0, i - oozingmobeffect_a.count(i), j);
    }

    @Override
    public void onMobRemoved(ServerLevel worldserver, LivingEntity entityliving, int i, Entity.RemovalReason entity_removalreason) {
        if (entity_removalreason == Entity.RemovalReason.KILLED) {
            int j = this.spawnedCount.applyAsInt(entityliving.getRandom());
            int k = worldserver.getGameRules().get(GameRules.MAX_ENTITY_CRAMMING);
            int l = OozingMobEffect.numberOfSlimesToSpawn(k, NearbySlimes.closeTo(entityliving), j);
            for (int i1 = 0; i1 < l; ++i1) {
                this.spawnSlimeOffspring(entityliving.level(), entityliving.getX(), entityliving.getY() + 0.5, entityliving.getZ());
            }
        }
    }

    private void spawnSlimeOffspring(Level world, double d0, double d1, double d2) {
        Slime entityslime = EntityType.SLIME.create(world, EntitySpawnReason.TRIGGERED);
        if (entityslime != null) {
            entityslime.setSize(2, true);
            entityslime.snapTo(d0, d1, d2, world.getRandom().nextFloat() * 360.0f, 0.0f);
            world.addFreshEntity(entityslime, CreatureSpawnEvent.SpawnReason.POTION_EFFECT);
        }
    }

    @FunctionalInterface
    protected static interface NearbySlimes {
        public int count(int var1);

        public static NearbySlimes closeTo(LivingEntity entityliving) {
            return i -> {
                ArrayList list = new ArrayList();
                entityliving.level().getEntities(EntityType.SLIME, entityliving.getBoundingBox().inflate(2.0), entityslime -> entityslime != entityliving, list, i);
                return list.size();
            };
        }
    }
}

