/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.effect;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.function.ToIntFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.gamerules.GameRules;

class WeavingMobEffect
extends MobEffect {
    private final ToIntFunction<RandomSource> maxCobwebs;

    protected WeavingMobEffect(MobEffectCategory var0, int var1, ToIntFunction<RandomSource> var2) {
        super(var0, var1, ParticleTypes.ITEM_COBWEB);
        this.maxCobwebs = var2;
    }

    @Override
    public void onMobRemoved(ServerLevel var0, LivingEntity var1, int var2, Entity.RemovalReason var3) {
        if (var3 == Entity.RemovalReason.KILLED && (var1 instanceof Player || var0.getGameRules().get(GameRules.MOB_GRIEFING).booleanValue())) {
            this.spawnCobwebsRandomlyAround(var0, var1.getRandom(), var1.blockPosition());
        }
    }

    private void spawnCobwebsRandomlyAround(ServerLevel var0, RandomSource var1, BlockPos var2) {
        HashSet var3 = Sets.newHashSet();
        int var4 = this.maxCobwebs.applyAsInt(var1);
        for (BlockPos var6 : BlockPos.randomInCube(var1, 15, var2, 1)) {
            BlockPos var7 = var6.below();
            if (var3.contains(var6) || !var0.getBlockState(var6).canBeReplaced() || !var0.getBlockState(var7).isFaceSturdy(var0, var7, Direction.UP)) continue;
            var3.add(var6.immutable());
            if (var3.size() < var4) continue;
            break;
        }
        for (BlockPos var6 : var3) {
            var0.setBlock(var6, Blocks.COBWEB.defaultBlockState(), 3);
            var0.levelEvent(3018, var6, 0);
        }
    }
}

