/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.monster.zombie.Zombie;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.scores.Scoreboard;
import org.bukkit.event.entity.EntityRemoveEvent;

public enum ConversionType {
    SINGLE(true){

        @Override
        void convert(Mob entityinsentient, Mob entityinsentient1, ConversionParams conversionparams) {
            Entity entity2;
            Entity entity = entityinsentient.getFirstPassenger();
            entityinsentient1.copyPosition(entityinsentient);
            entityinsentient1.setDeltaMovement(entityinsentient.getDeltaMovement());
            if (entity != null) {
                entity.stopRiding();
                entity.boardingCooldown = 0;
                for (Entity entity3 : entityinsentient1.getPassengers()) {
                    entity3.stopRiding();
                    entity3.remove(Entity.RemovalReason.DISCARDED, EntityRemoveEvent.Cause.TRANSFORMATION);
                }
                entity.startRiding(entityinsentient1);
            }
            if ((entity2 = entityinsentient.getVehicle()) != null) {
                entityinsentient.stopRiding();
                entityinsentient1.startRiding(entity2, false, false);
            }
            if (conversionparams.keepEquipment()) {
                for (EquipmentSlot enumitemslot : EquipmentSlot.VALUES) {
                    ItemStack itemstack = entityinsentient.getItemBySlot(enumitemslot);
                    if (itemstack.isEmpty()) continue;
                    entityinsentient1.setItemSlot(enumitemslot, itemstack.copy());
                    entityinsentient1.setDropChance(enumitemslot, entityinsentient.getDropChances().byEquipment(enumitemslot));
                }
            }
            entityinsentient1.fallDistance = entityinsentient.fallDistance;
            entityinsentient1.setSharedFlag(7, entityinsentient.isFallFlying());
            entityinsentient1.lastHurtByPlayerMemoryTime = entityinsentient.lastHurtByPlayerMemoryTime;
            entityinsentient1.hurtTime = entityinsentient.hurtTime;
            entityinsentient1.yBodyRot = entityinsentient.yBodyRot;
            entityinsentient1.setOnGround(entityinsentient.onGround());
            Optional<BlockPos> optional = entityinsentient.getSleepingPos();
            Objects.requireNonNull(entityinsentient1);
            optional.ifPresent(entityinsentient1::setSleepingPos);
            Entity entity3 = entityinsentient.getLeashHolder();
            if (entity3 != null) {
                entityinsentient1.setLeashedTo(entity3, true);
            }
            this.convertCommon(entityinsentient, entityinsentient1, conversionparams);
        }

        @Override
        void postConvert(Mob entityinsentient, Mob entityinsentient1, ConversionParams conversionparams) {
            if (conversionparams.keepEquipment()) {
                for (EquipmentSlot enumitemslot : EquipmentSlot.VALUES) {
                    ItemStack itemstack = entityinsentient.getItemBySlot(enumitemslot);
                    if (itemstack.isEmpty()) continue;
                    itemstack.setCount(0);
                }
            }
        }
    }
    ,
    SPLIT_ON_DEATH(false){

        @Override
        void convert(Mob entityinsentient, Mob entityinsentient1, ConversionParams conversionparams) {
            Entity entity1;
            Entity entity = entityinsentient.getFirstPassenger();
            if (entity != null) {
                entity.stopRiding();
            }
            if ((entity1 = entityinsentient.getLeashHolder()) != null) {
                entityinsentient.dropLeash();
            }
            this.convertCommon(entityinsentient, entityinsentient1, conversionparams);
        }
    };

    private static final Set<DataComponentType<?>> COMPONENTS_TO_COPY;
    private final boolean discardAfterConversion;

    private ConversionType(boolean flag) {
        this.discardAfterConversion = flag;
    }

    public boolean shouldDiscardAfterConversion() {
        return this.discardAfterConversion;
    }

    abstract void convert(Mob var1, Mob var2, ConversionParams var3);

    void postConvert(Mob entityinsentient, Mob entityinsentient1, ConversionParams conversionparams) {
    }

    void convertCommon(Mob entityinsentient, Mob entityinsentient1, ConversionParams conversionparams) {
        Zombie entityzombie;
        entityinsentient1.setAbsorptionAmount(entityinsentient.getAbsorptionAmount());
        for (MobEffectInstance mobeffect : entityinsentient.getActiveEffects()) {
            entityinsentient1.addEffect(new MobEffectInstance(mobeffect));
        }
        if (entityinsentient.isBaby()) {
            entityinsentient1.setBaby(true);
        }
        if (entityinsentient instanceof AgeableMob) {
            AgeableMob entityageable = (AgeableMob)entityinsentient;
            if (entityinsentient1 instanceof AgeableMob) {
                AgeableMob entityageable1 = (AgeableMob)entityinsentient1;
                entityageable1.setAge(entityageable.getAge());
                entityageable1.forcedAge = entityageable.forcedAge;
                entityageable1.forcedAgeTimer = entityageable.forcedAgeTimer;
            }
        }
        Brain<UUID> behaviorcontroller = entityinsentient.getBrain();
        Brain<?> behaviorcontroller1 = entityinsentient1.getBrain();
        if (behaviorcontroller.checkMemory(MemoryModuleType.ANGRY_AT, MemoryStatus.REGISTERED) && behaviorcontroller.hasMemoryValue(MemoryModuleType.ANGRY_AT)) {
            behaviorcontroller1.setMemory(MemoryModuleType.ANGRY_AT, behaviorcontroller.getMemory(MemoryModuleType.ANGRY_AT));
        }
        if (conversionparams.preserveCanPickUpLoot()) {
            entityinsentient1.setCanPickUpLoot(entityinsentient.canPickUpLoot());
        }
        entityinsentient1.setLeftHanded(entityinsentient.isLeftHanded());
        entityinsentient1.setNoAi(entityinsentient.isNoAi());
        if (entityinsentient.isPersistenceRequired()) {
            entityinsentient1.setPersistenceRequired();
        }
        entityinsentient1.setCustomNameVisible(entityinsentient.isCustomNameVisible());
        entityinsentient1.setSharedFlagOnFire(entityinsentient.isOnFire());
        entityinsentient1.setInvulnerable(entityinsentient.isInvulnerable());
        entityinsentient1.setNoGravity(entityinsentient.isNoGravity());
        entityinsentient1.setPortalCooldown(entityinsentient.getPortalCooldown());
        entityinsentient1.setSilent(entityinsentient.isSilent());
        Set<String> set = entityinsentient.getTags();
        Objects.requireNonNull(entityinsentient1);
        set.forEach(entityinsentient1::addTag);
        for (DataComponentType<?> datacomponenttype : COMPONENTS_TO_COPY) {
            ConversionType.copyComponent(entityinsentient, entityinsentient1, datacomponenttype);
        }
        if (conversionparams.team() != null) {
            Scoreboard scoreboard = entityinsentient1.level().getScoreboard();
            scoreboard.addPlayerToTeam(entityinsentient1.getStringUUID(), conversionparams.team());
            if (entityinsentient.getTeam() != null && entityinsentient.getTeam() == conversionparams.team()) {
                scoreboard.removePlayerFromTeam(entityinsentient.getStringUUID(), entityinsentient.getTeam());
            }
        }
        if (entityinsentient instanceof Zombie && (entityzombie = (Zombie)entityinsentient).canBreakDoors() && entityinsentient1 instanceof Zombie) {
            Zombie entityzombie1 = (Zombie)entityinsentient1;
            entityzombie1.setCanBreakDoors(true);
        }
    }

    private static <T> void copyComponent(Mob entityinsentient, Mob entityinsentient1, DataComponentType<T> datacomponenttype) {
        T t0 = entityinsentient.get(datacomponenttype);
        if (t0 != null) {
            entityinsentient1.setComponent(datacomponenttype, t0);
        }
    }

    static {
        COMPONENTS_TO_COPY = Set.of(DataComponents.CUSTOM_NAME, DataComponents.CUSTOM_DATA);
    }
}

