/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.mojang.logging.LogUtils;
import com.mojang.math.Transformation;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.Optional;
import java.util.function.IntFunction;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.permissions.LevelBasedPermissionSet;
import net.minecraft.util.ARGB;
import net.minecraft.util.Brightness;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.InterpolationHandler;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public abstract class Display
extends Entity {
    static final Logger LOGGER = LogUtils.getLogger();
    public static final int NO_BRIGHTNESS_OVERRIDE = -1;
    private static final EntityDataAccessor<Integer> DATA_TRANSFORMATION_INTERPOLATION_START_DELTA_TICKS_ID = SynchedEntityData.defineId(Display.class, EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> DATA_TRANSFORMATION_INTERPOLATION_DURATION_ID = SynchedEntityData.defineId(Display.class, EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_POS_ROT_INTERPOLATION_DURATION_ID = SynchedEntityData.defineId(Display.class, EntityDataSerializers.INT);
    private static final EntityDataAccessor<Vector3fc> DATA_TRANSLATION_ID = SynchedEntityData.defineId(Display.class, EntityDataSerializers.VECTOR3);
    private static final EntityDataAccessor<Vector3fc> DATA_SCALE_ID = SynchedEntityData.defineId(Display.class, EntityDataSerializers.VECTOR3);
    private static final EntityDataAccessor<Quaternionfc> DATA_LEFT_ROTATION_ID = SynchedEntityData.defineId(Display.class, EntityDataSerializers.QUATERNION);
    private static final EntityDataAccessor<Quaternionfc> DATA_RIGHT_ROTATION_ID = SynchedEntityData.defineId(Display.class, EntityDataSerializers.QUATERNION);
    private static final EntityDataAccessor<Byte> DATA_BILLBOARD_RENDER_CONSTRAINTS_ID = SynchedEntityData.defineId(Display.class, EntityDataSerializers.BYTE);
    private static final EntityDataAccessor<Integer> DATA_BRIGHTNESS_OVERRIDE_ID = SynchedEntityData.defineId(Display.class, EntityDataSerializers.INT);
    private static final EntityDataAccessor<Float> DATA_VIEW_RANGE_ID = SynchedEntityData.defineId(Display.class, EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> DATA_SHADOW_RADIUS_ID = SynchedEntityData.defineId(Display.class, EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> DATA_SHADOW_STRENGTH_ID = SynchedEntityData.defineId(Display.class, EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> DATA_WIDTH_ID = SynchedEntityData.defineId(Display.class, EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> DATA_HEIGHT_ID = SynchedEntityData.defineId(Display.class, EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Integer> DATA_GLOW_COLOR_OVERRIDE_ID = SynchedEntityData.defineId(Display.class, EntityDataSerializers.INT);
    private static final IntSet RENDER_STATE_IDS = IntSet.of((int[])new int[]{DATA_TRANSLATION_ID.id(), DATA_SCALE_ID.id(), DATA_LEFT_ROTATION_ID.id(), DATA_RIGHT_ROTATION_ID.id(), DATA_BILLBOARD_RENDER_CONSTRAINTS_ID.id(), DATA_BRIGHTNESS_OVERRIDE_ID.id(), DATA_SHADOW_RADIUS_ID.id(), DATA_SHADOW_STRENGTH_ID.id()});
    private static final int INITIAL_TRANSFORMATION_INTERPOLATION_DURATION = 0;
    private static final int INITIAL_TRANSFORMATION_START_INTERPOLATION = 0;
    private static final int INITIAL_POS_ROT_INTERPOLATION_DURATION = 0;
    private static final float INITIAL_SHADOW_RADIUS = 0.0f;
    private static final float INITIAL_SHADOW_STRENGTH = 1.0f;
    private static final float INITIAL_VIEW_RANGE = 1.0f;
    private static final float INITIAL_WIDTH = 0.0f;
    private static final float INITIAL_HEIGHT = 0.0f;
    private static final int NO_GLOW_COLOR_OVERRIDE = -1;
    public static final String TAG_POS_ROT_INTERPOLATION_DURATION = "teleport_duration";
    public static final String TAG_TRANSFORMATION_INTERPOLATION_DURATION = "interpolation_duration";
    public static final String TAG_TRANSFORMATION_START_INTERPOLATION = "start_interpolation";
    public static final String TAG_TRANSFORMATION = "transformation";
    public static final String TAG_BILLBOARD = "billboard";
    public static final String TAG_BRIGHTNESS = "brightness";
    public static final String TAG_VIEW_RANGE = "view_range";
    public static final String TAG_SHADOW_RADIUS = "shadow_radius";
    public static final String TAG_SHADOW_STRENGTH = "shadow_strength";
    public static final String TAG_WIDTH = "width";
    public static final String TAG_HEIGHT = "height";
    public static final String TAG_GLOW_COLOR_OVERRIDE = "glow_color_override";
    private long interpolationStartClientTick = Integer.MIN_VALUE;
    private int interpolationDuration;
    private float lastProgress;
    private AABB cullingBoundingBox;
    private boolean noCulling = true;
    protected boolean updateRenderState;
    private boolean updateStartTick;
    private boolean updateInterpolationDuration;
    private @Nullable RenderState renderState;
    private final InterpolationHandler interpolation = new InterpolationHandler((Entity)this, 0);

    public Display(EntityType<?> var0, Level var1) {
        super(var0, var1);
        this.noPhysics = true;
        this.cullingBoundingBox = this.getBoundingBox();
    }

    @Override
    public void onSyncedDataUpdated(EntityDataAccessor<?> var0) {
        super.onSyncedDataUpdated(var0);
        if (DATA_HEIGHT_ID.equals(var0) || DATA_WIDTH_ID.equals(var0)) {
            this.updateCulling();
        }
        if (DATA_TRANSFORMATION_INTERPOLATION_START_DELTA_TICKS_ID.equals(var0)) {
            this.updateStartTick = true;
        }
        if (DATA_POS_ROT_INTERPOLATION_DURATION_ID.equals(var0)) {
            this.interpolation.setInterpolationLength(this.getPosRotInterpolationDuration());
        }
        if (DATA_TRANSFORMATION_INTERPOLATION_DURATION_ID.equals(var0)) {
            this.updateInterpolationDuration = true;
        }
        if (RENDER_STATE_IDS.contains(var0.id())) {
            this.updateRenderState = true;
        }
    }

    @Override
    public final boolean hurtServer(ServerLevel var0, DamageSource var1, float var2) {
        return false;
    }

    public static Transformation createTransformation(SynchedEntityData var0) {
        Vector3fc var1 = var0.get(DATA_TRANSLATION_ID);
        Quaternionfc var2 = var0.get(DATA_LEFT_ROTATION_ID);
        Vector3fc var3 = var0.get(DATA_SCALE_ID);
        Quaternionfc var4 = var0.get(DATA_RIGHT_ROTATION_ID);
        return new Transformation(var1, var2, var3, var4);
    }

    @Override
    public void tick() {
        Entity var0 = this.getVehicle();
        if (var0 != null && var0.isRemoved()) {
            this.stopRiding();
        }
        if (this.level().isClientSide()) {
            int var1;
            if (this.updateStartTick) {
                this.updateStartTick = false;
                var1 = this.getTransformationInterpolationDelay();
                this.interpolationStartClientTick = this.tickCount + var1;
            }
            if (this.updateInterpolationDuration) {
                this.updateInterpolationDuration = false;
                this.interpolationDuration = this.getTransformationInterpolationDuration();
            }
            if (this.updateRenderState) {
                this.updateRenderState = false;
                var1 = this.interpolationDuration != 0 ? 1 : 0;
                this.renderState = var1 != 0 && this.renderState != null ? this.createInterpolatedRenderState(this.renderState, this.lastProgress) : this.createFreshRenderState();
                this.updateRenderSubState(var1 != 0, this.lastProgress);
            }
            this.interpolation.interpolate();
        }
    }

    @Override
    public InterpolationHandler getInterpolation() {
        return this.interpolation;
    }

    protected abstract void updateRenderSubState(boolean var1, float var2);

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder var0) {
        var0.define(DATA_POS_ROT_INTERPOLATION_DURATION_ID, 0);
        var0.define(DATA_TRANSFORMATION_INTERPOLATION_START_DELTA_TICKS_ID, 0);
        var0.define(DATA_TRANSFORMATION_INTERPOLATION_DURATION_ID, 0);
        var0.define(DATA_TRANSLATION_ID, new Vector3f());
        var0.define(DATA_SCALE_ID, new Vector3f(1.0f, 1.0f, 1.0f));
        var0.define(DATA_RIGHT_ROTATION_ID, new Quaternionf());
        var0.define(DATA_LEFT_ROTATION_ID, new Quaternionf());
        var0.define(DATA_BILLBOARD_RENDER_CONSTRAINTS_ID, BillboardConstraints.FIXED.getId());
        var0.define(DATA_BRIGHTNESS_OVERRIDE_ID, -1);
        var0.define(DATA_VIEW_RANGE_ID, Float.valueOf(1.0f));
        var0.define(DATA_SHADOW_RADIUS_ID, Float.valueOf(0.0f));
        var0.define(DATA_SHADOW_STRENGTH_ID, Float.valueOf(1.0f));
        var0.define(DATA_WIDTH_ID, Float.valueOf(0.0f));
        var0.define(DATA_HEIGHT_ID, Float.valueOf(0.0f));
        var0.define(DATA_GLOW_COLOR_OVERRIDE_ID, -1);
    }

    @Override
    protected void readAdditionalSaveData(ValueInput var0) {
        this.setTransformation(var0.read(TAG_TRANSFORMATION, Transformation.EXTENDED_CODEC).orElse(Transformation.identity()));
        this.setTransformationInterpolationDuration(var0.getIntOr(TAG_TRANSFORMATION_INTERPOLATION_DURATION, 0));
        this.setTransformationInterpolationDelay(var0.getIntOr(TAG_TRANSFORMATION_START_INTERPOLATION, 0));
        int var1 = var0.getIntOr(TAG_POS_ROT_INTERPOLATION_DURATION, 0);
        this.setPosRotInterpolationDuration(Mth.clamp(var1, 0, 59));
        this.setBillboardConstraints(var0.read(TAG_BILLBOARD, BillboardConstraints.CODEC).orElse(BillboardConstraints.FIXED));
        this.setViewRange(var0.getFloatOr(TAG_VIEW_RANGE, 1.0f));
        this.setShadowRadius(var0.getFloatOr(TAG_SHADOW_RADIUS, 0.0f));
        this.setShadowStrength(var0.getFloatOr(TAG_SHADOW_STRENGTH, 1.0f));
        this.setWidth(var0.getFloatOr(TAG_WIDTH, 0.0f));
        this.setHeight(var0.getFloatOr(TAG_HEIGHT, 0.0f));
        this.setGlowColorOverride(var0.getIntOr(TAG_GLOW_COLOR_OVERRIDE, -1));
        this.setBrightnessOverride(var0.read(TAG_BRIGHTNESS, Brightness.CODEC).orElse(null));
    }

    public void setTransformation(Transformation var0) {
        this.entityData.set(DATA_TRANSLATION_ID, var0.getTranslation());
        this.entityData.set(DATA_LEFT_ROTATION_ID, var0.getLeftRotation());
        this.entityData.set(DATA_SCALE_ID, var0.getScale());
        this.entityData.set(DATA_RIGHT_ROTATION_ID, var0.getRightRotation());
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput var0) {
        var0.store(TAG_TRANSFORMATION, Transformation.EXTENDED_CODEC, Display.createTransformation(this.entityData));
        var0.store(TAG_BILLBOARD, BillboardConstraints.CODEC, this.getBillboardConstraints());
        var0.putInt(TAG_TRANSFORMATION_INTERPOLATION_DURATION, this.getTransformationInterpolationDuration());
        var0.putInt(TAG_POS_ROT_INTERPOLATION_DURATION, this.getPosRotInterpolationDuration());
        var0.putFloat(TAG_VIEW_RANGE, this.getViewRange());
        var0.putFloat(TAG_SHADOW_RADIUS, this.getShadowRadius());
        var0.putFloat(TAG_SHADOW_STRENGTH, this.getShadowStrength());
        var0.putFloat(TAG_WIDTH, this.getWidth());
        var0.putFloat(TAG_HEIGHT, this.getHeight());
        var0.putInt(TAG_GLOW_COLOR_OVERRIDE, this.getGlowColorOverride());
        var0.storeNullable(TAG_BRIGHTNESS, Brightness.CODEC, this.getBrightnessOverride());
    }

    public AABB getBoundingBoxForCulling() {
        return this.cullingBoundingBox;
    }

    public boolean affectedByCulling() {
        return !this.noCulling;
    }

    @Override
    public PushReaction getPistonPushReaction() {
        return PushReaction.IGNORE;
    }

    @Override
    public boolean isIgnoringBlockTriggers() {
        return true;
    }

    public @Nullable RenderState renderState() {
        return this.renderState;
    }

    public void setTransformationInterpolationDuration(int var0) {
        this.entityData.set(DATA_TRANSFORMATION_INTERPOLATION_DURATION_ID, var0);
    }

    public int getTransformationInterpolationDuration() {
        return this.entityData.get(DATA_TRANSFORMATION_INTERPOLATION_DURATION_ID);
    }

    public void setTransformationInterpolationDelay(int var0) {
        this.entityData.set(DATA_TRANSFORMATION_INTERPOLATION_START_DELTA_TICKS_ID, var0, true);
    }

    public int getTransformationInterpolationDelay() {
        return this.entityData.get(DATA_TRANSFORMATION_INTERPOLATION_START_DELTA_TICKS_ID);
    }

    private void setPosRotInterpolationDuration(int var0) {
        this.entityData.set(DATA_POS_ROT_INTERPOLATION_DURATION_ID, var0);
    }

    private int getPosRotInterpolationDuration() {
        return this.entityData.get(DATA_POS_ROT_INTERPOLATION_DURATION_ID);
    }

    public void setBillboardConstraints(BillboardConstraints var0) {
        this.entityData.set(DATA_BILLBOARD_RENDER_CONSTRAINTS_ID, var0.getId());
    }

    public BillboardConstraints getBillboardConstraints() {
        return BillboardConstraints.BY_ID.apply(this.entityData.get(DATA_BILLBOARD_RENDER_CONSTRAINTS_ID).byteValue());
    }

    public void setBrightnessOverride(@Nullable Brightness var0) {
        this.entityData.set(DATA_BRIGHTNESS_OVERRIDE_ID, var0 != null ? var0.pack() : -1);
    }

    public @Nullable Brightness getBrightnessOverride() {
        int var0 = this.entityData.get(DATA_BRIGHTNESS_OVERRIDE_ID);
        return var0 != -1 ? Brightness.unpack(var0) : null;
    }

    private int getPackedBrightnessOverride() {
        return this.entityData.get(DATA_BRIGHTNESS_OVERRIDE_ID);
    }

    public void setViewRange(float var0) {
        this.entityData.set(DATA_VIEW_RANGE_ID, Float.valueOf(var0));
    }

    public float getViewRange() {
        return this.entityData.get(DATA_VIEW_RANGE_ID).floatValue();
    }

    public void setShadowRadius(float var0) {
        this.entityData.set(DATA_SHADOW_RADIUS_ID, Float.valueOf(var0));
    }

    public float getShadowRadius() {
        return this.entityData.get(DATA_SHADOW_RADIUS_ID).floatValue();
    }

    public void setShadowStrength(float var0) {
        this.entityData.set(DATA_SHADOW_STRENGTH_ID, Float.valueOf(var0));
    }

    public float getShadowStrength() {
        return this.entityData.get(DATA_SHADOW_STRENGTH_ID).floatValue();
    }

    public void setWidth(float var0) {
        this.entityData.set(DATA_WIDTH_ID, Float.valueOf(var0));
    }

    public float getWidth() {
        return this.entityData.get(DATA_WIDTH_ID).floatValue();
    }

    public void setHeight(float var0) {
        this.entityData.set(DATA_HEIGHT_ID, Float.valueOf(var0));
    }

    public int getGlowColorOverride() {
        return this.entityData.get(DATA_GLOW_COLOR_OVERRIDE_ID);
    }

    public void setGlowColorOverride(int var0) {
        this.entityData.set(DATA_GLOW_COLOR_OVERRIDE_ID, var0);
    }

    public float calculateInterpolationProgress(float var0) {
        float var4;
        int var1 = this.interpolationDuration;
        if (var1 <= 0) {
            return 1.0f;
        }
        float var2 = (long)this.tickCount - this.interpolationStartClientTick;
        float var3 = var2 + var0;
        this.lastProgress = var4 = Mth.clamp(Mth.inverseLerp(var3, 0.0f, var1), 0.0f, 1.0f);
        return var4;
    }

    public float getHeight() {
        return this.entityData.get(DATA_HEIGHT_ID).floatValue();
    }

    @Override
    public void setPos(double var0, double var2, double var4) {
        super.setPos(var0, var2, var4);
        this.updateCulling();
    }

    private void updateCulling() {
        float var0 = this.getWidth();
        float var1 = this.getHeight();
        this.noCulling = var0 == 0.0f || var1 == 0.0f;
        float var2 = var0 / 2.0f;
        double var3 = this.getX();
        double var5 = this.getY();
        double var7 = this.getZ();
        this.cullingBoundingBox = new AABB(var3 - (double)var2, var5, var7 - (double)var2, var3 + (double)var2, var5 + (double)var1, var7 + (double)var2);
    }

    @Override
    public boolean shouldRenderAtSqrDistance(double var0) {
        return var0 < Mth.square((double)this.getViewRange() * 64.0 * Display.getViewScale());
    }

    @Override
    public int getTeamColor() {
        int var0 = this.getGlowColorOverride();
        return var0 != -1 ? var0 : super.getTeamColor();
    }

    private RenderState createFreshRenderState() {
        return new RenderState(GenericInterpolator.constant(Display.createTransformation(this.entityData)), this.getBillboardConstraints(), this.getPackedBrightnessOverride(), FloatInterpolator.constant(this.getShadowRadius()), FloatInterpolator.constant(this.getShadowStrength()), this.getGlowColorOverride());
    }

    private RenderState createInterpolatedRenderState(RenderState var0, float var1) {
        Transformation var2 = var0.transformation.get(var1);
        float var3 = var0.shadowRadius.get(var1);
        float var4 = var0.shadowStrength.get(var1);
        return new RenderState(new TransformationInterpolator(var2, Display.createTransformation(this.entityData)), this.getBillboardConstraints(), this.getPackedBrightnessOverride(), new LinearFloatInterpolator(var3, this.getShadowRadius()), new LinearFloatInterpolator(var4, this.getShadowStrength()), this.getGlowColorOverride());
    }

    public static final class RenderState
    extends Record {
        final GenericInterpolator<Transformation> transformation;
        private final BillboardConstraints billboardConstraints;
        private final int brightnessOverride;
        final FloatInterpolator shadowRadius;
        final FloatInterpolator shadowStrength;
        private final int glowColorOverride;

        public RenderState(GenericInterpolator<Transformation> var0, BillboardConstraints var1, int var2, FloatInterpolator var3, FloatInterpolator var4, int var5) {
            this.transformation = var0;
            this.billboardConstraints = var1;
            this.brightnessOverride = var2;
            this.shadowRadius = var3;
            this.shadowStrength = var4;
            this.glowColorOverride = var5;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{RenderState.class, "transformation;billboardConstraints;brightnessOverride;shadowRadius;shadowStrength;glowColorOverride", "transformation", "billboardConstraints", "brightnessOverride", "shadowRadius", "shadowStrength", "glowColorOverride"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{RenderState.class, "transformation;billboardConstraints;brightnessOverride;shadowRadius;shadowStrength;glowColorOverride", "transformation", "billboardConstraints", "brightnessOverride", "shadowRadius", "shadowStrength", "glowColorOverride"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{RenderState.class, "transformation;billboardConstraints;brightnessOverride;shadowRadius;shadowStrength;glowColorOverride", "transformation", "billboardConstraints", "brightnessOverride", "shadowRadius", "shadowStrength", "glowColorOverride"}, this, var0);
        }

        public GenericInterpolator<Transformation> transformation() {
            return this.transformation;
        }

        public BillboardConstraints billboardConstraints() {
            return this.billboardConstraints;
        }

        public int brightnessOverride() {
            return this.brightnessOverride;
        }

        public FloatInterpolator shadowRadius() {
            return this.shadowRadius;
        }

        public FloatInterpolator shadowStrength() {
            return this.shadowStrength;
        }

        public int glowColorOverride() {
            return this.glowColorOverride;
        }
    }

    public static enum BillboardConstraints implements StringRepresentable
    {
        FIXED(0, "fixed"),
        VERTICAL(1, "vertical"),
        HORIZONTAL(2, "horizontal"),
        CENTER(3, "center");

        public static final Codec<BillboardConstraints> CODEC;
        public static final IntFunction<BillboardConstraints> BY_ID;
        private final byte id;
        private final String name;

        private BillboardConstraints(byte var2, String var3) {
            this.name = var3;
            this.id = var2;
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        byte getId() {
            return this.id;
        }

        static {
            CODEC = StringRepresentable.fromEnum(BillboardConstraints::values);
            BY_ID = ByIdMap.continuous(BillboardConstraints::getId, BillboardConstraints.values(), ByIdMap.OutOfBoundsStrategy.ZERO);
        }
    }

    @FunctionalInterface
    public static interface GenericInterpolator<T> {
        public static <T> GenericInterpolator<T> constant(T var0) {
            return var1 -> var0;
        }

        public T get(float var1);
    }

    @FunctionalInterface
    public static interface FloatInterpolator {
        public static FloatInterpolator constant(float var0) {
            return var1 -> var0;
        }

        public float get(float var1);
    }

    record TransformationInterpolator(Transformation previous, Transformation current) implements GenericInterpolator<Transformation>
    {
        @Override
        public Transformation get(float var0) {
            if ((double)var0 >= 1.0) {
                return this.current;
            }
            return this.previous.slerp(this.current, var0);
        }

        @Override
        public /* synthetic */ Object get(float f) {
            return this.get(f);
        }
    }

    record LinearFloatInterpolator(float previous, float current) implements FloatInterpolator
    {
        @Override
        public float get(float var0) {
            return Mth.lerp(var0, this.previous, this.current);
        }
    }

    record ColorInterpolator(int previous, int current) implements IntInterpolator
    {
        @Override
        public int get(float var0) {
            return ARGB.srgbLerp(var0, this.previous, this.current);
        }
    }

    record LinearIntInterpolator(int previous, int current) implements IntInterpolator
    {
        @Override
        public int get(float var0) {
            return Mth.lerpInt(var0, this.previous, this.current);
        }
    }

    @FunctionalInterface
    public static interface IntInterpolator {
        public static IntInterpolator constant(int var0) {
            return var1 -> var0;
        }

        public int get(float var1);
    }

    public static class TextDisplay
    extends Display {
        public static final String TAG_TEXT = "text";
        private static final String TAG_LINE_WIDTH = "line_width";
        private static final String TAG_TEXT_OPACITY = "text_opacity";
        private static final String TAG_BACKGROUND_COLOR = "background";
        private static final String TAG_SHADOW = "shadow";
        private static final String TAG_SEE_THROUGH = "see_through";
        private static final String TAG_USE_DEFAULT_BACKGROUND = "default_background";
        private static final String TAG_ALIGNMENT = "alignment";
        public static final byte FLAG_SHADOW = 1;
        public static final byte FLAG_SEE_THROUGH = 2;
        public static final byte FLAG_USE_DEFAULT_BACKGROUND = 4;
        public static final byte FLAG_ALIGN_LEFT = 8;
        public static final byte FLAG_ALIGN_RIGHT = 16;
        private static final byte INITIAL_TEXT_OPACITY = -1;
        public static final int INITIAL_BACKGROUND = 0x40000000;
        private static final int INITIAL_LINE_WIDTH = 200;
        private static final EntityDataAccessor<Component> DATA_TEXT_ID = SynchedEntityData.defineId(TextDisplay.class, EntityDataSerializers.COMPONENT);
        public static final EntityDataAccessor<Integer> DATA_LINE_WIDTH_ID = SynchedEntityData.defineId(TextDisplay.class, EntityDataSerializers.INT);
        public static final EntityDataAccessor<Integer> DATA_BACKGROUND_COLOR_ID = SynchedEntityData.defineId(TextDisplay.class, EntityDataSerializers.INT);
        private static final EntityDataAccessor<Byte> DATA_TEXT_OPACITY_ID = SynchedEntityData.defineId(TextDisplay.class, EntityDataSerializers.BYTE);
        private static final EntityDataAccessor<Byte> DATA_STYLE_FLAGS_ID = SynchedEntityData.defineId(TextDisplay.class, EntityDataSerializers.BYTE);
        private static final IntSet TEXT_RENDER_STATE_IDS = IntSet.of((int[])new int[]{DATA_TEXT_ID.id(), DATA_LINE_WIDTH_ID.id(), DATA_BACKGROUND_COLOR_ID.id(), DATA_TEXT_OPACITY_ID.id(), DATA_STYLE_FLAGS_ID.id()});
        private @Nullable CachedInfo clientDisplayCache;
        private @Nullable TextRenderState textRenderState;

        public TextDisplay(EntityType<?> var0, Level var1) {
            super(var0, var1);
        }

        @Override
        protected void defineSynchedData(SynchedEntityData.Builder var0) {
            super.defineSynchedData(var0);
            var0.define(DATA_TEXT_ID, Component.empty());
            var0.define(DATA_LINE_WIDTH_ID, 200);
            var0.define(DATA_BACKGROUND_COLOR_ID, 0x40000000);
            var0.define(DATA_TEXT_OPACITY_ID, (byte)-1);
            var0.define(DATA_STYLE_FLAGS_ID, (byte)0);
        }

        @Override
        public void onSyncedDataUpdated(EntityDataAccessor<?> var0) {
            super.onSyncedDataUpdated(var0);
            if (TEXT_RENDER_STATE_IDS.contains(var0.id())) {
                this.updateRenderState = true;
            }
        }

        public Component getText() {
            return this.entityData.get(DATA_TEXT_ID);
        }

        public void setText(Component var0) {
            this.entityData.set(DATA_TEXT_ID, var0);
        }

        public int getLineWidth() {
            return this.entityData.get(DATA_LINE_WIDTH_ID);
        }

        private void setLineWidth(int var0) {
            this.entityData.set(DATA_LINE_WIDTH_ID, var0);
        }

        public byte getTextOpacity() {
            return this.entityData.get(DATA_TEXT_OPACITY_ID);
        }

        public void setTextOpacity(byte var0) {
            this.entityData.set(DATA_TEXT_OPACITY_ID, var0);
        }

        public int getBackgroundColor() {
            return this.entityData.get(DATA_BACKGROUND_COLOR_ID);
        }

        private void setBackgroundColor(int var0) {
            this.entityData.set(DATA_BACKGROUND_COLOR_ID, var0);
        }

        public byte getFlags() {
            return this.entityData.get(DATA_STYLE_FLAGS_ID);
        }

        public void setFlags(byte var0) {
            this.entityData.set(DATA_STYLE_FLAGS_ID, var0);
        }

        private static byte loadFlag(byte var0, ValueInput var1, String var2, byte var3) {
            if (var1.getBooleanOr(var2, false)) {
                return (byte)(var0 | var3);
            }
            return var0;
        }

        @Override
        protected void readAdditionalSaveData(ValueInput var0) {
            super.readAdditionalSaveData(var0);
            this.setLineWidth(var0.getIntOr(TAG_LINE_WIDTH, 200));
            this.setTextOpacity(var0.getByteOr(TAG_TEXT_OPACITY, (byte)-1));
            this.setBackgroundColor(var0.getIntOr(TAG_BACKGROUND_COLOR, 0x40000000));
            byte var1 = TextDisplay.loadFlag((byte)0, var0, TAG_SHADOW, (byte)1);
            var1 = TextDisplay.loadFlag(var1, var0, TAG_SEE_THROUGH, (byte)2);
            var1 = TextDisplay.loadFlag(var1, var0, TAG_USE_DEFAULT_BACKGROUND, (byte)4);
            Optional<Align> var2 = var0.read(TAG_ALIGNMENT, Align.CODEC);
            if (var2.isPresent()) {
                var1 = switch (var2.get().ordinal()) {
                    default -> throw new MatchException(null, null);
                    case 0 -> var1;
                    case 1 -> (byte)(var1 | 8);
                    case 2 -> (byte)(var1 | 0x10);
                };
            }
            this.setFlags(var1);
            Optional<Component> var3 = var0.read(TAG_TEXT, ComponentSerialization.CODEC);
            if (var3.isPresent()) {
                try {
                    Level level = this.level();
                    if (level instanceof ServerLevel) {
                        ServerLevel var4 = (ServerLevel)level;
                        CommandSourceStack var5 = this.createCommandSourceStackForNameResolution(var4).withPermission(LevelBasedPermissionSet.GAMEMASTER);
                        MutableComponent var6 = ComponentUtils.updateForEntity(var5, var3.get(), (Entity)this, 0);
                        this.setText(var6);
                    } else {
                        this.setText(Component.empty());
                    }
                }
                catch (Exception var4) {
                    LOGGER.warn("Failed to parse display entity text {}", var3, (Object)var4);
                }
            }
        }

        private static void storeFlag(byte var0, ValueOutput var1, String var2, byte var3) {
            var1.putBoolean(var2, (var0 & var3) != 0);
        }

        @Override
        protected void addAdditionalSaveData(ValueOutput var0) {
            super.addAdditionalSaveData(var0);
            var0.store(TAG_TEXT, ComponentSerialization.CODEC, this.getText());
            var0.putInt(TAG_LINE_WIDTH, this.getLineWidth());
            var0.putInt(TAG_BACKGROUND_COLOR, this.getBackgroundColor());
            var0.putByte(TAG_TEXT_OPACITY, this.getTextOpacity());
            byte var1 = this.getFlags();
            TextDisplay.storeFlag(var1, var0, TAG_SHADOW, (byte)1);
            TextDisplay.storeFlag(var1, var0, TAG_SEE_THROUGH, (byte)2);
            TextDisplay.storeFlag(var1, var0, TAG_USE_DEFAULT_BACKGROUND, (byte)4);
            var0.store(TAG_ALIGNMENT, Align.CODEC, TextDisplay.getAlign(var1));
        }

        @Override
        protected void updateRenderSubState(boolean var0, float var1) {
            this.textRenderState = var0 && this.textRenderState != null ? this.createInterpolatedTextRenderState(this.textRenderState, var1) : this.createFreshTextRenderState();
            this.clientDisplayCache = null;
        }

        public @Nullable TextRenderState textRenderState() {
            return this.textRenderState;
        }

        private TextRenderState createFreshTextRenderState() {
            return new TextRenderState(this.getText(), this.getLineWidth(), IntInterpolator.constant(this.getTextOpacity()), IntInterpolator.constant(this.getBackgroundColor()), this.getFlags());
        }

        private TextRenderState createInterpolatedTextRenderState(TextRenderState var0, float var1) {
            int var2 = var0.backgroundColor.get(var1);
            int var3 = var0.textOpacity.get(var1);
            return new TextRenderState(this.getText(), this.getLineWidth(), new LinearIntInterpolator(var3, this.getTextOpacity()), new ColorInterpolator(var2, this.getBackgroundColor()), this.getFlags());
        }

        public CachedInfo cacheDisplay(LineSplitter var0) {
            if (this.clientDisplayCache == null) {
                this.clientDisplayCache = this.textRenderState != null ? var0.split(this.textRenderState.text(), this.textRenderState.lineWidth()) : new CachedInfo(List.of(), 0);
            }
            return this.clientDisplayCache;
        }

        public static Align getAlign(byte var0) {
            if ((var0 & 8) != 0) {
                return Align.LEFT;
            }
            if ((var0 & 0x10) != 0) {
                return Align.RIGHT;
            }
            return Align.CENTER;
        }

        public static enum Align implements StringRepresentable
        {
            CENTER("center"),
            LEFT("left"),
            RIGHT("right");

            public static final Codec<Align> CODEC;
            private final String name;

            private Align(String var2) {
                this.name = var2;
            }

            @Override
            public String getSerializedName() {
                return this.name;
            }

            static {
                CODEC = StringRepresentable.fromEnum(Align::values);
            }
        }

        public static final class TextRenderState
        extends Record {
            private final Component text;
            private final int lineWidth;
            final IntInterpolator textOpacity;
            final IntInterpolator backgroundColor;
            private final byte flags;

            public TextRenderState(Component var0, int var1, IntInterpolator var2, IntInterpolator var3, byte var4) {
                this.text = var0;
                this.lineWidth = var1;
                this.textOpacity = var2;
                this.backgroundColor = var3;
                this.flags = var4;
            }

            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{TextRenderState.class, "text;lineWidth;textOpacity;backgroundColor;flags", "text", "lineWidth", "textOpacity", "backgroundColor", "flags"}, this);
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{TextRenderState.class, "text;lineWidth;textOpacity;backgroundColor;flags", "text", "lineWidth", "textOpacity", "backgroundColor", "flags"}, this);
            }

            @Override
            public final boolean equals(Object var0) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{TextRenderState.class, "text;lineWidth;textOpacity;backgroundColor;flags", "text", "lineWidth", "textOpacity", "backgroundColor", "flags"}, this, var0);
            }

            public Component text() {
                return this.text;
            }

            public int lineWidth() {
                return this.lineWidth;
            }

            public IntInterpolator textOpacity() {
                return this.textOpacity;
            }

            public IntInterpolator backgroundColor() {
                return this.backgroundColor;
            }

            public byte flags() {
                return this.flags;
            }
        }

        public record CachedInfo(List<CachedLine> lines, int width) {
        }

        @FunctionalInterface
        public static interface LineSplitter {
            public CachedInfo split(Component var1, int var2);
        }

        public record CachedLine(FormattedCharSequence contents, int width) {
        }
    }

    public static class BlockDisplay
    extends Display {
        public static final String TAG_BLOCK_STATE = "block_state";
        private static final EntityDataAccessor<BlockState> DATA_BLOCK_STATE_ID = SynchedEntityData.defineId(BlockDisplay.class, EntityDataSerializers.BLOCK_STATE);
        private @Nullable BlockRenderState blockRenderState;

        public BlockDisplay(EntityType<?> var0, Level var1) {
            super(var0, var1);
        }

        @Override
        protected void defineSynchedData(SynchedEntityData.Builder var0) {
            super.defineSynchedData(var0);
            var0.define(DATA_BLOCK_STATE_ID, Blocks.AIR.defaultBlockState());
        }

        @Override
        public void onSyncedDataUpdated(EntityDataAccessor<?> var0) {
            super.onSyncedDataUpdated(var0);
            if (var0.equals(DATA_BLOCK_STATE_ID)) {
                this.updateRenderState = true;
            }
        }

        public BlockState getBlockState() {
            return this.entityData.get(DATA_BLOCK_STATE_ID);
        }

        public void setBlockState(BlockState var0) {
            this.entityData.set(DATA_BLOCK_STATE_ID, var0);
        }

        @Override
        protected void readAdditionalSaveData(ValueInput var0) {
            super.readAdditionalSaveData(var0);
            this.setBlockState(var0.read(TAG_BLOCK_STATE, BlockState.CODEC).orElse(Blocks.AIR.defaultBlockState()));
        }

        @Override
        protected void addAdditionalSaveData(ValueOutput var0) {
            super.addAdditionalSaveData(var0);
            var0.store(TAG_BLOCK_STATE, BlockState.CODEC, this.getBlockState());
        }

        public @Nullable BlockRenderState blockRenderState() {
            return this.blockRenderState;
        }

        @Override
        protected void updateRenderSubState(boolean var0, float var1) {
            this.blockRenderState = new BlockRenderState(this.getBlockState());
        }

        public record BlockRenderState(BlockState blockState) {
        }
    }

    public static class ItemDisplay
    extends Display {
        private static final String TAG_ITEM = "item";
        private static final String TAG_ITEM_DISPLAY = "item_display";
        private static final EntityDataAccessor<ItemStack> DATA_ITEM_STACK_ID = SynchedEntityData.defineId(ItemDisplay.class, EntityDataSerializers.ITEM_STACK);
        private static final EntityDataAccessor<Byte> DATA_ITEM_DISPLAY_ID = SynchedEntityData.defineId(ItemDisplay.class, EntityDataSerializers.BYTE);
        private final SlotAccess slot = SlotAccess.of(this::getItemStack, this::setItemStack);
        private @Nullable ItemRenderState itemRenderState;

        public ItemDisplay(EntityType<?> var0, Level var1) {
            super(var0, var1);
        }

        @Override
        protected void defineSynchedData(SynchedEntityData.Builder var0) {
            super.defineSynchedData(var0);
            var0.define(DATA_ITEM_STACK_ID, ItemStack.EMPTY);
            var0.define(DATA_ITEM_DISPLAY_ID, ItemDisplayContext.NONE.getId());
        }

        @Override
        public void onSyncedDataUpdated(EntityDataAccessor<?> var0) {
            super.onSyncedDataUpdated(var0);
            if (DATA_ITEM_STACK_ID.equals(var0) || DATA_ITEM_DISPLAY_ID.equals(var0)) {
                this.updateRenderState = true;
            }
        }

        public ItemStack getItemStack() {
            return this.entityData.get(DATA_ITEM_STACK_ID);
        }

        public void setItemStack(ItemStack var0) {
            this.entityData.set(DATA_ITEM_STACK_ID, var0);
        }

        public void setItemTransform(ItemDisplayContext var0) {
            this.entityData.set(DATA_ITEM_DISPLAY_ID, var0.getId());
        }

        public ItemDisplayContext getItemTransform() {
            return ItemDisplayContext.BY_ID.apply(this.entityData.get(DATA_ITEM_DISPLAY_ID).byteValue());
        }

        @Override
        protected void readAdditionalSaveData(ValueInput var0) {
            super.readAdditionalSaveData(var0);
            this.setItemStack(var0.read(TAG_ITEM, ItemStack.CODEC).orElse(ItemStack.EMPTY));
            this.setItemTransform(var0.read(TAG_ITEM_DISPLAY, ItemDisplayContext.CODEC).orElse(ItemDisplayContext.NONE));
        }

        @Override
        protected void addAdditionalSaveData(ValueOutput var0) {
            super.addAdditionalSaveData(var0);
            ItemStack var1 = this.getItemStack();
            if (!var1.isEmpty()) {
                var0.store(TAG_ITEM, ItemStack.CODEC, var1);
            }
            var0.store(TAG_ITEM_DISPLAY, ItemDisplayContext.CODEC, this.getItemTransform());
        }

        @Override
        public @Nullable SlotAccess getSlot(int var0) {
            if (var0 == 0) {
                return this.slot;
            }
            return null;
        }

        public @Nullable ItemRenderState itemRenderState() {
            return this.itemRenderState;
        }

        @Override
        protected void updateRenderSubState(boolean var0, float var1) {
            ItemStack var2 = this.getItemStack();
            var2.setEntityRepresentation(this);
            this.itemRenderState = new ItemRenderState(var2, this.getItemTransform());
        }

        public record ItemRenderState(ItemStack itemStack, ItemDisplayContext itemTransform) {
        }
    }
}

