/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public class ElytraAnimationState {
    private static final float DEFAULT_X_ROT = 0.2617994f;
    private static final float DEFAULT_Z_ROT = -0.2617994f;
    private float rotX;
    private float rotY;
    private float rotZ;
    private float rotXOld;
    private float rotYOld;
    private float rotZOld;
    private final LivingEntity entity;

    public ElytraAnimationState(LivingEntity var0) {
        this.entity = var0;
    }

    public void tick() {
        float var2;
        float var1;
        float var0;
        this.rotXOld = this.rotX;
        this.rotYOld = this.rotY;
        this.rotZOld = this.rotZ;
        if (this.entity.isFallFlying()) {
            float var3 = 1.0f;
            Vec3 var4 = this.entity.getDeltaMovement();
            if (var4.y < 0.0) {
                Vec3 var5 = var4.normalize();
                var3 = 1.0f - (float)Math.pow(-var5.y, 1.5);
            }
            var0 = Mth.lerp(var3, 0.2617994f, 0.34906584f);
            var1 = Mth.lerp(var3, -0.2617994f, -1.5707964f);
            var2 = 0.0f;
        } else if (this.entity.isCrouching()) {
            var0 = 0.6981317f;
            var1 = -0.7853982f;
            var2 = 0.08726646f;
        } else {
            var0 = 0.2617994f;
            var1 = -0.2617994f;
            var2 = 0.0f;
        }
        this.rotX += (var0 - this.rotX) * 0.3f;
        this.rotY += (var2 - this.rotY) * 0.3f;
        this.rotZ += (var1 - this.rotZ) * 0.3f;
    }

    public float getRotX(float var0) {
        return Mth.lerp(var0, this.rotXOld, this.rotX);
    }

    public float getRotY(float var0) {
        return Mth.lerp(var0, this.rotYOld, this.rotY);
    }

    public float getRotZ(float var0) {
        return Mth.lerp(var0, this.rotZOld, this.rotZ);
    }
}

