/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import net.minecraft.world.entity.EntityAttachments;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public record EntityDimensions(float width, float height, float eyeHeight, EntityAttachments attachments, boolean fixed) {
    private EntityDimensions(float var0, float var1, boolean var2) {
        this(var0, var1, EntityDimensions.defaultEyeHeight(var1), EntityAttachments.createDefault(var0, var1), var2);
    }

    private static float defaultEyeHeight(float var0) {
        return var0 * 0.85f;
    }

    public AABB makeBoundingBox(Vec3 var0) {
        return this.makeBoundingBox(var0.x, var0.y, var0.z);
    }

    public AABB makeBoundingBox(double var0, double var2, double var4) {
        float var6 = this.width / 2.0f;
        float var7 = this.height;
        return new AABB(var0 - (double)var6, var2, var4 - (double)var6, var0 + (double)var6, var2 + (double)var7, var4 + (double)var6);
    }

    public EntityDimensions scale(float var0) {
        return this.scale(var0, var0);
    }

    public EntityDimensions scale(float var0, float var1) {
        if (this.fixed || var0 == 1.0f && var1 == 1.0f) {
            return this;
        }
        return new EntityDimensions(this.width * var0, this.height * var1, this.eyeHeight * var1, this.attachments.scale(var0, var1, var0), false);
    }

    public static EntityDimensions scalable(float var0, float var1) {
        return new EntityDimensions(var0, var1, false);
    }

    public static EntityDimensions fixed(float var0, float var1) {
        return new EntityDimensions(var0, var1, true);
    }

    public EntityDimensions withEyeHeight(float var0) {
        return new EntityDimensions(this.width, this.height, var0, this.attachments, this.fixed);
    }

    public EntityDimensions withAttachments(EntityAttachments.Builder var0) {
        return new EntityDimensions(this.width, this.height, this.eyeHeight, var0.build(this.width, this.height), this.fixed);
    }
}

