/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import java.util.Optional;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.bukkit.event.entity.EntityTargetEvent;
import org.jspecify.annotations.Nullable;

public interface NeutralMob {
    public static final String TAG_ANGER_END_TIME = "anger_end_time";
    public static final String TAG_ANGRY_AT = "angry_at";
    public static final long NO_ANGER_END_TIME = -1L;

    public long getPersistentAngerEndTime();

    default public void setTimeToRemainAngry(long i) {
        this.setPersistentAngerEndTime(this.level().getGameTime() + i);
    }

    public void setPersistentAngerEndTime(long var1);

    public @Nullable EntityReference<LivingEntity> getPersistentAngerTarget();

    public void setPersistentAngerTarget(@Nullable EntityReference<LivingEntity> var1);

    public void startPersistentAngerTimer();

    public Level level();

    default public void addPersistentAngerSaveData(ValueOutput valueoutput) {
        valueoutput.putLong(TAG_ANGER_END_TIME, this.getPersistentAngerEndTime());
        valueoutput.storeNullable(TAG_ANGRY_AT, EntityReference.codec(), this.getPersistentAngerTarget());
    }

    default public void readPersistentAngerSaveData(Level world, ValueInput valueinput) {
        Optional<Long> optional = valueinput.getLong(TAG_ANGER_END_TIME);
        if (optional.isPresent()) {
            this.setPersistentAngerEndTime(optional.get());
        } else {
            Optional<Integer> optional1 = valueinput.getInt("AngerTime");
            if (optional1.isPresent()) {
                this.setTimeToRemainAngry(optional1.get().intValue());
            } else {
                this.setPersistentAngerEndTime(-1L);
            }
        }
        if (world instanceof ServerLevel) {
            this.setPersistentAngerTarget(EntityReference.read(valueinput, TAG_ANGRY_AT));
            this.setTarget(EntityReference.getLivingEntity(this.getPersistentAngerTarget(), world), EntityTargetEvent.TargetReason.UNKNOWN, false);
        }
    }

    default public void updatePersistentAnger(ServerLevel worldserver, boolean flag) {
        LivingEntity entityliving = this.getTarget();
        EntityReference<LivingEntity> entityreference = this.getPersistentAngerTarget();
        if (entityliving != null && entityliving.isDeadOrDying() && entityreference != null && entityreference.matches(entityliving) && entityliving instanceof Mob) {
            this.stopBeingAngry();
        } else {
            if (entityliving != null) {
                if (entityreference == null || !entityreference.matches(entityliving)) {
                    this.setPersistentAngerTarget(EntityReference.of(entityliving));
                }
                this.startPersistentAngerTimer();
            }
            if (!(entityreference == null || this.isAngry() || entityliving != null && NeutralMob.isValidPlayerTarget(entityliving) && flag)) {
                this.stopBeingAngry();
            }
        }
    }

    private static boolean isValidPlayerTarget(LivingEntity entityliving) {
        Player entityhuman;
        if (entityliving instanceof Player && !(entityhuman = (Player)entityliving).isCreative() && !entityhuman.isSpectator()) {
            boolean flag = true;
            return flag;
        }
        boolean flag = false;
        return flag;
    }

    default public boolean isAngryAt(LivingEntity entityliving, ServerLevel worldserver) {
        if (!this.canAttack(entityliving)) {
            return false;
        }
        if (NeutralMob.isValidPlayerTarget(entityliving) && this.isAngryAtAllPlayers(worldserver)) {
            return true;
        }
        EntityReference<LivingEntity> entityreference = this.getPersistentAngerTarget();
        return entityreference != null && entityreference.matches(entityliving);
    }

    default public boolean isAngryAtAllPlayers(ServerLevel worldserver) {
        return worldserver.getGameRules().get(GameRules.UNIVERSAL_ANGER) != false && this.isAngry() && this.getPersistentAngerTarget() == null;
    }

    default public boolean isAngry() {
        long i = this.getPersistentAngerEndTime();
        if (i > 0L) {
            long j = i - this.level().getGameTime();
            return j > 0L;
        }
        return false;
    }

    default public void playerDied(ServerLevel worldserver, Player entityhuman) {
        EntityReference<LivingEntity> entityreference;
        if (worldserver.getGameRules().get(GameRules.FORGIVE_DEAD_PLAYERS).booleanValue() && (entityreference = this.getPersistentAngerTarget()) != null && entityreference.matches(entityhuman)) {
            this.stopBeingAngry();
        }
    }

    default public void forgetCurrentTargetAndRefreshUniversalAnger() {
        this.stopBeingAngry();
        this.startPersistentAngerTimer();
    }

    default public void stopBeingAngry() {
        this.setLastHurtByMob(null);
        this.setPersistentAngerTarget(null);
        this.setTarget(null, EntityTargetEvent.TargetReason.FORGOT_TARGET, true);
        this.setPersistentAngerEndTime(-1L);
    }

    public @Nullable LivingEntity getLastHurtByMob();

    public void setLastHurtByMob(@Nullable LivingEntity var1);

    public void setTarget(@Nullable LivingEntity var1);

    public boolean setTarget(@Nullable LivingEntity var1, EntityTargetEvent.TargetReason var2, boolean var3);

    public boolean canAttack(LivingEntity var1);

    public @Nullable LivingEntity getTarget();
}

