/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.Portal;
import net.minecraft.world.level.portal.TeleportTransition;
import org.jspecify.annotations.Nullable;

public class PortalProcessor {
    private final Portal portal;
    private BlockPos entryPosition;
    private int portalTime;
    private boolean insidePortalThisTick;

    public PortalProcessor(Portal var0, BlockPos var1) {
        this.portal = var0;
        this.entryPosition = var1;
        this.insidePortalThisTick = true;
    }

    public boolean processPortalTeleportation(ServerLevel var0, Entity var1, boolean var2) {
        if (this.insidePortalThisTick) {
            this.insidePortalThisTick = false;
            return var2 && this.portalTime++ >= this.portal.getPortalTransitionTime(var0, var1);
        }
        this.decayTick();
        return false;
    }

    public @Nullable TeleportTransition getPortalDestination(ServerLevel var0, Entity var1) {
        return this.portal.getPortalDestination(var0, var1, this.entryPosition);
    }

    public Portal.Transition getPortalLocalTransition() {
        return this.portal.getLocalTransition();
    }

    private void decayTick() {
        this.portalTime = Math.max(this.portalTime - 4, 0);
    }

    public boolean hasExpired() {
        return this.portalTime <= 0;
    }

    public BlockPos getEntryPosition() {
        return this.entryPosition;
    }

    public void updateEntryPosition(BlockPos var0) {
        this.entryPosition = var0;
    }

    public int getPortalTime() {
        return this.portalTime;
    }

    public boolean isInsidePortalThisTick() {
        return this.insidePortalThisTick;
    }

    public void setAsInsidePortalThisTick(boolean var0) {
        this.insidePortalThisTick = var0;
    }

    public boolean isSamePortal(Portal var0) {
        return this.portal == var0;
    }
}

