/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import net.minecraft.util.Mth;

public class WalkAnimationState {
    private float speedOld;
    private float speed;
    private float position;
    private float positionScale = 1.0f;

    public void setSpeed(float var0) {
        this.speed = var0;
    }

    public void update(float var0, float var1, float var2) {
        this.speedOld = this.speed;
        this.speed += (var0 - this.speed) * var1;
        this.position += this.speed;
        this.positionScale = var2;
    }

    public void stop() {
        this.speedOld = 0.0f;
        this.speed = 0.0f;
        this.position = 0.0f;
    }

    public float speed() {
        return this.speed;
    }

    public float speed(float var0) {
        return Math.min(Mth.lerp(var0, this.speedOld, this.speed), 1.0f);
    }

    public float position() {
        return this.position * this.positionScale;
    }

    public float position(float var0) {
        return (this.position - this.speed * (1.0f - var0)) * this.positionScale;
    }

    public boolean isMoving() {
        return this.speed > 1.0E-5f;
    }
}

