/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.attribute.EnvironmentAttribute;
import net.minecraft.world.attribute.EnvironmentAttributeSystem;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.memory.ExpirableValue;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class Brain<E extends LivingEntity> {
    static final Logger LOGGER = LogUtils.getLogger();
    private final Supplier<Codec<Brain<E>>> codec;
    private static final int SCHEDULE_UPDATE_DELAY = 20;
    private final Map<MemoryModuleType<?>, Optional<? extends ExpirableValue<?>>> memories = Maps.newHashMap();
    private final Map<SensorType<? extends Sensor<? super E>>, Sensor<? super E>> sensors = Maps.newLinkedHashMap();
    private final Map<Integer, Map<Activity, Set<BehaviorControl<? super E>>>> availableBehaviorsByPriority = Maps.newTreeMap();
    private @Nullable EnvironmentAttribute<Activity> schedule;
    private final Map<Activity, Set<Pair<MemoryModuleType<?>, MemoryStatus>>> activityRequirements = Maps.newHashMap();
    private final Map<Activity, Set<MemoryModuleType<?>>> activityMemoriesToEraseWhenStopped = Maps.newHashMap();
    private Set<Activity> coreActivities = Sets.newHashSet();
    private final Set<Activity> activeActivities = Sets.newHashSet();
    private Activity defaultActivity = Activity.IDLE;
    private long lastScheduleUpdate = -9999L;

    public static <E extends LivingEntity> Provider<E> provider(Collection<? extends MemoryModuleType<?>> var0, Collection<? extends SensorType<? extends Sensor<? super E>>> var1) {
        return new Provider(var0, var1);
    }

    public static <E extends LivingEntity> Codec<Brain<E>> codec(final Collection<? extends MemoryModuleType<?>> var0, final Collection<? extends SensorType<? extends Sensor<? super E>>> var1) {
        final MutableObject var2 = new MutableObject();
        var2.setValue((Object)new MapCodec<Brain<E>>(){

            public <T> Stream<T> keys(DynamicOps<T> var02) {
                return var0.stream().flatMap(var0 -> var0.getCodec().map(var1 -> BuiltInRegistries.MEMORY_MODULE_TYPE.getKey((MemoryModuleType<?>)var0)).stream()).map(var1 -> var02.createString(var1.toString()));
            }

            public <T> DataResult<Brain<E>> decode(DynamicOps<T> var02, MapLike<T> var12) {
                MutableObject var22 = new MutableObject((Object)DataResult.success((Object)ImmutableList.builder()));
                var12.entries().forEach(var22 -> {
                    DataResult var3 = BuiltInRegistries.MEMORY_MODULE_TYPE.byNameCodec().parse(var02, var22.getFirst());
                    DataResult var4 = var3.flatMap(var2 -> this.captureRead((MemoryModuleType)var2, var02, (Object)var22.getSecond()));
                    var22.setValue((Object)((DataResult)var22.get()).apply2(ImmutableList.Builder::add, var4));
                });
                ImmutableList var3 = ((DataResult)var22.get()).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).map(ImmutableList.Builder::build).orElseGet(ImmutableList::of);
                return DataResult.success(new Brain(var0, var1, (ImmutableList<MemoryValue<?>>)var3, var2));
            }

            private <T, U> DataResult<MemoryValue<U>> captureRead(MemoryModuleType<U> var02, DynamicOps<T> var12, T var22) {
                return var02.getCodec().map(DataResult::success).orElseGet(() -> DataResult.error(() -> "No codec for memory: " + String.valueOf(var02))).flatMap(var2 -> var2.parse(var12, var22)).map(var1 -> new MemoryValue(var02, Optional.of(var1)));
            }

            public <T> RecordBuilder<T> encode(Brain<E> var02, DynamicOps<T> var12, RecordBuilder<T> var22) {
                var02.memories().forEach(var2 -> var2.serialize(var12, var22));
                return var22;
            }

            public /* synthetic */ RecordBuilder encode(Object object, DynamicOps dynamicOps, RecordBuilder recordBuilder) {
                return this.encode((Brain)object, dynamicOps, recordBuilder);
            }
        }.fieldOf("memories").codec());
        return (Codec)var2.get();
    }

    public Brain(Collection<? extends MemoryModuleType<?>> var0, Collection<? extends SensorType<? extends Sensor<? super E>>> var1, ImmutableList<MemoryValue<?>> var2, Supplier<Codec<Brain<E>>> var3) {
        this.codec = var3;
        for (MemoryModuleType<?> memoryModuleType : var0) {
            this.memories.put(memoryModuleType, Optional.empty());
        }
        for (SensorType sensorType : var1) {
            this.sensors.put(sensorType, (Sensor<E>)sensorType.create());
        }
        for (Sensor sensor : this.sensors.values()) {
            for (MemoryModuleType<?> var7 : sensor.requires()) {
                this.memories.put(var7, Optional.empty());
            }
        }
        for (MemoryValue memoryValue : var2) {
            memoryValue.setMemoryInternal(this);
        }
    }

    public <T> DataResult<T> serializeStart(DynamicOps<T> var0) {
        return this.codec.get().encodeStart(var0, (Object)this);
    }

    Stream<MemoryValue<?>> memories() {
        return this.memories.entrySet().stream().map(var0 -> MemoryValue.createUnchecked((MemoryModuleType)var0.getKey(), (Optional)var0.getValue()));
    }

    public boolean hasMemoryValue(MemoryModuleType<?> var0) {
        return this.checkMemory(var0, MemoryStatus.VALUE_PRESENT);
    }

    public void clearMemories() {
        this.memories.keySet().forEach(var0 -> this.memories.put((MemoryModuleType<?>)var0, Optional.empty()));
    }

    public <U> void eraseMemory(MemoryModuleType<U> var0) {
        this.setMemory(var0, Optional.empty());
    }

    public <U> void setMemory(MemoryModuleType<U> var0, @Nullable U var1) {
        this.setMemory(var0, Optional.ofNullable(var1));
    }

    public <U> void setMemoryWithExpiry(MemoryModuleType<U> var0, U var1, long var2) {
        this.setMemoryInternal(var0, Optional.of(ExpirableValue.of(var1, var2)));
    }

    public <U> void setMemory(MemoryModuleType<U> var0, Optional<? extends U> var1) {
        this.setMemoryInternal(var0, var1.map(ExpirableValue::of));
    }

    <U> void setMemoryInternal(MemoryModuleType<U> var0, Optional<? extends ExpirableValue<?>> var1) {
        if (this.memories.containsKey(var0)) {
            if (var1.isPresent() && this.isEmptyCollection(var1.get().getValue())) {
                this.eraseMemory(var0);
            } else {
                this.memories.put(var0, var1);
            }
        }
    }

    public <U> Optional<U> getMemory(MemoryModuleType<U> var0) {
        Optional<ExpirableValue<?>> var1 = this.memories.get(var0);
        if (var1 == null) {
            throw new IllegalStateException("Unregistered memory fetched: " + String.valueOf(var0));
        }
        return var1.map(ExpirableValue::getValue);
    }

    public <U> @Nullable Optional<U> getMemoryInternal(MemoryModuleType<U> var0) {
        Optional<ExpirableValue<?>> var1 = this.memories.get(var0);
        if (var1 == null) {
            return null;
        }
        return var1.map(ExpirableValue::getValue);
    }

    public <U> long getTimeUntilExpiry(MemoryModuleType<U> var0) {
        Optional<ExpirableValue<?>> var1 = this.memories.get(var0);
        return var1.map(ExpirableValue::getTimeToLive).orElse(0L);
    }

    @Deprecated
    @VisibleForDebug
    public Map<MemoryModuleType<?>, Optional<? extends ExpirableValue<?>>> getMemories() {
        return this.memories;
    }

    public <U> boolean isMemoryValue(MemoryModuleType<U> var0, U var12) {
        if (!this.hasMemoryValue(var0)) {
            return false;
        }
        return this.getMemory(var0).filter(var1 -> var1.equals(var12)).isPresent();
    }

    public boolean checkMemory(MemoryModuleType<?> var0, MemoryStatus var1) {
        Optional<ExpirableValue<?>> var2 = this.memories.get(var0);
        if (var2 == null) {
            return false;
        }
        return var1 == MemoryStatus.REGISTERED || var1 == MemoryStatus.VALUE_PRESENT && var2.isPresent() || var1 == MemoryStatus.VALUE_ABSENT && var2.isEmpty();
    }

    public void setSchedule(EnvironmentAttribute<Activity> var0) {
        this.schedule = var0;
    }

    public void setCoreActivities(Set<Activity> var0) {
        this.coreActivities = var0;
    }

    @Deprecated
    @VisibleForDebug
    public Set<Activity> getActiveActivities() {
        return this.activeActivities;
    }

    @Deprecated
    @VisibleForDebug
    public List<BehaviorControl<? super E>> getRunningBehaviors() {
        ObjectArrayList var0 = new ObjectArrayList();
        for (Map<Activity, Set<BehaviorControl<E>>> var2 : this.availableBehaviorsByPriority.values()) {
            for (Set<BehaviorControl<E>> var4 : var2.values()) {
                for (BehaviorControl<E> var6 : var4) {
                    if (var6.getStatus() != Behavior.Status.RUNNING) continue;
                    var0.add(var6);
                }
            }
        }
        return var0;
    }

    public void useDefaultActivity() {
        this.setActiveActivity(this.defaultActivity);
    }

    public Optional<Activity> getActiveNonCoreActivity() {
        for (Activity var1 : this.activeActivities) {
            if (this.coreActivities.contains(var1)) continue;
            return Optional.of(var1);
        }
        return Optional.empty();
    }

    public void setActiveActivityIfPossible(Activity var0) {
        if (this.activityRequirementsAreMet(var0)) {
            this.setActiveActivity(var0);
        } else {
            this.useDefaultActivity();
        }
    }

    private void setActiveActivity(Activity var0) {
        if (this.isActive(var0)) {
            return;
        }
        this.eraseMemoriesForOtherActivitesThan(var0);
        this.activeActivities.clear();
        this.activeActivities.addAll(this.coreActivities);
        this.activeActivities.add(var0);
    }

    private void eraseMemoriesForOtherActivitesThan(Activity var0) {
        for (Activity var2 : this.activeActivities) {
            Set<MemoryModuleType<?>> var3;
            if (var2 == var0 || (var3 = this.activityMemoriesToEraseWhenStopped.get(var2)) == null) continue;
            for (MemoryModuleType<?> var5 : var3) {
                this.eraseMemory(var5);
            }
        }
    }

    public void updateActivityFromSchedule(EnvironmentAttributeSystem var0, long var1, Vec3 var3) {
        if (var1 - this.lastScheduleUpdate > 20L) {
            Activity var4;
            this.lastScheduleUpdate = var1;
            Activity activity = var4 = this.schedule != null ? var0.getValue(this.schedule, var3) : Activity.IDLE;
            if (!this.activeActivities.contains(var4)) {
                this.setActiveActivityIfPossible(var4);
            }
        }
    }

    public void setActiveActivityToFirstValid(List<Activity> var0) {
        for (Activity var2 : var0) {
            if (!this.activityRequirementsAreMet(var2)) continue;
            this.setActiveActivity(var2);
            break;
        }
    }

    public void setDefaultActivity(Activity var0) {
        this.defaultActivity = var0;
    }

    public void addActivity(Activity var0, int var1, ImmutableList<? extends BehaviorControl<? super E>> var2) {
        this.addActivity(var0, this.createPriorityPairs(var1, var2));
    }

    public void addActivityAndRemoveMemoryWhenStopped(Activity var0, int var1, ImmutableList<? extends BehaviorControl<? super E>> var2, MemoryModuleType<?> var3) {
        ImmutableSet var4 = ImmutableSet.of((Object)Pair.of(var3, (Object)((Object)MemoryStatus.VALUE_PRESENT)));
        ImmutableSet var5 = ImmutableSet.of(var3);
        this.addActivityAndRemoveMemoriesWhenStopped(var0, (ImmutableList<? extends Pair<Integer, ? extends BehaviorControl<? super E>>>)this.createPriorityPairs(var1, var2), (Set<Pair<MemoryModuleType<?>, MemoryStatus>>)var4, (Set<MemoryModuleType<?>>)var5);
    }

    public void addActivity(Activity var0, ImmutableList<? extends Pair<Integer, ? extends BehaviorControl<? super E>>> var1) {
        this.addActivityAndRemoveMemoriesWhenStopped(var0, var1, (Set<Pair<MemoryModuleType<?>, MemoryStatus>>)ImmutableSet.of(), Sets.newHashSet());
    }

    public void addActivityWithConditions(Activity var0, int var1, ImmutableList<? extends BehaviorControl<? super E>> var2, Set<Pair<MemoryModuleType<?>, MemoryStatus>> var3) {
        this.addActivityWithConditions(var0, this.createPriorityPairs(var1, var2), var3);
    }

    public void addActivityWithConditions(Activity var0, ImmutableList<? extends Pair<Integer, ? extends BehaviorControl<? super E>>> var1, Set<Pair<MemoryModuleType<?>, MemoryStatus>> var2) {
        this.addActivityAndRemoveMemoriesWhenStopped(var0, var1, var2, Sets.newHashSet());
    }

    public void addActivityAndRemoveMemoriesWhenStopped(Activity var02, ImmutableList<? extends Pair<Integer, ? extends BehaviorControl<? super E>>> var1, Set<Pair<MemoryModuleType<?>, MemoryStatus>> var2, Set<MemoryModuleType<?>> var3) {
        this.activityRequirements.put(var02, var2);
        if (!var3.isEmpty()) {
            this.activityMemoriesToEraseWhenStopped.put(var02, var3);
        }
        for (Pair var5 : var1) {
            this.availableBehaviorsByPriority.computeIfAbsent((Integer)var5.getFirst(), var0 -> Maps.newHashMap()).computeIfAbsent(var02, var0 -> Sets.newLinkedHashSet()).add((BehaviorControl)var5.getSecond());
        }
    }

    @VisibleForTesting
    public void removeAllBehaviors() {
        this.availableBehaviorsByPriority.clear();
    }

    public boolean isActive(Activity var0) {
        return this.activeActivities.contains(var0);
    }

    public Brain<E> copyWithoutBehaviors() {
        Brain<E> var0 = new Brain<E>(this.memories.keySet(), this.sensors.keySet(), ImmutableList.of(), this.codec);
        for (Map.Entry<MemoryModuleType<?>, Optional<ExpirableValue<?>>> var2 : this.memories.entrySet()) {
            MemoryModuleType<?> var3 = var2.getKey();
            if (!var2.getValue().isPresent()) continue;
            var0.memories.put(var3, var2.getValue());
        }
        return var0;
    }

    public void tick(ServerLevel var0, E var1) {
        this.forgetOutdatedMemories();
        this.tickSensors(var0, var1);
        this.startEachNonRunningBehavior(var0, var1);
        this.tickEachRunningBehavior(var0, var1);
    }

    private void tickSensors(ServerLevel var0, E var1) {
        for (Sensor<E> var3 : this.sensors.values()) {
            var3.tick(var0, var1);
        }
    }

    private void forgetOutdatedMemories() {
        for (Map.Entry<MemoryModuleType<?>, Optional<ExpirableValue<?>>> var1 : this.memories.entrySet()) {
            if (!var1.getValue().isPresent()) continue;
            ExpirableValue<?> var2 = var1.getValue().get();
            if (var2.hasExpired()) {
                this.eraseMemory(var1.getKey());
            }
            var2.tick();
        }
    }

    public void stopAll(ServerLevel var0, E var1) {
        long var2 = ((Entity)var1).level().getGameTime();
        for (BehaviorControl<E> var5 : this.getRunningBehaviors()) {
            var5.doStop(var0, var1, var2);
        }
    }

    private void startEachNonRunningBehavior(ServerLevel var0, E var1) {
        long var2 = var0.getGameTime();
        for (Map<Activity, Set<BehaviorControl<E>>> var5 : this.availableBehaviorsByPriority.values()) {
            for (Map.Entry<Activity, Set<BehaviorControl<E>>> var7 : var5.entrySet()) {
                Activity var8 = var7.getKey();
                if (!this.activeActivities.contains(var8)) continue;
                Set<BehaviorControl<E>> var9 = var7.getValue();
                for (BehaviorControl<E> var11 : var9) {
                    if (var11.getStatus() != Behavior.Status.STOPPED) continue;
                    var11.tryStart(var0, var1, var2);
                }
            }
        }
    }

    private void tickEachRunningBehavior(ServerLevel var0, E var1) {
        long var2 = var0.getGameTime();
        for (BehaviorControl<E> var5 : this.getRunningBehaviors()) {
            var5.tickOrStop(var0, var1, var2);
        }
    }

    private boolean activityRequirementsAreMet(Activity var0) {
        if (!this.activityRequirements.containsKey(var0)) {
            return false;
        }
        for (Pair<MemoryModuleType<?>, MemoryStatus> var2 : this.activityRequirements.get(var0)) {
            MemoryStatus var4;
            MemoryModuleType var3 = (MemoryModuleType)var2.getFirst();
            if (this.checkMemory(var3, var4 = (MemoryStatus)((Object)var2.getSecond()))) continue;
            return false;
        }
        return true;
    }

    private boolean isEmptyCollection(Object var0) {
        return var0 instanceof Collection && ((Collection)var0).isEmpty();
    }

    ImmutableList<? extends Pair<Integer, ? extends BehaviorControl<? super E>>> createPriorityPairs(int var0, ImmutableList<? extends BehaviorControl<? super E>> var1) {
        int var2 = var0;
        ImmutableList.Builder var3 = ImmutableList.builder();
        for (BehaviorControl var5 : var1) {
            var3.add((Object)Pair.of((Object)var2++, (Object)var5));
        }
        return var3.build();
    }

    public boolean isBrainDead() {
        return this.memories.isEmpty() && this.sensors.isEmpty() && this.availableBehaviorsByPriority.isEmpty();
    }

    public static final class Provider<E extends LivingEntity> {
        private final Collection<? extends MemoryModuleType<?>> memoryTypes;
        private final Collection<? extends SensorType<? extends Sensor<? super E>>> sensorTypes;
        private final Codec<Brain<E>> codec;

        Provider(Collection<? extends MemoryModuleType<?>> var0, Collection<? extends SensorType<? extends Sensor<? super E>>> var1) {
            this.memoryTypes = var0;
            this.sensorTypes = var1;
            this.codec = Brain.codec(var0, var1);
        }

        public Brain<E> makeBrain(Dynamic<?> var0) {
            return this.codec.parse(var0).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).orElseGet(() -> new Brain(this.memoryTypes, this.sensorTypes, ImmutableList.of(), () -> this.codec));
        }
    }

    static final class MemoryValue<U> {
        private final MemoryModuleType<U> type;
        private final Optional<? extends ExpirableValue<U>> value;

        static <U> MemoryValue<U> createUnchecked(MemoryModuleType<U> var0, Optional<? extends ExpirableValue<?>> var1) {
            return new MemoryValue<U>(var0, var1);
        }

        MemoryValue(MemoryModuleType<U> var0, Optional<? extends ExpirableValue<U>> var1) {
            this.type = var0;
            this.value = var1;
        }

        void setMemoryInternal(Brain<?> var0) {
            var0.setMemoryInternal(this.type, this.value);
        }

        public <T> void serialize(DynamicOps<T> var0, RecordBuilder<T> var1) {
            this.type.getCodec().ifPresent(var2 -> this.value.ifPresent(var3 -> var1.add(BuiltInRegistries.MEMORY_MODULE_TYPE.byNameCodec().encodeStart(var0, this.type), var2.encodeStart(var0, var3))));
        }
    }
}

