/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.attributes;

import com.mojang.serialization.Codec;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public class Attribute {
    public static final Codec<Holder<Attribute>> CODEC = BuiltInRegistries.ATTRIBUTE.holderByNameCodec();
    public static final StreamCodec<RegistryFriendlyByteBuf, Holder<Attribute>> STREAM_CODEC = ByteBufCodecs.holderRegistry(Registries.ATTRIBUTE);
    private final double defaultValue;
    private boolean syncable;
    private final String descriptionId;
    private Sentiment sentiment = Sentiment.POSITIVE;

    protected Attribute(String var0, double var1) {
        this.defaultValue = var1;
        this.descriptionId = var0;
    }

    public double getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isClientSyncable() {
        return this.syncable;
    }

    public Attribute setSyncable(boolean var0) {
        this.syncable = var0;
        return this;
    }

    public Attribute setSentiment(Sentiment var0) {
        this.sentiment = var0;
        return this;
    }

    public double sanitizeValue(double var0) {
        return var0;
    }

    public String getDescriptionId() {
        return this.descriptionId;
    }

    public ChatFormatting getStyle(boolean var0) {
        return this.sentiment.getStyle(var0);
    }

    public static enum Sentiment {
        POSITIVE,
        NEUTRAL,
        NEGATIVE;


        public ChatFormatting getStyle(boolean var0) {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> {
                    if (var0) {
                        yield ChatFormatting.BLUE;
                    }
                    yield ChatFormatting.RED;
                }
                case 1 -> ChatFormatting.GRAY;
                case 2 -> var0 ? ChatFormatting.RED : ChatFormatting.BLUE;
            };
        }
    }
}

