/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDropItemEvent;
import org.jspecify.annotations.Nullable;

public class BehaviorUtils {
    private BehaviorUtils() {
    }

    public static void lockGazeAndWalkToEachOther(LivingEntity entityliving, LivingEntity entityliving1, float f, int i) {
        BehaviorUtils.lookAtEachOther(entityliving, entityliving1);
        BehaviorUtils.setWalkAndLookTargetMemoriesToEachOther(entityliving, entityliving1, f, i);
    }

    public static boolean entityIsVisible(Brain<?> behaviorcontroller, LivingEntity entityliving) {
        Optional<NearestVisibleLivingEntities> optional = behaviorcontroller.getMemory(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES);
        return optional.isPresent() && optional.get().contains(entityliving);
    }

    public static boolean targetIsValid(Brain<?> behaviorcontroller, MemoryModuleType<? extends LivingEntity> memorymoduletype, EntityType<?> entitytypes) {
        return BehaviorUtils.targetIsValid(behaviorcontroller, memorymoduletype, (LivingEntity entityliving) -> entityliving.getType() == entitytypes);
    }

    private static boolean targetIsValid(Brain<?> behaviorcontroller, MemoryModuleType<? extends LivingEntity> memorymoduletype, Predicate<LivingEntity> predicate) {
        return behaviorcontroller.getMemory(memorymoduletype).filter(predicate).filter(LivingEntity::isAlive).filter(entityliving -> BehaviorUtils.entityIsVisible(behaviorcontroller, entityliving)).isPresent();
    }

    private static void lookAtEachOther(LivingEntity entityliving, LivingEntity entityliving1) {
        BehaviorUtils.lookAtEntity(entityliving, entityliving1);
        BehaviorUtils.lookAtEntity(entityliving1, entityliving);
    }

    public static void lookAtEntity(LivingEntity entityliving, LivingEntity entityliving1) {
        entityliving.getBrain().setMemory(MemoryModuleType.LOOK_TARGET, new EntityTracker(entityliving1, true));
    }

    private static void setWalkAndLookTargetMemoriesToEachOther(LivingEntity entityliving, LivingEntity entityliving1, float f, int i) {
        BehaviorUtils.setWalkAndLookTargetMemories(entityliving, entityliving1, f, i);
        BehaviorUtils.setWalkAndLookTargetMemories(entityliving1, entityliving, f, i);
    }

    public static void setWalkAndLookTargetMemories(LivingEntity entityliving, Entity entity, float f, int i) {
        BehaviorUtils.setWalkAndLookTargetMemories(entityliving, new EntityTracker(entity, true), f, i);
    }

    public static void setWalkAndLookTargetMemories(LivingEntity entityliving, BlockPos blockposition, float f, int i) {
        BehaviorUtils.setWalkAndLookTargetMemories(entityliving, new BlockPosTracker(blockposition), f, i);
    }

    public static void setWalkAndLookTargetMemories(LivingEntity entityliving, PositionTracker behaviorposition, float f, int i) {
        WalkTarget memorytarget = new WalkTarget(behaviorposition, f, i);
        entityliving.getBrain().setMemory(MemoryModuleType.LOOK_TARGET, behaviorposition);
        entityliving.getBrain().setMemory(MemoryModuleType.WALK_TARGET, memorytarget);
    }

    public static void throwItem(LivingEntity entityliving, ItemStack itemstack, Vec3 vec3d) {
        Vec3 vec3d1 = new Vec3(0.3f, 0.3f, 0.3f);
        BehaviorUtils.throwItem(entityliving, itemstack, vec3d, vec3d1, 0.3f);
    }

    public static void throwItem(LivingEntity entityliving, ItemStack itemstack, Vec3 vec3d, Vec3 vec3d1, float f) {
        if (itemstack.isEmpty()) {
            return;
        }
        double d0 = entityliving.getEyeY() - (double)f;
        ItemEntity entityitem = new ItemEntity(entityliving.level(), entityliving.getX(), d0, entityliving.getZ(), itemstack);
        entityitem.setThrower(entityliving);
        Vec3 vec3d2 = vec3d.subtract(entityliving.position());
        vec3d2 = vec3d2.normalize().multiply(vec3d1.x, vec3d1.y, vec3d1.z);
        entityitem.setDeltaMovement(vec3d2);
        entityitem.setDefaultPickUpDelay();
        EntityDropItemEvent event = new EntityDropItemEvent((org.bukkit.entity.Entity)entityliving.getBukkitEntity(), (org.bukkit.entity.Item)entityitem.getBukkitEntity());
        entityitem.level().getCraftServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        entityliving.level().addFreshEntity(entityitem);
    }

    public static SectionPos findSectionClosestToVillage(ServerLevel worldserver, SectionPos sectionposition, int i) {
        int j = worldserver.sectionsToVillage(sectionposition);
        Stream<SectionPos> stream = SectionPos.cube(sectionposition, i).filter(sectionposition1 -> worldserver.sectionsToVillage((SectionPos)sectionposition1) < j);
        Objects.requireNonNull(worldserver);
        return stream.min(Comparator.comparingInt(worldserver::sectionsToVillage)).orElse(sectionposition);
    }

    public static boolean isWithinAttackRange(Mob entityinsentient, LivingEntity entityliving, int i) {
        Item item = entityinsentient.getMainHandItem().getItem();
        if (item instanceof ProjectileWeaponItem) {
            ProjectileWeaponItem itemprojectileweapon = (ProjectileWeaponItem)item;
            if (entityinsentient.canUseNonMeleeWeapon(entityinsentient.getMainHandItem())) {
                int j = itemprojectileweapon.getDefaultProjectileRange() - i;
                return entityinsentient.closerThan(entityliving, j);
            }
        }
        return entityinsentient.isWithinMeleeAttackRange(entityliving);
    }

    public static boolean isOtherTargetMuchFurtherAwayThanCurrentAttackTarget(LivingEntity entityliving, LivingEntity entityliving1, double d0) {
        Optional<LivingEntity> optional = entityliving.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET);
        if (optional.isEmpty()) {
            return false;
        }
        double d1 = entityliving.distanceToSqr(optional.get().position());
        double d2 = entityliving.distanceToSqr(entityliving1.position());
        return d2 > d1 + d0 * d0;
    }

    public static boolean canSee(LivingEntity entityliving, LivingEntity entityliving1) {
        Brain<NearestVisibleLivingEntities> behaviorcontroller = entityliving.getBrain();
        return !behaviorcontroller.hasMemoryValue(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES) ? false : behaviorcontroller.getMemory(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES).get().contains(entityliving1);
    }

    public static LivingEntity getNearestTarget(LivingEntity entityliving, Optional<LivingEntity> optional, LivingEntity entityliving1) {
        return optional.isEmpty() ? entityliving1 : BehaviorUtils.getTargetNearestMe(entityliving, optional.get(), entityliving1);
    }

    public static LivingEntity getTargetNearestMe(LivingEntity entityliving, LivingEntity entityliving1, LivingEntity entityliving2) {
        Vec3 vec3d = entityliving1.position();
        Vec3 vec3d1 = entityliving2.position();
        return entityliving.distanceToSqr(vec3d) < entityliving.distanceToSqr(vec3d1) ? entityliving1 : entityliving2;
    }

    public static Optional<LivingEntity> getLivingEntityFromUUIDMemory(LivingEntity entityliving, MemoryModuleType<UUID> memorymoduletype) {
        Optional<UUID> optional = entityliving.getBrain().getMemory(memorymoduletype);
        return optional.map(uuid -> entityliving.level().getEntity((UUID)uuid)).map(entity -> {
            LivingEntity entityliving2;
            LivingEntity entityliving1 = entity instanceof LivingEntity ? (entityliving2 = (LivingEntity)entity) : null;
            return entityliving1;
        });
    }

    public static @Nullable Vec3 getRandomSwimmablePos(PathfinderMob entitycreature, int i, int j) {
        Vec3 vec3d = DefaultRandomPos.getPos(entitycreature, i, j);
        int k = 0;
        while (vec3d != null && !entitycreature.level().getBlockState(BlockPos.containing(vec3d)).isPathfindable(PathComputationType.WATER) && k++ < 10) {
            vec3d = DefaultRandomPos.getPos(entitycreature, i, j);
        }
        return vec3d;
    }

    public static boolean isBreeding(LivingEntity entityliving) {
        return entityliving.getBrain().hasMemoryValue(MemoryModuleType.BREED_TARGET);
    }
}

