/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Util;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.MoveToSkySeeingSpot;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.npc.villager.Villager;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.FireworkExplosion;
import net.minecraft.world.item.component.Fireworks;
import org.jspecify.annotations.Nullable;

public class CelebrateVillagersSurvivedRaid
extends Behavior<Villager> {
    private @Nullable Raid currentRaid;

    public CelebrateVillagersSurvivedRaid(int var0, int var1) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(), var0, var1);
    }

    @Override
    protected boolean checkExtraStartConditions(ServerLevel var0, Villager var1) {
        BlockPos var2 = var1.blockPosition();
        this.currentRaid = var0.getRaidAt(var2);
        return this.currentRaid != null && this.currentRaid.isVictory() && MoveToSkySeeingSpot.hasNoBlocksAbove(var0, var1, var2);
    }

    @Override
    protected boolean canStillUse(ServerLevel var0, Villager var1, long var2) {
        return this.currentRaid != null && !this.currentRaid.isStopped();
    }

    @Override
    protected void stop(ServerLevel var0, Villager var1, long var2) {
        this.currentRaid = null;
        var1.getBrain().updateActivityFromSchedule(var0.environmentAttributes(), var0.getGameTime(), var1.position());
    }

    @Override
    protected void tick(ServerLevel var0, Villager var1, long var2) {
        RandomSource var4 = var1.getRandom();
        if (var4.nextInt(100) == 0) {
            var1.playCelebrateSound();
        }
        if (var4.nextInt(200) == 0 && MoveToSkySeeingSpot.hasNoBlocksAbove(var0, var1, var1.blockPosition())) {
            DyeColor var5 = Util.getRandom(DyeColor.values(), var4);
            int var6 = var4.nextInt(3);
            ItemStack var7 = this.getFirework(var5, var6);
            Projectile.spawnProjectile(new FireworkRocketEntity(var1.level(), var1, var1.getX(), var1.getEyeY(), var1.getZ(), var7), var0, var7);
        }
    }

    private ItemStack getFirework(DyeColor var0, int var1) {
        ItemStack var2 = new ItemStack(Items.FIREWORK_ROCKET);
        var2.set(DataComponents.FIREWORKS, new Fireworks((byte)var1, List.of(new FireworkExplosion(FireworkExplosion.Shape.BURST, IntList.of((int)var0.getFireworkColor()), IntList.of(), false, false))));
        return var2;
    }
}

