/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.ShufflingList;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;

public class GateBehavior<E extends LivingEntity>
implements BehaviorControl<E> {
    private final Map<MemoryModuleType<?>, MemoryStatus> entryCondition;
    private final Set<MemoryModuleType<?>> exitErasedMemories;
    private final OrderPolicy orderPolicy;
    private final RunningPolicy runningPolicy;
    private final ShufflingList<BehaviorControl<? super E>> behaviors = new ShufflingList();
    private Behavior.Status status = Behavior.Status.STOPPED;

    public GateBehavior(Map<MemoryModuleType<?>, MemoryStatus> var02, Set<MemoryModuleType<?>> var1, OrderPolicy var2, RunningPolicy var3, List<Pair<? extends BehaviorControl<? super E>, Integer>> var4) {
        this.entryCondition = var02;
        this.exitErasedMemories = var1;
        this.orderPolicy = var2;
        this.runningPolicy = var3;
        var4.forEach(var0 -> this.behaviors.add((BehaviorControl)var0.getFirst(), (Integer)var0.getSecond()));
    }

    @Override
    public Behavior.Status getStatus() {
        return this.status;
    }

    private boolean hasRequiredMemories(E var0) {
        for (Map.Entry<MemoryModuleType<?>, MemoryStatus> var2 : this.entryCondition.entrySet()) {
            MemoryModuleType<?> var3 = var2.getKey();
            MemoryStatus var4 = var2.getValue();
            if (((LivingEntity)var0).getBrain().checkMemory(var3, var4)) continue;
            return false;
        }
        return true;
    }

    @Override
    public final boolean tryStart(ServerLevel var0, E var1, long var2) {
        if (this.hasRequiredMemories(var1)) {
            this.status = Behavior.Status.RUNNING;
            this.orderPolicy.apply(this.behaviors);
            this.runningPolicy.apply(this.behaviors.stream(), var0, var1, var2);
            return true;
        }
        return false;
    }

    @Override
    public final void tickOrStop(ServerLevel var02, E var1, long var2) {
        this.behaviors.stream().filter(var0 -> var0.getStatus() == Behavior.Status.RUNNING).forEach(var4 -> var4.tickOrStop(var02, var1, var2));
        if (this.behaviors.stream().noneMatch(var0 -> var0.getStatus() == Behavior.Status.RUNNING)) {
            this.doStop(var02, var1, var2);
        }
    }

    @Override
    public final void doStop(ServerLevel var02, E var1, long var2) {
        this.status = Behavior.Status.STOPPED;
        this.behaviors.stream().filter(var0 -> var0.getStatus() == Behavior.Status.RUNNING).forEach(var4 -> var4.doStop(var02, var1, var2));
        this.exitErasedMemories.forEach(((LivingEntity)var1).getBrain()::eraseMemory);
    }

    @Override
    public String debugString() {
        return this.getClass().getSimpleName();
    }

    public String toString() {
        Set var02 = this.behaviors.stream().filter(var0 -> var0.getStatus() == Behavior.Status.RUNNING).collect(Collectors.toSet());
        return "(" + this.getClass().getSimpleName() + "): " + String.valueOf(var02);
    }

    public static enum OrderPolicy {
        ORDERED(var0 -> {}),
        SHUFFLED(ShufflingList::shuffle);

        private final Consumer<ShufflingList<?>> consumer;

        private OrderPolicy(Consumer var2) {
            this.consumer = var2;
        }

        public void apply(ShufflingList<?> var0) {
            this.consumer.accept(var0);
        }
    }

    public static enum RunningPolicy {
        RUN_ONE{

            @Override
            public <E extends LivingEntity> void apply(Stream<BehaviorControl<? super E>> var02, ServerLevel var1, E var2, long var3) {
                var02.filter(var0 -> var0.getStatus() == Behavior.Status.STOPPED).filter(var4 -> var4.tryStart(var1, var2, var3)).findFirst();
            }
        }
        ,
        TRY_ALL{

            @Override
            public <E extends LivingEntity> void apply(Stream<BehaviorControl<? super E>> var02, ServerLevel var1, E var2, long var3) {
                var02.filter(var0 -> var0.getStatus() == Behavior.Status.STOPPED).forEach(var4 -> var4.tryStart(var1, var2, var3));
            }
        };


        public abstract <E extends LivingEntity> void apply(Stream<BehaviorControl<? super E>> var1, ServerLevel var2, E var3, long var4);
    }
}

