/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.behavior.LongJumpUtil;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.Vec3;
import org.jspecify.annotations.Nullable;

public class LongJumpToRandomPos<E extends Mob>
extends Behavior<E> {
    protected static final int FIND_JUMP_TRIES = 20;
    private static final int PREPARE_JUMP_DURATION = 40;
    protected static final int MIN_PATHFIND_DISTANCE_TO_VALID_JUMP = 8;
    private static final int TIME_OUT_DURATION = 200;
    private static final List<Integer> ALLOWED_ANGLES = Lists.newArrayList((Object[])new Integer[]{65, 70, 75, 80});
    private final UniformInt timeBetweenLongJumps;
    protected final int maxLongJumpHeight;
    protected final int maxLongJumpWidth;
    protected final float maxJumpVelocityMultiplier;
    protected List<PossibleJump> jumpCandidates = Lists.newArrayList();
    protected Optional<Vec3> initialPosition = Optional.empty();
    protected @Nullable Vec3 chosenJump;
    protected int findJumpTries;
    protected long prepareJumpStart;
    private final Function<E, SoundEvent> getJumpSound;
    private final BiPredicate<E, BlockPos> acceptableLandingSpot;

    public LongJumpToRandomPos(UniformInt var0, int var1, int var2, float var3, Function<E, SoundEvent> var4) {
        this(var0, var1, var2, var3, var4, LongJumpToRandomPos::defaultAcceptableLandingSpot);
    }

    public static <E extends Mob> boolean defaultAcceptableLandingSpot(E var0, BlockPos var1) {
        BlockPos var3;
        Level var2 = var0.level();
        return var2.getBlockState(var3 = var1.below()).isSolidRender() && var0.getPathfindingMalus(WalkNodeEvaluator.getPathTypeStatic(var0, var1)) == 0.0f;
    }

    public LongJumpToRandomPos(UniformInt var0, int var1, int var2, float var3, Function<E, SoundEvent> var4, BiPredicate<E, BlockPos> var5) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.LOOK_TARGET, (Object)((Object)MemoryStatus.REGISTERED), MemoryModuleType.LONG_JUMP_COOLDOWN_TICKS, (Object)((Object)MemoryStatus.VALUE_ABSENT), MemoryModuleType.LONG_JUMP_MID_JUMP, (Object)((Object)MemoryStatus.VALUE_ABSENT)), 200);
        this.timeBetweenLongJumps = var0;
        this.maxLongJumpHeight = var1;
        this.maxLongJumpWidth = var2;
        this.maxJumpVelocityMultiplier = var3;
        this.getJumpSound = var4;
        this.acceptableLandingSpot = var5;
    }

    @Override
    protected boolean checkExtraStartConditions(ServerLevel var0, Mob var1) {
        boolean var2;
        boolean bl = var2 = var1.onGround() && !var1.isInWater() && !var1.isInLava() && !var0.getBlockState(var1.blockPosition()).is(Blocks.HONEY_BLOCK);
        if (!var2) {
            var1.getBrain().setMemory(MemoryModuleType.LONG_JUMP_COOLDOWN_TICKS, this.timeBetweenLongJumps.sample(var0.random) / 2);
        }
        return var2;
    }

    @Override
    protected boolean canStillUse(ServerLevel var0, Mob var1, long var2) {
        boolean var4;
        boolean bl = var4 = this.initialPosition.isPresent() && this.initialPosition.get().equals(var1.position()) && this.findJumpTries > 0 && !var1.isInWater() && (this.chosenJump != null || !this.jumpCandidates.isEmpty());
        if (!var4 && var1.getBrain().getMemory(MemoryModuleType.LONG_JUMP_MID_JUMP).isEmpty()) {
            var1.getBrain().setMemory(MemoryModuleType.LONG_JUMP_COOLDOWN_TICKS, this.timeBetweenLongJumps.sample(var0.random) / 2);
            var1.getBrain().eraseMemory(MemoryModuleType.LOOK_TARGET);
        }
        return var4;
    }

    @Override
    protected void start(ServerLevel var0, E var12, long var2) {
        this.chosenJump = null;
        this.findJumpTries = 20;
        this.initialPosition = Optional.of(((Entity)var12).position());
        BlockPos var4 = ((Entity)var12).blockPosition();
        int var5 = var4.getX();
        int var6 = var4.getY();
        int var7 = var4.getZ();
        this.jumpCandidates = BlockPos.betweenClosedStream(var5 - this.maxLongJumpWidth, var6 - this.maxLongJumpHeight, var7 - this.maxLongJumpWidth, var5 + this.maxLongJumpWidth, var6 + this.maxLongJumpHeight, var7 + this.maxLongJumpWidth).filter(var1 -> !var1.equals(var4)).map(var1 -> new PossibleJump(var1.immutable(), Mth.ceil(var4.distSqr((Vec3i)var1)))).collect(Collectors.toCollection(Lists::newArrayList));
    }

    @Override
    protected void tick(ServerLevel var0, E var1, long var2) {
        if (this.chosenJump != null) {
            if (var2 - this.prepareJumpStart >= 40L) {
                ((Entity)var1).setYRot(((Mob)var1).yBodyRot);
                ((LivingEntity)var1).setDiscardFriction(true);
                double var4 = this.chosenJump.length();
                double var6 = var4 + (double)((LivingEntity)var1).getJumpBoostPower();
                ((Entity)var1).setDeltaMovement(this.chosenJump.scale(var6 / var4));
                ((LivingEntity)var1).getBrain().setMemory(MemoryModuleType.LONG_JUMP_MID_JUMP, true);
                var0.playSound(null, (Entity)var1, this.getJumpSound.apply(var1), SoundSource.NEUTRAL, 1.0f, 1.0f);
            }
        } else {
            --this.findJumpTries;
            this.pickCandidate(var0, var1, var2);
        }
    }

    protected void pickCandidate(ServerLevel var0, E var1, long var2) {
        while (!this.jumpCandidates.isEmpty()) {
            Vec3 var7;
            Vec3 var8;
            PossibleJump var5;
            BlockPos var6;
            Optional<PossibleJump> var4 = this.getJumpCandidate(var0);
            if (var4.isEmpty() || !this.isAcceptableLandingPosition(var0, var1, var6 = (var5 = var4.get()).targetPos()) || (var8 = this.calculateOptimalJumpVector((Mob)var1, var7 = Vec3.atCenterOf(var6))) == null) continue;
            ((LivingEntity)var1).getBrain().setMemory(MemoryModuleType.LOOK_TARGET, new BlockPosTracker(var6));
            PathNavigation var9 = ((Mob)var1).getNavigation();
            Path var10 = var9.createPath(var6, 0, 8);
            if (var10 != null && var10.canReach()) continue;
            this.chosenJump = var8;
            this.prepareJumpStart = var2;
            return;
        }
    }

    protected Optional<PossibleJump> getJumpCandidate(ServerLevel var0) {
        Optional<PossibleJump> var1 = WeightedRandom.getRandomItem(var0.random, this.jumpCandidates, PossibleJump::weight);
        var1.ifPresent(this.jumpCandidates::remove);
        return var1;
    }

    private boolean isAcceptableLandingPosition(ServerLevel var0, E var1, BlockPos var2) {
        BlockPos var3 = ((Entity)var1).blockPosition();
        int var4 = var3.getX();
        int var5 = var3.getZ();
        if (var4 == var2.getX() && var5 == var2.getZ()) {
            return false;
        }
        return this.acceptableLandingSpot.test(var1, var2);
    }

    protected @Nullable Vec3 calculateOptimalJumpVector(Mob var0, Vec3 var1) {
        ArrayList var2 = Lists.newArrayList(ALLOWED_ANGLES);
        Collections.shuffle(var2);
        float var3 = (float)(var0.getAttributeValue(Attributes.JUMP_STRENGTH) * (double)this.maxJumpVelocityMultiplier);
        Iterator iterator = var2.iterator();
        while (iterator.hasNext()) {
            int var5 = (Integer)iterator.next();
            Optional<Vec3> var6 = LongJumpUtil.calculateJumpVectorForAngle(var0, var1, var3, var5, true);
            if (!var6.isPresent()) continue;
            return var6.get();
        }
        return null;
    }

    @Override
    protected /* synthetic */ boolean canStillUse(ServerLevel serverLevel, LivingEntity livingEntity, long l) {
        return this.canStillUse(serverLevel, (Mob)livingEntity, l);
    }

    @Override
    protected /* synthetic */ void start(ServerLevel serverLevel, LivingEntity livingEntity, long l) {
        this.start(serverLevel, (E)((Mob)livingEntity), l);
    }

    public record PossibleJump(BlockPos targetPos, int weight) {
    }
}

