/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.mojang.datafixers.kinds.Applicative;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import org.jspecify.annotations.Nullable;

public class MoveToSkySeeingSpot {
    public static OneShot<LivingEntity> create(float var0) {
        return BehaviorBuilder.create(var12 -> var12.group(var12.absent(MemoryModuleType.WALK_TARGET)).apply((Applicative)var12, var1 -> (var22, var3, var4) -> {
            if (var22.canSeeSky(var3.blockPosition())) {
                return false;
            }
            Optional<Vec3> var6 = Optional.ofNullable(MoveToSkySeeingSpot.getOutdoorPosition(var22, var3));
            var6.ifPresent(var2 -> var1.set(new WalkTarget((Vec3)var2, var0, 0)));
            return true;
        }));
    }

    private static @Nullable Vec3 getOutdoorPosition(ServerLevel var0, LivingEntity var1) {
        RandomSource var2 = var1.getRandom();
        BlockPos var3 = var1.blockPosition();
        for (int var4 = 0; var4 < 10; ++var4) {
            BlockPos var5 = var3.offset(var2.nextInt(20) - 10, var2.nextInt(6) - 3, var2.nextInt(20) - 10);
            if (!MoveToSkySeeingSpot.hasNoBlocksAbove(var0, var1, var5)) continue;
            return Vec3.atBottomCenterOf(var5);
        }
        return null;
    }

    public static boolean hasNoBlocksAbove(ServerLevel var0, LivingEntity var1, BlockPos var2) {
        return var0.canSeeSky(var2) && (double)var0.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, var2).getY() <= var1.getY();
    }
}

