/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior.declarative;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.K1;
import java.util.Optional;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;

public final class MemoryAccessor<F extends K1, Value> {
    private final Brain<?> brain;
    private final MemoryModuleType<Value> memoryType;
    private final App<F, Value> value;

    public MemoryAccessor(Brain<?> var0, MemoryModuleType<Value> var1, App<F, Value> var2) {
        this.brain = var0;
        this.memoryType = var1;
        this.value = var2;
    }

    public App<F, Value> value() {
        return this.value;
    }

    public void set(Value var0) {
        this.brain.setMemory(this.memoryType, Optional.of(var0));
    }

    public void setOrErase(Optional<Value> var0) {
        this.brain.setMemory(this.memoryType, var0);
    }

    public void setWithExpiry(Value var0, long var1) {
        this.brain.setMemoryWithExpiry(this.memoryType, var0, var1);
    }

    public void erase() {
        this.brain.eraseMemory(this.memoryType);
    }
}

