/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior.warden;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAttachment;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.phys.Vec3;

public class SonicBoom
extends Behavior<Warden> {
    private static final int DISTANCE_XZ = 15;
    private static final int DISTANCE_Y = 20;
    private static final double KNOCKBACK_VERTICAL = 0.5;
    private static final double KNOCKBACK_HORIZONTAL = 2.5;
    public static final int COOLDOWN = 40;
    private static final int TICKS_BEFORE_PLAYING_SOUND = Mth.ceil(34.0);
    private static final int DURATION = Mth.ceil(60.0f);

    public SonicBoom() {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.ATTACK_TARGET, (Object)((Object)MemoryStatus.VALUE_PRESENT), MemoryModuleType.SONIC_BOOM_COOLDOWN, (Object)((Object)MemoryStatus.VALUE_ABSENT), MemoryModuleType.SONIC_BOOM_SOUND_COOLDOWN, (Object)((Object)MemoryStatus.REGISTERED), MemoryModuleType.SONIC_BOOM_SOUND_DELAY, (Object)((Object)MemoryStatus.REGISTERED)), DURATION);
    }

    @Override
    protected boolean checkExtraStartConditions(ServerLevel var0, Warden var1) {
        return var1.closerThan(var1.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).get(), 15.0, 20.0);
    }

    @Override
    protected boolean canStillUse(ServerLevel var0, Warden var1, long var2) {
        return true;
    }

    @Override
    protected void start(ServerLevel var0, Warden var1, long var2) {
        var1.getBrain().setMemoryWithExpiry(MemoryModuleType.ATTACK_COOLING_DOWN, true, DURATION);
        var1.getBrain().setMemoryWithExpiry(MemoryModuleType.SONIC_BOOM_SOUND_DELAY, Unit.INSTANCE, TICKS_BEFORE_PLAYING_SOUND);
        var0.broadcastEntityEvent(var1, (byte)62);
        var1.playSound(SoundEvents.WARDEN_SONIC_CHARGE, 3.0f, 1.0f);
    }

    @Override
    protected void tick(ServerLevel var0, Warden var12, long var22) {
        var12.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).ifPresent(var1 -> var12.getLookControl().setLookAt(var1.position()));
        if (var12.getBrain().hasMemoryValue(MemoryModuleType.SONIC_BOOM_SOUND_DELAY) || var12.getBrain().hasMemoryValue(MemoryModuleType.SONIC_BOOM_SOUND_COOLDOWN)) {
            return;
        }
        var12.getBrain().setMemoryWithExpiry(MemoryModuleType.SONIC_BOOM_SOUND_COOLDOWN, Unit.INSTANCE, DURATION - TICKS_BEFORE_PLAYING_SOUND);
        var12.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).filter(var12::canTargetEntity).filter(var1 -> var12.closerThan((Entity)var1, 15.0, 20.0)).ifPresent(var2 -> {
            Vec3 var3 = var12.position().add(var12.getAttachments().get(EntityAttachment.WARDEN_CHEST, 0, var12.getYRot()));
            Vec3 var4 = var2.getEyePosition().subtract(var3);
            Vec3 var5 = var4.normalize();
            int var6 = Mth.floor(var4.length()) + 7;
            for (int var7 = 1; var7 < var6; ++var7) {
                Vec3 var8 = var3.add(var5.scale(var7));
                var0.sendParticles(ParticleTypes.SONIC_BOOM, var8.x, var8.y, var8.z, 1, 0.0, 0.0, 0.0, 0.0);
            }
            var12.playSound(SoundEvents.WARDEN_SONIC_BOOM, 3.0f, 1.0f);
            if (var2.hurtServer(var0, var0.damageSources().sonicBoom(var12), 10.0f)) {
                double var7 = 0.5 * (1.0 - var2.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE));
                double var9 = 2.5 * (1.0 - var2.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE));
                var2.push(var5.x() * var9, var5.y() * var7, var5.z() * var9);
            }
        });
    }

    @Override
    protected void stop(ServerLevel var0, Warden var1, long var2) {
        SonicBoom.setCooldown(var1, 40);
    }

    public static void setCooldown(LivingEntity var0, int var1) {
        var0.getBrain().setMemoryWithExpiry(MemoryModuleType.SONIC_BOOM_COOLDOWN, Unit.INSTANCE, var1);
    }

    @Override
    protected /* synthetic */ void stop(ServerLevel serverLevel, LivingEntity livingEntity, long l) {
        this.stop(serverLevel, (Warden)livingEntity, l);
    }

    @Override
    protected /* synthetic */ void start(ServerLevel serverLevel, LivingEntity livingEntity, long l) {
        this.start(serverLevel, (Warden)livingEntity, l);
    }
}

