/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.goal;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.ai.goal.JumpGoal;
import net.minecraft.world.entity.animal.dolphin.Dolphin;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;

public class DolphinJumpGoal
extends JumpGoal {
    private static final int[] STEPS_TO_CHECK = new int[]{0, 1, 4, 5, 6, 7};
    private final Dolphin dolphin;
    private final int interval;
    private boolean breached;

    public DolphinJumpGoal(Dolphin var0, int var1) {
        this.dolphin = var0;
        this.interval = DolphinJumpGoal.reducedTickDelay(var1);
    }

    @Override
    public boolean canUse() {
        if (this.dolphin.getRandom().nextInt(this.interval) != 0) {
            return false;
        }
        Direction var0 = this.dolphin.getMotionDirection();
        int var1 = var0.getStepX();
        int var2 = var0.getStepZ();
        BlockPos var3 = this.dolphin.blockPosition();
        for (int var7 : STEPS_TO_CHECK) {
            if (this.waterIsClear(var3, var1, var2, var7) && this.surfaceIsClear(var3, var1, var2, var7)) continue;
            return false;
        }
        return true;
    }

    private boolean waterIsClear(BlockPos var0, int var1, int var2, int var3) {
        BlockPos var4 = var0.offset(var1 * var3, 0, var2 * var3);
        return this.dolphin.level().getFluidState(var4).is(FluidTags.WATER) && !this.dolphin.level().getBlockState(var4).blocksMotion();
    }

    private boolean surfaceIsClear(BlockPos var0, int var1, int var2, int var3) {
        return this.dolphin.level().getBlockState(var0.offset(var1 * var3, 1, var2 * var3)).isAir() && this.dolphin.level().getBlockState(var0.offset(var1 * var3, 2, var2 * var3)).isAir();
    }

    @Override
    public boolean canContinueToUse() {
        double var0 = this.dolphin.getDeltaMovement().y;
        return !(var0 * var0 < (double)0.03f && this.dolphin.getXRot() != 0.0f && Math.abs(this.dolphin.getXRot()) < 10.0f && this.dolphin.isInWater() || this.dolphin.onGround());
    }

    @Override
    public boolean isInterruptable() {
        return false;
    }

    @Override
    public void start() {
        Direction var0 = this.dolphin.getMotionDirection();
        this.dolphin.setDeltaMovement(this.dolphin.getDeltaMovement().add((double)var0.getStepX() * 0.6, 0.7, (double)var0.getStepZ() * 0.6));
        this.dolphin.getNavigation().stop();
    }

    @Override
    public void stop() {
        this.dolphin.setXRot(0.0f);
    }

    @Override
    public void tick() {
        Object var1;
        boolean var0 = this.breached;
        if (!var0) {
            var1 = this.dolphin.level().getFluidState(this.dolphin.blockPosition());
            this.breached = ((FluidState)var1).is(FluidTags.WATER);
        }
        if (this.breached && !var0) {
            this.dolphin.playSound(SoundEvents.DOLPHIN_JUMP, 1.0f, 1.0f);
        }
        var1 = this.dolphin.getDeltaMovement();
        if (((Vec3)var1).y * ((Vec3)var1).y < (double)0.03f && this.dolphin.getXRot() != 0.0f) {
            this.dolphin.setXRot(Mth.rotLerp(0.2f, this.dolphin.getXRot(), 0.0f));
        } else if (((Vec3)var1).length() > (double)1.0E-5f) {
            double var2 = ((Vec3)var1).horizontalDistance();
            double var4 = Math.atan2(-((Vec3)var1).y, var2) * 57.2957763671875;
            this.dolphin.setXRot((float)var4);
        }
    }
}

