/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.goal;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.GoalUtils;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;

public abstract class DoorInteractGoal
extends Goal {
    protected Mob mob;
    protected BlockPos doorPos = BlockPos.ZERO;
    protected boolean hasDoor;
    private boolean passed;
    private float doorOpenDirX;
    private float doorOpenDirZ;

    public DoorInteractGoal(Mob var0) {
        this.mob = var0;
        if (!GoalUtils.hasGroundPathNavigation(var0)) {
            throw new IllegalArgumentException("Unsupported mob type for DoorInteractGoal");
        }
    }

    protected boolean isOpen() {
        if (!this.hasDoor) {
            return false;
        }
        BlockState var0 = this.mob.level().getBlockState(this.doorPos);
        if (!(var0.getBlock() instanceof DoorBlock)) {
            this.hasDoor = false;
            return false;
        }
        return var0.getValue(DoorBlock.OPEN);
    }

    protected void setOpen(boolean var0) {
        BlockState var1;
        if (this.hasDoor && (var1 = this.mob.level().getBlockState(this.doorPos)).getBlock() instanceof DoorBlock) {
            ((DoorBlock)var1.getBlock()).setOpen(this.mob, this.mob.level(), var1, this.doorPos, var0);
        }
    }

    @Override
    public boolean canUse() {
        if (!GoalUtils.hasGroundPathNavigation(this.mob)) {
            return false;
        }
        if (!this.mob.horizontalCollision) {
            return false;
        }
        Path var0 = this.mob.getNavigation().getPath();
        if (var0 == null || var0.isDone()) {
            return false;
        }
        for (int var1 = 0; var1 < Math.min(var0.getNextNodeIndex() + 2, var0.getNodeCount()); ++var1) {
            Node var2 = var0.getNode(var1);
            this.doorPos = new BlockPos(var2.x, var2.y + 1, var2.z);
            if (this.mob.distanceToSqr(this.doorPos.getX(), this.mob.getY(), this.doorPos.getZ()) > 2.25) continue;
            this.hasDoor = DoorBlock.isWoodenDoor(this.mob.level(), this.doorPos);
            if (!this.hasDoor) continue;
            return true;
        }
        this.doorPos = this.mob.blockPosition().above();
        this.hasDoor = DoorBlock.isWoodenDoor(this.mob.level(), this.doorPos);
        return this.hasDoor;
    }

    @Override
    public boolean canContinueToUse() {
        return !this.passed;
    }

    @Override
    public void start() {
        this.passed = false;
        this.doorOpenDirX = (float)((double)this.doorPos.getX() + 0.5 - this.mob.getX());
        this.doorOpenDirZ = (float)((double)this.doorPos.getZ() + 0.5 - this.mob.getZ());
    }

    @Override
    public boolean requiresUpdateEveryTick() {
        return true;
    }

    @Override
    public void tick() {
        float var1;
        float var0 = (float)((double)this.doorPos.getX() + 0.5 - this.mob.getX());
        float var2 = this.doorOpenDirX * var0 + this.doorOpenDirZ * (var1 = (float)((double)this.doorPos.getZ() + 0.5 - this.mob.getZ()));
        if (var2 < 0.0f) {
            this.passed = true;
        }
    }
}

