/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.goal;

import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.entity.npc.villager.Villager;
import net.minecraft.world.phys.Vec3;
import org.jspecify.annotations.Nullable;

public class GolemRandomStrollInVillageGoal
extends RandomStrollGoal {
    private static final int POI_SECTION_SCAN_RADIUS = 2;
    private static final int VILLAGER_SCAN_RADIUS = 32;
    private static final int RANDOM_POS_XY_DISTANCE = 10;
    private static final int RANDOM_POS_Y_DISTANCE = 7;

    public GolemRandomStrollInVillageGoal(PathfinderMob var0, double var1) {
        super(var0, var1, 240, false);
    }

    @Override
    protected @Nullable Vec3 getPosition() {
        Vec3 var0;
        float var1 = this.mob.level().random.nextFloat();
        if (this.mob.level().random.nextFloat() < 0.3f) {
            return this.getPositionTowardsAnywhere();
        }
        if (var1 < 0.7f) {
            var0 = this.getPositionTowardsVillagerWhoWantsGolem();
            if (var0 == null) {
                var0 = this.getPositionTowardsPoi();
            }
        } else {
            var0 = this.getPositionTowardsPoi();
            if (var0 == null) {
                var0 = this.getPositionTowardsVillagerWhoWantsGolem();
            }
        }
        return var0 == null ? this.getPositionTowardsAnywhere() : var0;
    }

    private @Nullable Vec3 getPositionTowardsAnywhere() {
        return LandRandomPos.getPos(this.mob, 10, 7);
    }

    private @Nullable Vec3 getPositionTowardsVillagerWhoWantsGolem() {
        ServerLevel var0 = (ServerLevel)this.mob.level();
        List<Villager> var1 = var0.getEntities(EntityType.VILLAGER, this.mob.getBoundingBox().inflate(32.0), this::doesVillagerWantGolem);
        if (var1.isEmpty()) {
            return null;
        }
        Villager var2 = var1.get(this.mob.level().random.nextInt(var1.size()));
        Vec3 var3 = var2.position();
        return LandRandomPos.getPosTowards(this.mob, 10, 7, var3);
    }

    private @Nullable Vec3 getPositionTowardsPoi() {
        SectionPos var0 = this.getRandomVillageSection();
        if (var0 == null) {
            return null;
        }
        BlockPos var1 = this.getRandomPoiWithinSection(var0);
        if (var1 == null) {
            return null;
        }
        return LandRandomPos.getPosTowards(this.mob, 10, 7, Vec3.atBottomCenterOf(var1));
    }

    private @Nullable SectionPos getRandomVillageSection() {
        ServerLevel var0 = (ServerLevel)this.mob.level();
        List var12 = SectionPos.cube(SectionPos.of(this.mob), 2).filter(var1 -> var0.sectionsToVillage((SectionPos)var1) == 0).collect(Collectors.toList());
        if (var12.isEmpty()) {
            return null;
        }
        return (SectionPos)var12.get(var0.random.nextInt(var12.size()));
    }

    private @Nullable BlockPos getRandomPoiWithinSection(SectionPos var02) {
        ServerLevel var1 = (ServerLevel)this.mob.level();
        PoiManager var2 = var1.getPoiManager();
        List var3 = var2.getInRange(var0 -> true, var02.center(), 8, PoiManager.Occupancy.IS_OCCUPIED).map(PoiRecord::getPos).collect(Collectors.toList());
        if (var3.isEmpty()) {
            return null;
        }
        return (BlockPos)var3.get(var1.random.nextInt(var3.size()));
    }

    private boolean doesVillagerWantGolem(Villager var0) {
        return var0.wantsToSpawnGolem(this.mob.level().getGameTime());
    }
}

