/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.goal;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.parrot.ShoulderRidingEntity;

public class LandOnOwnersShoulderGoal
extends Goal {
    private final ShoulderRidingEntity entity;
    private boolean isSittingOnShoulder;

    public LandOnOwnersShoulderGoal(ShoulderRidingEntity var0) {
        this.entity = var0;
    }

    @Override
    public boolean canUse() {
        LivingEntity livingEntity = this.entity.getOwner();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer var0 = (ServerPlayer)livingEntity;
            boolean var1 = !var0.isSpectator() && !var0.getAbilities().flying && !var0.isInWater() && !var0.isInPowderSnow;
            return !this.entity.isOrderedToSit() && var1 && this.entity.canSitOnShoulder();
        }
        return false;
    }

    @Override
    public boolean isInterruptable() {
        return !this.isSittingOnShoulder;
    }

    @Override
    public void start() {
        this.isSittingOnShoulder = false;
    }

    @Override
    public void tick() {
        if (this.isSittingOnShoulder || this.entity.isInSittingPose() || this.entity.isLeashed()) {
            return;
        }
        LivingEntity livingEntity = this.entity.getOwner();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer var0 = (ServerPlayer)livingEntity;
            if (this.entity.getBoundingBox().intersects(var0.getBoundingBox())) {
                this.isSittingOnShoulder = this.entity.setEntityOnShoulder(var0);
            }
        }
    }
}

