/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.goal;

import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.phys.Vec3;
import org.jspecify.annotations.Nullable;

public class WaterAvoidingRandomStrollGoal
extends RandomStrollGoal {
    public static final float PROBABILITY = 0.001f;
    protected final float probability;

    public WaterAvoidingRandomStrollGoal(PathfinderMob var0, double var1) {
        this(var0, var1, 0.001f);
    }

    public WaterAvoidingRandomStrollGoal(PathfinderMob var0, double var1, float var3) {
        super(var0, var1);
        this.probability = var3;
    }

    @Override
    protected @Nullable Vec3 getPosition() {
        if (this.mob.isInWater()) {
            Vec3 var0 = LandRandomPos.getPos(this.mob, 15, 7);
            return var0 == null ? super.getPosition() : var0;
        }
        if (this.mob.getRandom().nextFloat() >= this.probability) {
            return LandRandomPos.getPos(this.mob, 10, 7);
        }
        return super.getPosition();
    }
}

