/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.gossip;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.DoublePredicate;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.UUIDUtil;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.entity.ai.gossip.GossipType;
import net.minecraft.world.entity.npc.villager.Villager;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftVillager;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.entity.Villager;
import org.bukkit.event.entity.VillagerReputationChangeEvent;

public class GossipContainer {
    public static final Codec<GossipContainer> CODEC = GossipEntry.CODEC.listOf().xmap(GossipContainer::new, reputation -> reputation.unpack().toList());
    public static final int DISCARD_THRESHOLD = 2;
    private final Map<UUID, EntityGossips> gossips = new HashMap<UUID, EntityGossips>();
    public Villager villager;

    public GossipContainer(Villager villager) {
        this.villager = villager;
    }

    public GossipContainer() {
    }

    private GossipContainer(List<GossipEntry> list) {
        list.forEach(reputation_b -> this.getOrCreate((UUID)reputation_b.target).entries.put((Object)reputation_b.type, reputation_b.value));
    }

    @VisibleForDebug
    public Map<UUID, Object2IntMap<GossipType>> getGossipEntries() {
        HashMap map = Maps.newHashMap();
        this.gossips.keySet().forEach(uuid -> {
            EntityGossips reputation_a = this.gossips.get(uuid);
            map.put(uuid, reputation_a.entries);
        });
        return map;
    }

    public void decay() {
        Iterator<Map.Entry<UUID, EntityGossips>> iterator = this.gossips.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<UUID, EntityGossips> reputation_a = iterator.next();
            reputation_a.getValue().decay(this.villager, reputation_a.getKey());
            if (!reputation_a.getValue().isEmpty()) continue;
            iterator.remove();
        }
    }

    private Stream<GossipEntry> unpack() {
        return this.gossips.entrySet().stream().flatMap(entry -> ((EntityGossips)entry.getValue()).unpack((UUID)entry.getKey()));
    }

    private Collection<GossipEntry> selectGossipsForTransfer(RandomSource randomsource, int i) {
        List<GossipEntry> list = this.unpack().toList();
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        int[] aint = new int[list.size()];
        int j = 0;
        for (int k = 0; k < list.size(); ++k) {
            GossipEntry reputation_b = list.get(k);
            aint[k] = (j += Math.abs(reputation_b.weightedValue())) - 1;
        }
        Set set = Sets.newIdentityHashSet();
        for (int l = 0; l < i; ++l) {
            int i1 = randomsource.nextInt(j);
            int j1 = Arrays.binarySearch(aint, i1);
            set.add(list.get(j1 < 0 ? -j1 - 1 : j1));
        }
        return set;
    }

    private EntityGossips getOrCreate(UUID uuid) {
        return this.gossips.computeIfAbsent(uuid, uuid1 -> new EntityGossips());
    }

    public void transferFrom(GossipContainer reputation, RandomSource randomsource, int i) {
        Collection<GossipEntry> collection = reputation.selectGossipsForTransfer(randomsource, i);
        collection.forEach(reputation_b -> {
            int j = reputation_b.value - reputation_b.type.decayPerTransfer;
            if (j >= 2) {
                this.set(reputation_b.target, reputation_b.type, GossipContainer.mergeValuesForTransfer(this.getReputation(reputation_b.target, Predicate.isEqual(reputation_b.type), false), j), Villager.ReputationEvent.GOSSIP);
            }
        });
    }

    public int getReputation(UUID uuid, Predicate<GossipType> predicate) {
        return this.getReputation(uuid, predicate, true);
    }

    public int getReputation(UUID uuid, Predicate<GossipType> predicate, boolean weighted) {
        EntityGossips reputation_a = this.gossips.get(uuid);
        return reputation_a != null ? (weighted ? reputation_a.weightedValue(predicate) : reputation_a.unweightedValue(predicate)) : 0;
    }

    public long getCountForType(GossipType reputationtype, DoublePredicate doublepredicate) {
        return this.gossips.values().stream().filter(reputation_a -> doublepredicate.test(reputation_a.entries.getOrDefault((Object)reputationtype, 0) * reputationtype.weight)).count();
    }

    public void add(UUID uuid, GossipType reputationtype, int i) {
        this.add(uuid, reputationtype, i, Villager.ReputationEvent.UNSPECIFIED);
    }

    public void add(UUID uuid, GossipType reputationtype, int i, Villager.ReputationEvent changeReason) {
        EntityGossips reputation_a = this.getOrCreate(uuid);
        int oldValue = reputation_a.entries.getInt((Object)reputationtype);
        reputation_a.entries.mergeInt((Object)reputationtype, i, (j, k) -> this.mergeValuesForAddition(reputationtype, j, k));
        int newValue = reputation_a.entries.getInt((Object)reputationtype);
        newValue = Math.max(0, Math.min(newValue, reputationtype.max));
        reputation_a.entries.replace((Object)reputationtype, oldValue);
        VillagerReputationChangeEvent event = CraftEventFactory.callVillagerReputationChangeEvent((org.bukkit.entity.Villager)this.villager.getBukkitEntity(), uuid, changeReason, CraftVillager.CraftReputationType.minecraftToBukkit(reputationtype), oldValue, newValue, reputationtype.max);
        if (!event.isCancelled()) {
            reputation_a.entries.replace((Object)reputationtype, event.getNewValue());
            reputation_a.makeSureValueIsntTooLowOrTooHigh(reputationtype);
        }
        if (reputation_a.isEmpty()) {
            this.gossips.remove(uuid);
        }
    }

    public void set(UUID uuid, GossipType reputationType, int i, Villager.ReputationEvent changeReason) {
        int addAmount = i - this.getReputation(uuid, Predicate.isEqual(reputationType), false);
        if (addAmount == 0) {
            return;
        }
        this.add(uuid, reputationType, addAmount, changeReason);
    }

    public void remove(UUID uuid, GossipType reputationtype, int i, Villager.ReputationEvent changeReason) {
        this.add(uuid, reputationtype, -i, changeReason);
    }

    public void remove(UUID uuid, GossipType reputationtype, Villager.ReputationEvent changeReason) {
        EntityGossips reputation_a = this.gossips.get(uuid);
        if (reputation_a != null) {
            this.set(uuid, reputationtype, 0, changeReason);
            if (reputation_a.isEmpty()) {
                this.gossips.remove(uuid);
            }
        }
    }

    public void remove(GossipType reputationtype, Villager.ReputationEvent changeReason) {
        HashSet uuids = Sets.newHashSet(this.gossips.keySet());
        for (UUID uuid : uuids) {
            this.remove(uuid, reputationtype, changeReason);
        }
    }

    public void clear() {
        this.gossips.clear();
    }

    public void putAll(GossipContainer reputation) {
        reputation.gossips.forEach((uuid, reputation_a) -> this.getOrCreate((UUID)uuid).entries.putAll(reputation_a.entries));
    }

    private static int mergeValuesForTransfer(int i, int j) {
        return Math.max(i, j);
    }

    private int mergeValuesForAddition(GossipType reputationtype, int i, int j) {
        int k = i + j;
        return k > reputationtype.max ? Math.max(reputationtype.max, i) : k;
    }

    public GossipContainer copy() {
        GossipContainer reputation = new GossipContainer(this.villager);
        reputation.putAll(this);
        return reputation;
    }

    private static class EntityGossips {
        final Object2IntMap<GossipType> entries = new Object2IntOpenHashMap();

        EntityGossips() {
        }

        public int weightedValue(Predicate<GossipType> predicate) {
            return this.entries.object2IntEntrySet().stream().filter(entry -> predicate.test((GossipType)entry.getKey())).mapToInt(entry -> entry.getIntValue() * ((GossipType)entry.getKey()).weight).sum();
        }

        public int unweightedValue(Predicate<GossipType> predicate) {
            return this.entries.object2IntEntrySet().stream().filter(entry -> predicate.test((GossipType)entry.getKey())).mapToInt(entry -> entry.getIntValue()).sum();
        }

        public Stream<GossipEntry> unpack(UUID uuid) {
            return this.entries.object2IntEntrySet().stream().map(entry -> new GossipEntry(uuid, (GossipType)entry.getKey(), entry.getIntValue()));
        }

        public void decay(Villager villager, UUID uuid) {
            ObjectIterator objectiterator = this.entries.object2IntEntrySet().iterator();
            while (objectiterator.hasNext()) {
                Object2IntMap.Entry object2intmap_entry = (Object2IntMap.Entry)objectiterator.next();
                int i = object2intmap_entry.getIntValue() - ((GossipType)object2intmap_entry.getKey()).decayPerDay;
                VillagerReputationChangeEvent event = CraftEventFactory.callVillagerReputationChangeEvent((org.bukkit.entity.Villager)villager.getBukkitEntity(), uuid, Villager.ReputationEvent.DECAY, CraftVillager.CraftReputationType.minecraftToBukkit((GossipType)object2intmap_entry.getKey()), object2intmap_entry.getIntValue(), i, ((GossipType)object2intmap_entry.getKey()).max);
                if (event.isCancelled()) continue;
                i = event.getNewValue();
                if (i < 2) {
                    objectiterator.remove();
                    continue;
                }
                object2intmap_entry.setValue(i);
            }
        }

        public boolean isEmpty() {
            return this.entries.isEmpty();
        }

        public void makeSureValueIsntTooLowOrTooHigh(GossipType reputationtype) {
            int i = this.entries.getInt((Object)reputationtype);
            if (i > reputationtype.max) {
                this.entries.put((Object)reputationtype, reputationtype.max);
            }
            if (i < 2) {
                this.remove(reputationtype);
            }
        }

        public void remove(GossipType reputationtype) {
            this.entries.removeInt((Object)reputationtype);
        }
    }

    private record GossipEntry(UUID target, GossipType type, int value) {
        public static final Codec<GossipEntry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)UUIDUtil.CODEC.fieldOf("Target").forGetter(GossipEntry::target), (App)GossipType.CODEC.fieldOf("Type").forGetter(GossipEntry::type), (App)ExtraCodecs.POSITIVE_INT.fieldOf("Value").forGetter(GossipEntry::value)).apply((Applicative)instance, GossipEntry::new));

        public int weightedValue() {
            return this.value * this.type.weight;
        }
    }
}

