/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.sensing;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;

public class GolemSensor
extends Sensor<LivingEntity> {
    private static final int GOLEM_SCAN_RATE = 200;
    private static final int MEMORY_TIME_TO_LIVE = 599;

    public GolemSensor() {
        this(200);
    }

    public GolemSensor(int var0) {
        super(var0);
    }

    @Override
    protected void doTick(ServerLevel var0, LivingEntity var1) {
        GolemSensor.checkForNearbyGolem(var1);
    }

    @Override
    public Set<MemoryModuleType<?>> requires() {
        return ImmutableSet.of(MemoryModuleType.NEAREST_LIVING_ENTITIES);
    }

    public static void checkForNearbyGolem(LivingEntity var02) {
        Optional<List<LivingEntity>> var1 = var02.getBrain().getMemory(MemoryModuleType.NEAREST_LIVING_ENTITIES);
        if (var1.isEmpty()) {
            return;
        }
        boolean var2 = var1.get().stream().anyMatch(var0 -> var0.getType().equals(EntityType.IRON_GOLEM));
        if (var2) {
            GolemSensor.golemDetected(var02);
        }
    }

    public static void golemDetected(LivingEntity var0) {
        var0.getBrain().setMemoryWithExpiry(MemoryModuleType.GOLEM_DETECTED_RECENTLY, true, 599L);
    }
}

