/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.sensing;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.monster.hoglin.Hoglin;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.monster.piglin.PiglinBrute;
import net.minecraft.world.entity.monster.skeleton.WitherSkeleton;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;

public class PiglinSpecificSensor
extends Sensor<LivingEntity> {
    @Override
    public Set<MemoryModuleType<?>> requires() {
        return ImmutableSet.of(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, MemoryModuleType.NEAREST_LIVING_ENTITIES, MemoryModuleType.NEAREST_VISIBLE_NEMESIS, MemoryModuleType.NEAREST_TARGETABLE_PLAYER_NOT_WEARING_GOLD, MemoryModuleType.NEAREST_PLAYER_HOLDING_WANTED_ITEM, MemoryModuleType.NEAREST_VISIBLE_HUNTABLE_HOGLIN, (Object[])new MemoryModuleType[]{MemoryModuleType.NEAREST_VISIBLE_BABY_HOGLIN, MemoryModuleType.NEAREST_VISIBLE_ADULT_PIGLINS, MemoryModuleType.NEARBY_ADULT_PIGLINS, MemoryModuleType.VISIBLE_ADULT_PIGLIN_COUNT, MemoryModuleType.VISIBLE_ADULT_HOGLIN_COUNT, MemoryModuleType.NEAREST_REPELLENT});
    }

    @Override
    protected void doTick(ServerLevel var02, LivingEntity var1) {
        AbstractPiglin var17;
        Brain<?> var2 = var1.getBrain();
        var2.setMemory(MemoryModuleType.NEAREST_REPELLENT, PiglinSpecificSensor.findNearestRepellent(var02, var1));
        Optional<Object> var3 = Optional.empty();
        Optional<Object> var4 = Optional.empty();
        Optional<Object> var5 = Optional.empty();
        Optional<Object> var6 = Optional.empty();
        Optional<Object> var7 = Optional.empty();
        Optional<Object> var8 = Optional.empty();
        Optional<Object> var9 = Optional.empty();
        int var10 = 0;
        ArrayList var11 = Lists.newArrayList();
        ArrayList var12 = Lists.newArrayList();
        NearestVisibleLivingEntities var13 = var2.getMemory(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES).orElse(NearestVisibleLivingEntities.empty());
        for (LivingEntity var15 : var13.findAll(var0 -> true)) {
            if (var15 instanceof Hoglin) {
                LivingEntity var16 = (Hoglin)var15;
                if (((AgeableMob)var16).isBaby() && var5.isEmpty()) {
                    var5 = Optional.of(var16);
                    continue;
                }
                if (!((Hoglin)var16).isAdult()) continue;
                ++var10;
                if (!var4.isEmpty() || !((Hoglin)var16).canBeHunted()) continue;
                var4 = Optional.of(var16);
                continue;
            }
            if (var15 instanceof PiglinBrute) {
                var17 = (PiglinBrute)var15;
                var11.add(var17);
                continue;
            }
            if (var15 instanceof Piglin) {
                Piglin var18 = (Piglin)var15;
                if (var18.isBaby() && var6.isEmpty()) {
                    var6 = Optional.of(var18);
                    continue;
                }
                if (!var18.isAdult()) continue;
                var11.add(var18);
                continue;
            }
            if (var15 instanceof Player) {
                Player var19 = (Player)var15;
                if (var8.isEmpty() && !PiglinAi.isWearingSafeArmor(var19) && var1.canAttack(var15)) {
                    var8 = Optional.of(var19);
                }
                if (!var9.isEmpty() || var19.isSpectator() || !PiglinAi.isPlayerHoldingLovedItem(var19)) continue;
                var9 = Optional.of(var19);
                continue;
            }
            if (var3.isEmpty() && (var15 instanceof WitherSkeleton || var15 instanceof WitherBoss)) {
                var3 = Optional.of((Mob)var15);
                continue;
            }
            if (!var7.isEmpty() || !PiglinAi.isZombified(var15.getType())) continue;
            var7 = Optional.of(var15);
        }
        List<LivingEntity> var14 = var2.getMemory(MemoryModuleType.NEAREST_LIVING_ENTITIES).orElse((List<LivingEntity>)ImmutableList.of());
        for (LivingEntity var16 : var14) {
            if (!(var16 instanceof AbstractPiglin) || !(var17 = (AbstractPiglin)var16).isAdult()) continue;
            var12.add(var17);
        }
        var2.setMemory(MemoryModuleType.NEAREST_VISIBLE_NEMESIS, var3);
        var2.setMemory(MemoryModuleType.NEAREST_VISIBLE_HUNTABLE_HOGLIN, var4);
        var2.setMemory(MemoryModuleType.NEAREST_VISIBLE_BABY_HOGLIN, var5);
        var2.setMemory(MemoryModuleType.NEAREST_VISIBLE_ZOMBIFIED, var7);
        var2.setMemory(MemoryModuleType.NEAREST_TARGETABLE_PLAYER_NOT_WEARING_GOLD, var8);
        var2.setMemory(MemoryModuleType.NEAREST_PLAYER_HOLDING_WANTED_ITEM, var9);
        var2.setMemory(MemoryModuleType.NEARBY_ADULT_PIGLINS, var12);
        var2.setMemory(MemoryModuleType.NEAREST_VISIBLE_ADULT_PIGLINS, var11);
        var2.setMemory(MemoryModuleType.VISIBLE_ADULT_PIGLIN_COUNT, var11.size());
        var2.setMemory(MemoryModuleType.VISIBLE_ADULT_HOGLIN_COUNT, var10);
    }

    private static Optional<BlockPos> findNearestRepellent(ServerLevel var0, LivingEntity var12) {
        return BlockPos.findClosestMatch(var12.blockPosition(), 8, 4, var1 -> PiglinSpecificSensor.isValidRepellent(var0, var1));
    }

    private static boolean isValidRepellent(ServerLevel var0, BlockPos var1) {
        BlockState var2 = var0.getBlockState(var1);
        boolean var3 = var2.is(BlockTags.PIGLIN_REPELLENTS);
        if (var3 && var2.is(Blocks.SOUL_CAMPFIRE)) {
            return CampfireBlock.isLitCampfire(var2);
        }
        return var3;
    }
}

