/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.sensing;

import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiPredicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;

public abstract class Sensor<E extends LivingEntity> {
    private static final RandomSource RANDOM = RandomSource.createThreadSafe();
    private static final int DEFAULT_SCAN_RATE = 20;
    private static final int DEFAULT_TARGETING_RANGE = 16;
    private static final TargetingConditions TARGET_CONDITIONS = TargetingConditions.forNonCombat().range(16.0);
    private static final TargetingConditions TARGET_CONDITIONS_IGNORE_INVISIBILITY_TESTING = TargetingConditions.forNonCombat().range(16.0).ignoreInvisibilityTesting();
    private static final TargetingConditions ATTACK_TARGET_CONDITIONS = TargetingConditions.forCombat().range(16.0);
    private static final TargetingConditions ATTACK_TARGET_CONDITIONS_IGNORE_INVISIBILITY_TESTING = TargetingConditions.forCombat().range(16.0).ignoreInvisibilityTesting();
    private static final TargetingConditions ATTACK_TARGET_CONDITIONS_IGNORE_LINE_OF_SIGHT = TargetingConditions.forCombat().range(16.0).ignoreLineOfSight();
    private static final TargetingConditions ATTACK_TARGET_CONDITIONS_IGNORE_INVISIBILITY_AND_LINE_OF_SIGHT = TargetingConditions.forCombat().range(16.0).ignoreLineOfSight().ignoreInvisibilityTesting();
    private final int scanRate;
    private long timeToTick;

    public Sensor(int var0) {
        this.scanRate = var0;
        this.timeToTick = RANDOM.nextInt(var0);
    }

    public Sensor() {
        this(20);
    }

    public final void tick(ServerLevel var0, E var1) {
        if (--this.timeToTick <= 0L) {
            this.timeToTick = this.scanRate;
            this.updateTargetingConditionRanges(var1);
            this.doTick(var0, var1);
        }
    }

    private void updateTargetingConditionRanges(E var0) {
        double var1 = ((LivingEntity)var0).getAttributeValue(Attributes.FOLLOW_RANGE);
        TARGET_CONDITIONS.range(var1);
        TARGET_CONDITIONS_IGNORE_INVISIBILITY_TESTING.range(var1);
        ATTACK_TARGET_CONDITIONS.range(var1);
        ATTACK_TARGET_CONDITIONS_IGNORE_INVISIBILITY_TESTING.range(var1);
        ATTACK_TARGET_CONDITIONS_IGNORE_LINE_OF_SIGHT.range(var1);
        ATTACK_TARGET_CONDITIONS_IGNORE_INVISIBILITY_AND_LINE_OF_SIGHT.range(var1);
    }

    protected abstract void doTick(ServerLevel var1, E var2);

    public abstract Set<MemoryModuleType<?>> requires();

    public static boolean isEntityTargetable(ServerLevel var0, LivingEntity var1, LivingEntity var2) {
        if (var1.getBrain().isMemoryValue(MemoryModuleType.ATTACK_TARGET, var2)) {
            return TARGET_CONDITIONS_IGNORE_INVISIBILITY_TESTING.test(var0, var1, var2);
        }
        return TARGET_CONDITIONS.test(var0, var1, var2);
    }

    public static boolean isEntityAttackable(ServerLevel var0, LivingEntity var1, LivingEntity var2) {
        if (var1.getBrain().isMemoryValue(MemoryModuleType.ATTACK_TARGET, var2)) {
            return ATTACK_TARGET_CONDITIONS_IGNORE_INVISIBILITY_TESTING.test(var0, var1, var2);
        }
        return ATTACK_TARGET_CONDITIONS.test(var0, var1, var2);
    }

    public static BiPredicate<ServerLevel, LivingEntity> wasEntityAttackableLastNTicks(LivingEntity var0, int var12) {
        return Sensor.rememberPositives(var12, (var1, var2) -> Sensor.isEntityAttackable(var1, var0, var2));
    }

    public static boolean isEntityAttackableIgnoringLineOfSight(ServerLevel var0, LivingEntity var1, LivingEntity var2) {
        if (var1.getBrain().isMemoryValue(MemoryModuleType.ATTACK_TARGET, var2)) {
            return ATTACK_TARGET_CONDITIONS_IGNORE_INVISIBILITY_AND_LINE_OF_SIGHT.test(var0, var1, var2);
        }
        return ATTACK_TARGET_CONDITIONS_IGNORE_LINE_OF_SIGHT.test(var0, var1, var2);
    }

    static <T, U> BiPredicate<T, U> rememberPositives(int var0, BiPredicate<T, U> var1) {
        AtomicInteger var2 = new AtomicInteger(0);
        return (var3, var4) -> {
            if (var1.test(var3, var4)) {
                var2.set(var0);
                return true;
            }
            return var2.decrementAndGet() >= 0;
        };
    }
}

