/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.targeting;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import org.jspecify.annotations.Nullable;

public class TargetingConditions {
    public static final TargetingConditions DEFAULT = TargetingConditions.forCombat();
    private static final double MIN_VISIBILITY_DISTANCE_FOR_INVISIBLE_TARGET = 2.0;
    private final boolean isCombat;
    private double range = -1.0;
    private boolean checkLineOfSight = true;
    private boolean testInvisible = true;
    private @Nullable Selector selector;

    private TargetingConditions(boolean var0) {
        this.isCombat = var0;
    }

    public static TargetingConditions forCombat() {
        return new TargetingConditions(true);
    }

    public static TargetingConditions forNonCombat() {
        return new TargetingConditions(false);
    }

    public TargetingConditions copy() {
        TargetingConditions var0 = this.isCombat ? TargetingConditions.forCombat() : TargetingConditions.forNonCombat();
        var0.range = this.range;
        var0.checkLineOfSight = this.checkLineOfSight;
        var0.testInvisible = this.testInvisible;
        var0.selector = this.selector;
        return var0;
    }

    public TargetingConditions range(double var0) {
        this.range = var0;
        return this;
    }

    public TargetingConditions ignoreLineOfSight() {
        this.checkLineOfSight = false;
        return this;
    }

    public TargetingConditions ignoreInvisibilityTesting() {
        this.testInvisible = false;
        return this;
    }

    public TargetingConditions selector(@Nullable Selector var0) {
        this.selector = var0;
        return this;
    }

    public boolean test(ServerLevel var0, @Nullable LivingEntity var1, LivingEntity var2) {
        if (var1 == var2) {
            return false;
        }
        if (!var2.canBeSeenByAnyone()) {
            return false;
        }
        if (this.selector != null && !this.selector.test(var2, var0)) {
            return false;
        }
        if (var1 == null) {
            if (this.isCombat && (!var2.canBeSeenAsEnemy() || var0.getDifficulty() == Difficulty.PEACEFUL)) {
                return false;
            }
        } else {
            Mob var3;
            if (this.isCombat && (!var1.canAttack(var2) || !var1.canAttackType(var2.getType()) || var1.isAlliedTo(var2))) {
                return false;
            }
            if (this.range > 0.0) {
                double var32 = this.testInvisible ? var2.getVisibilityPercent(var1) : 1.0;
                double var5 = Math.max(this.range * var32, 2.0);
                double var7 = var1.distanceToSqr(var2.getX(), var2.getY(), var2.getZ());
                if (var7 > var5 * var5) {
                    return false;
                }
            }
            if (this.checkLineOfSight && var1 instanceof Mob && !(var3 = (Mob)var1).getSensing().hasLineOfSight(var2)) {
                return false;
            }
        }
        return true;
    }

    @FunctionalInterface
    public static interface Selector {
        public boolean test(LivingEntity var1, ServerLevel var2);
    }
}

