/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.util;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.util.GoalUtils;
import net.minecraft.world.entity.ai.util.RandomPos;
import net.minecraft.world.phys.Vec3;
import org.jspecify.annotations.Nullable;

public class DefaultRandomPos {
    public static @Nullable Vec3 getPos(PathfinderMob var0, int var1, int var2) {
        boolean var3 = GoalUtils.mobRestricted(var0, var1);
        return RandomPos.generateRandomPos(var0, () -> {
            BlockPos var4 = RandomPos.generateRandomDirection(var0.getRandom(), var1, var2);
            return DefaultRandomPos.generateRandomPosTowardDirection(var0, var1, var3, var4);
        });
    }

    public static @Nullable Vec3 getPosTowards(PathfinderMob var0, int var1, int var2, Vec3 var3, double var4) {
        Vec3 var6 = var3.subtract(var0.getX(), var0.getY(), var0.getZ());
        boolean var7 = GoalUtils.mobRestricted(var0, var1);
        return RandomPos.generateRandomPos(var0, () -> {
            BlockPos var7 = RandomPos.generateRandomDirectionWithinRadians(var0.getRandom(), 0.0, var1, var2, 0, var3.x, var3.z, var4);
            if (var7 == null) {
                return null;
            }
            return DefaultRandomPos.generateRandomPosTowardDirection(var0, var1, var7, var7);
        });
    }

    public static @Nullable Vec3 getPosAway(PathfinderMob var0, int var1, int var2, Vec3 var3) {
        Vec3 var4 = var0.position().subtract(var3);
        boolean var5 = GoalUtils.mobRestricted(var0, var1);
        return RandomPos.generateRandomPos(var0, () -> {
            BlockPos var5 = RandomPos.generateRandomDirectionWithinRadians(var0.getRandom(), 0.0, var1, var2, 0, var3.x, var3.z, 1.5707963705062866);
            if (var5 == null) {
                return null;
            }
            return DefaultRandomPos.generateRandomPosTowardDirection(var0, var1, var5, var5);
        });
    }

    private static @Nullable BlockPos generateRandomPosTowardDirection(PathfinderMob var0, int var1, boolean var2, BlockPos var3) {
        BlockPos var4 = RandomPos.generateRandomPosTowardDirection(var0, var1, var0.getRandom(), var3);
        if (GoalUtils.isOutsideLimits(var4, var0) || GoalUtils.isRestricted(var2, var0, var4) || GoalUtils.isNotStable(var0.getNavigation(), var4) || GoalUtils.hasMalus(var0, var4)) {
            return null;
        }
        return var4;
    }
}

