/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.equine;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.equine.AbstractChestedHorse;
import net.minecraft.world.entity.animal.equine.AbstractHorse;
import net.minecraft.world.entity.animal.equine.Horse;
import net.minecraft.world.level.Level;
import org.jspecify.annotations.Nullable;

public class Donkey
extends AbstractChestedHorse {
    public Donkey(EntityType<? extends Donkey> var0, Level var1) {
        super((EntityType<? extends AbstractChestedHorse>)var0, var1);
    }

    @Override
    protected SoundEvent getAmbientSound() {
        return SoundEvents.DONKEY_AMBIENT;
    }

    @Override
    protected SoundEvent getAngrySound() {
        return SoundEvents.DONKEY_ANGRY;
    }

    @Override
    protected SoundEvent getDeathSound() {
        return SoundEvents.DONKEY_DEATH;
    }

    @Override
    protected SoundEvent getEatingSound() {
        return SoundEvents.DONKEY_EAT;
    }

    @Override
    protected SoundEvent getHurtSound(DamageSource var0) {
        return SoundEvents.DONKEY_HURT;
    }

    @Override
    public boolean canMate(Animal var0) {
        if (var0 == this) {
            return false;
        }
        if (var0 instanceof Donkey || var0 instanceof Horse) {
            return this.canParent() && ((AbstractHorse)var0).canParent();
        }
        return false;
    }

    @Override
    protected void playJumpSound() {
        this.playSound(SoundEvents.DONKEY_JUMP, 0.4f, 1.0f);
    }

    @Override
    public @Nullable AgeableMob getBreedOffspring(ServerLevel var0, AgeableMob var1) {
        EntityType<AbstractChestedHorse> var2 = var1 instanceof Horse ? EntityType.MULE : EntityType.DONKEY;
        AbstractHorse var3 = var2.create(var0, EntitySpawnReason.BREEDING);
        if (var3 != null) {
            this.setOffspringAttributes(var1, var3);
        }
        return var3;
    }
}

