/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.equine;

import java.util.function.DoubleSupplier;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityAttachment;
import net.minecraft.world.entity.EntityAttachments;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.animal.equine.AbstractHorse;
import net.minecraft.world.entity.monster.zombie.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import org.jspecify.annotations.Nullable;

public class ZombieHorse
extends AbstractHorse {
    private static final float SPEED_FACTOR = 42.16f;
    private static final double BASE_JUMP_STRENGTH = 0.5;
    private static final double PER_RANDOM_JUMP_STRENGTH = 0.06666666666666667;
    private static final double BASE_SPEED = 9.0;
    private static final double PER_RANDOM_SPEED = 1.0;
    private static final EntityDimensions BABY_DIMENSIONS = EntityType.ZOMBIE_HORSE.getDimensions().withAttachments(EntityAttachments.builder().attach(EntityAttachment.PASSENGER, 0.0f, EntityType.ZOMBIE_HORSE.getHeight() - 0.03125f, 0.0f)).scale(0.5f);

    public ZombieHorse(EntityType<? extends ZombieHorse> var0, Level var1) {
        super((EntityType<? extends AbstractHorse>)var0, var1);
        this.setPathfindingMalus(PathType.DANGER_OTHER, -1.0f);
        this.setPathfindingMalus(PathType.DAMAGE_OTHER, -1.0f);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return ZombieHorse.createBaseHorseAttributes().add(Attributes.MAX_HEALTH, 25.0);
    }

    @Override
    public InteractionResult interact(Player var0, InteractionHand var1) {
        this.setPersistenceRequired();
        return super.interact(var0, var1);
    }

    @Override
    public boolean removeWhenFarAway(double var0) {
        return true;
    }

    @Override
    public boolean isMobControlled() {
        return this.getFirstPassenger() instanceof Mob;
    }

    @Override
    protected void randomizeAttributes(RandomSource var0) {
        this.getAttribute(Attributes.JUMP_STRENGTH).setBaseValue(ZombieHorse.generateZombieHorseJumpStrength(var0::nextDouble));
        this.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(ZombieHorse.generateZombieHorseSpeed(var0::nextDouble));
    }

    private static double generateZombieHorseJumpStrength(DoubleSupplier var0) {
        return 0.5 + var0.getAsDouble() * 0.06666666666666667 + var0.getAsDouble() * 0.06666666666666667 + var0.getAsDouble() * 0.06666666666666667;
    }

    private static double generateZombieHorseSpeed(DoubleSupplier var0) {
        return (9.0 + var0.getAsDouble() * 1.0 + var0.getAsDouble() * 1.0 + var0.getAsDouble() * 1.0) / (double)42.16f;
    }

    @Override
    protected SoundEvent getAmbientSound() {
        return SoundEvents.ZOMBIE_HORSE_AMBIENT;
    }

    @Override
    protected SoundEvent getDeathSound() {
        return SoundEvents.ZOMBIE_HORSE_DEATH;
    }

    @Override
    protected SoundEvent getHurtSound(DamageSource var0) {
        return SoundEvents.ZOMBIE_HORSE_HURT;
    }

    @Override
    protected SoundEvent getAngrySound() {
        return SoundEvents.ZOMBIE_HORSE_ANGRY;
    }

    @Override
    protected SoundEvent getEatingSound() {
        return SoundEvents.ZOMBIE_HORSE_EAT;
    }

    @Override
    public @Nullable AgeableMob getBreedOffspring(ServerLevel var0, AgeableMob var1) {
        return null;
    }

    @Override
    public boolean canFallInLove() {
        return false;
    }

    @Override
    protected void addBehaviourGoals() {
        this.goalSelector.addGoal(0, new FloatGoal(this));
        this.goalSelector.addGoal(3, new TemptGoal(this, 1.25, var0 -> var0.is(ItemTags.ZOMBIE_HORSE_FOOD), false));
    }

    @Override
    public @Nullable SpawnGroupData finalizeSpawn(ServerLevelAccessor var0, DifficultyInstance var1, EntitySpawnReason var2, @Nullable SpawnGroupData var3) {
        Zombie var4;
        if (var2 == EntitySpawnReason.NATURAL && (var4 = EntityType.ZOMBIE.create(this.level(), EntitySpawnReason.JOCKEY)) != null) {
            var4.snapTo(this.getX(), this.getY(), this.getZ(), this.getYRot(), 0.0f);
            var4.finalizeSpawn(var0, var1, var2, null);
            var4.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack(Items.IRON_SPEAR));
            var4.startRiding(this, false, false);
        }
        return super.finalizeSpawn(var0, var1, var2, var3);
    }

    @Override
    public InteractionResult mobInteract(Player var0, InteractionHand var1) {
        boolean var2;
        boolean bl = var2 = !this.isBaby() && this.isTamed() && var0.isSecondaryUseActive();
        if (this.isVehicle() || var2) {
            return super.mobInteract(var0, var1);
        }
        ItemStack var3 = var0.getItemInHand(var1);
        if (!var3.isEmpty()) {
            if (this.isFood(var3)) {
                return this.fedFood(var0, var3);
            }
            if (!this.isTamed()) {
                this.makeMad();
                return InteractionResult.SUCCESS;
            }
        }
        return super.mobInteract(var0, var1);
    }

    @Override
    public boolean canUseSlot(EquipmentSlot var0) {
        return true;
    }

    @Override
    public boolean canBeLeashed() {
        return this.isTamed() || !this.isMobControlled();
    }

    @Override
    public boolean isFood(ItemStack var0) {
        return var0.is(ItemTags.ZOMBIE_HORSE_FOOD);
    }

    @Override
    protected EquipmentSlot sunProtectionSlot() {
        return EquipmentSlot.BODY;
    }

    @Override
    public Vec3[] getQuadLeashOffsets() {
        return Leashable.createQuadLeashOffsets(this, 0.04, 0.41, 0.18, 0.73);
    }

    @Override
    public EntityDimensions getDefaultDimensions(Pose var0) {
        return this.isBaby() ? BABY_DIMENSIONS : super.getDefaultDimensions(var0);
    }

    @Override
    public float chargeSpeedModifier() {
        return 1.4f;
    }
}

