/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.fish;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.util.Util;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.animal.fish.AbstractSchoolingFish;
import net.minecraft.world.entity.animal.fish.WaterAnimal;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipProvider;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jspecify.annotations.Nullable;

public class TropicalFish
extends AbstractSchoolingFish {
    public static final Variant DEFAULT_VARIANT = new Variant(Pattern.KOB, DyeColor.WHITE, DyeColor.WHITE);
    private static final EntityDataAccessor<Integer> DATA_ID_TYPE_VARIANT = SynchedEntityData.defineId(TropicalFish.class, EntityDataSerializers.INT);
    public static final List<Variant> COMMON_VARIANTS = List.of(new Variant(Pattern.STRIPEY, DyeColor.ORANGE, DyeColor.GRAY), new Variant(Pattern.FLOPPER, DyeColor.GRAY, DyeColor.GRAY), new Variant(Pattern.FLOPPER, DyeColor.GRAY, DyeColor.BLUE), new Variant(Pattern.CLAYFISH, DyeColor.WHITE, DyeColor.GRAY), new Variant(Pattern.SUNSTREAK, DyeColor.BLUE, DyeColor.GRAY), new Variant(Pattern.KOB, DyeColor.ORANGE, DyeColor.WHITE), new Variant(Pattern.SPOTTY, DyeColor.PINK, DyeColor.LIGHT_BLUE), new Variant(Pattern.BLOCKFISH, DyeColor.PURPLE, DyeColor.YELLOW), new Variant(Pattern.CLAYFISH, DyeColor.WHITE, DyeColor.RED), new Variant(Pattern.SPOTTY, DyeColor.WHITE, DyeColor.YELLOW), new Variant(Pattern.GLITTER, DyeColor.WHITE, DyeColor.GRAY), new Variant(Pattern.CLAYFISH, DyeColor.WHITE, DyeColor.ORANGE), new Variant(Pattern.DASHER, DyeColor.CYAN, DyeColor.PINK), new Variant(Pattern.BRINELY, DyeColor.LIME, DyeColor.LIGHT_BLUE), new Variant(Pattern.BETTY, DyeColor.RED, DyeColor.WHITE), new Variant(Pattern.SNOOPER, DyeColor.GRAY, DyeColor.RED), new Variant(Pattern.BLOCKFISH, DyeColor.RED, DyeColor.WHITE), new Variant(Pattern.FLOPPER, DyeColor.WHITE, DyeColor.YELLOW), new Variant(Pattern.KOB, DyeColor.RED, DyeColor.WHITE), new Variant(Pattern.SUNSTREAK, DyeColor.GRAY, DyeColor.WHITE), new Variant(Pattern.DASHER, DyeColor.CYAN, DyeColor.YELLOW), new Variant(Pattern.FLOPPER, DyeColor.YELLOW, DyeColor.YELLOW));
    private boolean isSchool = true;

    public TropicalFish(EntityType<? extends TropicalFish> var0, Level var1) {
        super((EntityType<? extends AbstractSchoolingFish>)var0, var1);
    }

    public static String getPredefinedName(int var0) {
        return "entity.minecraft.tropical_fish.predefined." + var0;
    }

    static int packVariant(Pattern var0, DyeColor var1, DyeColor var2) {
        return var0.getPackedId() & 0xFFFF | (var1.getId() & 0xFF) << 16 | (var2.getId() & 0xFF) << 24;
    }

    public static DyeColor getBaseColor(int var0) {
        return DyeColor.byId(var0 >> 16 & 0xFF);
    }

    public static DyeColor getPatternColor(int var0) {
        return DyeColor.byId(var0 >> 24 & 0xFF);
    }

    public static Pattern getPattern(int var0) {
        return Pattern.byId(var0 & 0xFFFF);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder var0) {
        super.defineSynchedData(var0);
        var0.define(DATA_ID_TYPE_VARIANT, DEFAULT_VARIANT.getPackedId());
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput var0) {
        super.addAdditionalSaveData(var0);
        var0.store("Variant", Variant.CODEC, new Variant(this.getPackedVariant()));
    }

    @Override
    protected void readAdditionalSaveData(ValueInput var0) {
        super.readAdditionalSaveData(var0);
        Variant var1 = var0.read("Variant", Variant.CODEC).orElse(DEFAULT_VARIANT);
        this.setPackedVariant(var1.getPackedId());
    }

    public void setPackedVariant(int var0) {
        this.entityData.set(DATA_ID_TYPE_VARIANT, var0);
    }

    @Override
    public boolean isMaxGroupSizeReached(int var0) {
        return !this.isSchool;
    }

    public int getPackedVariant() {
        return this.entityData.get(DATA_ID_TYPE_VARIANT);
    }

    public DyeColor getBaseColor() {
        return TropicalFish.getBaseColor(this.getPackedVariant());
    }

    public DyeColor getPatternColor() {
        return TropicalFish.getPatternColor(this.getPackedVariant());
    }

    public Pattern getPattern() {
        return TropicalFish.getPattern(this.getPackedVariant());
    }

    private void setPattern(Pattern var0) {
        int var1 = this.getPackedVariant();
        DyeColor var2 = TropicalFish.getBaseColor(var1);
        DyeColor var3 = TropicalFish.getPatternColor(var1);
        this.setPackedVariant(TropicalFish.packVariant(var0, var2, var3));
    }

    private void setBaseColor(DyeColor var0) {
        int var1 = this.getPackedVariant();
        Pattern var2 = TropicalFish.getPattern(var1);
        DyeColor var3 = TropicalFish.getPatternColor(var1);
        this.setPackedVariant(TropicalFish.packVariant(var2, var0, var3));
    }

    private void setPatternColor(DyeColor var0) {
        int var1 = this.getPackedVariant();
        Pattern var2 = TropicalFish.getPattern(var1);
        DyeColor var3 = TropicalFish.getBaseColor(var1);
        this.setPackedVariant(TropicalFish.packVariant(var2, var3, var0));
    }

    @Override
    public <T> @Nullable T get(DataComponentType<? extends T> var0) {
        if (var0 == DataComponents.TROPICAL_FISH_PATTERN) {
            return TropicalFish.castComponentValue(var0, this.getPattern());
        }
        if (var0 == DataComponents.TROPICAL_FISH_BASE_COLOR) {
            return TropicalFish.castComponentValue(var0, this.getBaseColor());
        }
        if (var0 == DataComponents.TROPICAL_FISH_PATTERN_COLOR) {
            return TropicalFish.castComponentValue(var0, this.getPatternColor());
        }
        return super.get(var0);
    }

    @Override
    protected void applyImplicitComponents(DataComponentGetter var0) {
        this.applyImplicitComponentIfPresent(var0, DataComponents.TROPICAL_FISH_PATTERN);
        this.applyImplicitComponentIfPresent(var0, DataComponents.TROPICAL_FISH_BASE_COLOR);
        this.applyImplicitComponentIfPresent(var0, DataComponents.TROPICAL_FISH_PATTERN_COLOR);
        super.applyImplicitComponents(var0);
    }

    @Override
    protected <T> boolean applyImplicitComponent(DataComponentType<T> var0, T var1) {
        if (var0 == DataComponents.TROPICAL_FISH_PATTERN) {
            this.setPattern(TropicalFish.castComponentValue(DataComponents.TROPICAL_FISH_PATTERN, var1));
            return true;
        }
        if (var0 == DataComponents.TROPICAL_FISH_BASE_COLOR) {
            this.setBaseColor(TropicalFish.castComponentValue(DataComponents.TROPICAL_FISH_BASE_COLOR, var1));
            return true;
        }
        if (var0 == DataComponents.TROPICAL_FISH_PATTERN_COLOR) {
            this.setPatternColor(TropicalFish.castComponentValue(DataComponents.TROPICAL_FISH_PATTERN_COLOR, var1));
            return true;
        }
        return super.applyImplicitComponent(var0, var1);
    }

    @Override
    public void saveToBucketTag(ItemStack var0) {
        super.saveToBucketTag(var0);
        var0.copyFrom(DataComponents.TROPICAL_FISH_PATTERN, this);
        var0.copyFrom(DataComponents.TROPICAL_FISH_BASE_COLOR, this);
        var0.copyFrom(DataComponents.TROPICAL_FISH_PATTERN_COLOR, this);
    }

    @Override
    public ItemStack getBucketItemStack() {
        return new ItemStack(Items.TROPICAL_FISH_BUCKET);
    }

    @Override
    protected SoundEvent getAmbientSound() {
        return SoundEvents.TROPICAL_FISH_AMBIENT;
    }

    @Override
    protected SoundEvent getDeathSound() {
        return SoundEvents.TROPICAL_FISH_DEATH;
    }

    @Override
    protected SoundEvent getHurtSound(DamageSource var0) {
        return SoundEvents.TROPICAL_FISH_HURT;
    }

    @Override
    protected SoundEvent getFlopSound() {
        return SoundEvents.TROPICAL_FISH_FLOP;
    }

    @Override
    public @Nullable SpawnGroupData finalizeSpawn(ServerLevelAccessor var0, DifficultyInstance var1, EntitySpawnReason var2, @Nullable SpawnGroupData var3) {
        Variant var4;
        var3 = super.finalizeSpawn(var0, var1, var2, var3);
        RandomSource var5 = var0.getRandom();
        if (var3 instanceof TropicalFishGroupData) {
            TropicalFishGroupData var6 = (TropicalFishGroupData)var3;
            var4 = var6.variant;
        } else if ((double)var5.nextFloat() < 0.9) {
            var4 = Util.getRandom(COMMON_VARIANTS, var5);
            var3 = new TropicalFishGroupData(this, var4);
        } else {
            this.isSchool = false;
            Pattern[] var7 = Pattern.values();
            DyeColor[] var8 = DyeColor.values();
            Pattern var9 = Util.getRandom(var7, var5);
            DyeColor var10 = Util.getRandom(var8, var5);
            DyeColor var11 = Util.getRandom(var8, var5);
            var4 = new Variant(var9, var10, var11);
        }
        this.setPackedVariant(var4.getPackedId());
        return var3;
    }

    public static boolean checkTropicalFishSpawnRules(EntityType<TropicalFish> var0, LevelAccessor var1, EntitySpawnReason var2, BlockPos var3, RandomSource var4) {
        return var1.getFluidState(var3.below()).is(FluidTags.WATER) && var1.getBlockState(var3.above()).is(Blocks.WATER) && (var1.getBiome(var3).is(BiomeTags.ALLOWS_TROPICAL_FISH_SPAWNS_AT_ANY_HEIGHT) || WaterAnimal.checkSurfaceWaterAnimalSpawnRules(var0, var1, var2, var3, var4));
    }

    public static enum Pattern implements StringRepresentable,
    TooltipProvider
    {
        KOB("kob", Base.SMALL, 0),
        SUNSTREAK("sunstreak", Base.SMALL, 1),
        SNOOPER("snooper", Base.SMALL, 2),
        DASHER("dasher", Base.SMALL, 3),
        BRINELY("brinely", Base.SMALL, 4),
        SPOTTY("spotty", Base.SMALL, 5),
        FLOPPER("flopper", Base.LARGE, 0),
        STRIPEY("stripey", Base.LARGE, 1),
        GLITTER("glitter", Base.LARGE, 2),
        BLOCKFISH("blockfish", Base.LARGE, 3),
        BETTY("betty", Base.LARGE, 4),
        CLAYFISH("clayfish", Base.LARGE, 5);

        public static final Codec<Pattern> CODEC;
        private static final IntFunction<Pattern> BY_ID;
        public static final StreamCodec<ByteBuf, Pattern> STREAM_CODEC;
        private final String name;
        private final Component displayName;
        private final Base base;
        private final int packedId;

        private Pattern(String var2, Base var3, int var4) {
            this.name = var2;
            this.base = var3;
            this.packedId = var3.id | var4 << 8;
            this.displayName = Component.translatable("entity.minecraft.tropical_fish.type." + this.name);
        }

        public static Pattern byId(int var0) {
            return BY_ID.apply(var0);
        }

        public Base base() {
            return this.base;
        }

        public int getPackedId() {
            return this.packedId;
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        public Component displayName() {
            return this.displayName;
        }

        @Override
        public void addToTooltip(Item.TooltipContext var0, Consumer<Component> var1, TooltipFlag var2, DataComponentGetter var3) {
            DyeColor var4 = var3.getOrDefault(DataComponents.TROPICAL_FISH_BASE_COLOR, DEFAULT_VARIANT.baseColor());
            DyeColor var5 = var3.getOrDefault(DataComponents.TROPICAL_FISH_PATTERN_COLOR, DEFAULT_VARIANT.patternColor());
            ChatFormatting[] var6 = new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY};
            int var7 = COMMON_VARIANTS.indexOf(new Variant(this, var4, var5));
            if (var7 != -1) {
                var1.accept(Component.translatable(TropicalFish.getPredefinedName(var7)).withStyle(var6));
                return;
            }
            var1.accept(this.displayName.plainCopy().withStyle(var6));
            MutableComponent var8 = Component.translatable("color.minecraft." + var4.getName());
            if (var4 != var5) {
                var8.append(", ").append(Component.translatable("color.minecraft." + var5.getName()));
            }
            var8.withStyle(var6);
            var1.accept(var8);
        }

        static {
            CODEC = StringRepresentable.fromEnum(Pattern::values);
            BY_ID = ByIdMap.sparse(Pattern::getPackedId, Pattern.values(), KOB);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Pattern::getPackedId);
        }
    }

    public record Variant(Pattern pattern, DyeColor baseColor, DyeColor patternColor) {
        public static final Codec<Variant> CODEC = Codec.INT.xmap(Variant::new, Variant::getPackedId);

        public Variant(int var0) {
            this(TropicalFish.getPattern(var0), TropicalFish.getBaseColor(var0), TropicalFish.getPatternColor(var0));
        }

        public int getPackedId() {
            return TropicalFish.packVariant(this.pattern, this.baseColor, this.patternColor);
        }
    }

    static class TropicalFishGroupData
    extends AbstractSchoolingFish.SchoolSpawnGroupData {
        final Variant variant;

        TropicalFishGroupData(TropicalFish var0, Variant var1) {
            super(var0);
            this.variant = var1;
        }
    }

    public static enum Base {
        SMALL(0),
        LARGE(1);

        final int id;

        private Base(int var2) {
            this.id = var2;
        }
    }
}

