/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.nautilus;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PlayerRideableJumping;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.nautilus.NautilusAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.inventory.AbstractMountInventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.bukkit.inventory.InventoryHolder;
import org.jspecify.annotations.Nullable;

public abstract class AbstractNautilus
extends TamableAnimal
implements HasCustomInventoryScreen,
PlayerRideableJumping {
    public static final int INVENTORY_SLOT_OFFSET = 500;
    public static final int INVENTORY_ROWS = 3;
    public static final int SMALL_RESTRICTION_RADIUS = 16;
    public static final int LARGE_RESTRICTION_RADIUS = 32;
    public static final int RESTRICTION_RADIUS_BUFFER = 8;
    private static final int EFFECT_DURATION = 60;
    private static final int EFFECT_REFRESH_RATE = 40;
    private static final double NAUTILUS_WATER_RESISTANCE = 0.9;
    private static final float IN_WATER_SPEED_MODIFIER = 0.011f;
    private static final float RIDDEN_SPEED_MODIFIER_IN_WATER = 0.0325f;
    private static final float RIDDEN_SPEED_MODIFIER_ON_LAND = 0.02f;
    private static final EntityDataAccessor<Boolean> DASH = SynchedEntityData.defineId(AbstractNautilus.class, EntityDataSerializers.BOOLEAN);
    private static final int DASH_COOLDOWN_TICKS = 40;
    private static final int DASH_MINIMUM_DURATION_TICKS = 5;
    private static final float DASH_MOMENTUM_IN_WATER = 1.2f;
    private static final float DASH_MOMENTUM_ON_LAND = 0.5f;
    private int dashCooldown = 0;
    protected float playerJumpPendingScale;
    public SimpleContainer inventory;
    private static final double BUBBLE_SPREAD_FACTOR = 0.8;
    private static final double BUBBLE_DIRECTION_SCALE = 1.1;
    private static final double BUBBLE_Y_OFFSET = 0.25;
    private static final double BUBBLE_PROBABILITY_MULTIPLIER = 2.0;
    private static final float BUBBLE_PROBABILITY_MIN = 0.15f;
    private static final float BUBBLE_PROBABILITY_MAX = 1.0f;

    protected AbstractNautilus(EntityType<? extends AbstractNautilus> entitytypes, Level world) {
        super((EntityType<? extends TamableAnimal>)entitytypes, world);
        this.moveControl = new SmoothSwimmingMoveControl(this, 85, 10, 0.011f, 0.0f, true);
        this.lookControl = new SmoothSwimmingLookControl(this, 10);
        this.setPathfindingMalus(PathType.WATER, 0.0f);
        this.createInventory();
    }

    @Override
    public boolean isFood(ItemStack itemstack) {
        return !this.isTame() && !this.isBaby() ? itemstack.is(ItemTags.NAUTILUS_TAMING_ITEMS) : itemstack.is(ItemTags.NAUTILUS_FOOD);
    }

    @Override
    protected void usePlayerItem(Player entityhuman, InteractionHand enumhand, ItemStack itemstack) {
        if (itemstack.is(ItemTags.NAUTILUS_BUCKET_FOOD)) {
            entityhuman.setItemInHand(enumhand, ItemUtils.createFilledResult(itemstack, entityhuman, new ItemStack(Items.WATER_BUCKET)));
        } else {
            super.usePlayerItem(entityhuman, enumhand, itemstack);
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.createAnimalAttributes().add(Attributes.MAX_HEALTH, 15.0).add(Attributes.MOVEMENT_SPEED, 1.0).add(Attributes.ATTACK_DAMAGE, 3.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.3f);
    }

    @Override
    public boolean isPushedByFluid() {
        return false;
    }

    @Override
    protected PathNavigation createNavigation(Level world) {
        return new WaterBoundPathNavigation(this, world);
    }

    @Override
    public float getWalkTargetValue(BlockPos blockposition, LevelReader iworldreader) {
        return 0.0f;
    }

    public static boolean checkNautilusSpawnRules(EntityType<? extends AbstractNautilus> entitytypes, LevelAccessor generatoraccess, EntitySpawnReason entityspawnreason, BlockPos blockposition, RandomSource randomsource) {
        int i = generatoraccess.getSeaLevel();
        int j = i - 25;
        return blockposition.getY() >= j && blockposition.getY() <= i - 5 && generatoraccess.getFluidState(blockposition.below()).is(FluidTags.WATER) && generatoraccess.getBlockState(blockposition.above()).is(Blocks.WATER);
    }

    @Override
    public boolean checkSpawnObstruction(LevelReader iworldreader) {
        return iworldreader.isUnobstructed(this);
    }

    @Override
    public boolean canUseSlot(EquipmentSlot enumitemslot) {
        return enumitemslot != EquipmentSlot.SADDLE && enumitemslot != EquipmentSlot.BODY ? super.canUseSlot(enumitemslot) : this.isAlive() && !this.isBaby() && this.isTame();
    }

    @Override
    protected boolean canDispenserEquipIntoSlot(EquipmentSlot enumitemslot) {
        return enumitemslot == EquipmentSlot.BODY || enumitemslot == EquipmentSlot.SADDLE || super.canDispenserEquipIntoSlot(enumitemslot);
    }

    @Override
    protected boolean canAddPassenger(Entity entity) {
        return !this.isVehicle();
    }

    @Override
    public @Nullable LivingEntity getControllingPassenger() {
        Entity entity = this.getFirstPassenger();
        if (this.isSaddled() && entity instanceof Player) {
            Player entityhuman = (Player)entity;
            return entityhuman;
        }
        return super.getControllingPassenger();
    }

    @Override
    protected Vec3 getRiddenInput(Player entityhuman, Vec3 vec3d) {
        float f = entityhuman.xxa;
        float f1 = 0.0f;
        float f2 = 0.0f;
        if (entityhuman.zza != 0.0f) {
            float f3 = Mth.cos(entityhuman.getXRot() * ((float)Math.PI / 180));
            float f4 = -Mth.sin(entityhuman.getXRot() * ((float)Math.PI / 180));
            if (entityhuman.zza < 0.0f) {
                f3 *= -0.5f;
                f4 *= -0.5f;
            }
            f2 = f4;
            f1 = f3;
        }
        return new Vec3(f, f2, f1);
    }

    protected Vec2 getRiddenRotation(LivingEntity entityliving) {
        return new Vec2(entityliving.getXRot() * 0.5f, entityliving.getYRot());
    }

    @Override
    protected void tickRidden(Player entityhuman, Vec3 vec3d) {
        super.tickRidden(entityhuman, vec3d);
        Vec2 vec2f = this.getRiddenRotation(entityhuman);
        float f = this.getYRot();
        float f1 = Mth.wrapDegrees(vec2f.y - f);
        float f2 = 0.5f;
        this.setRot(f += f1 * 0.5f, vec2f.x);
        this.yBodyRot = this.yHeadRot = f;
        this.yRotO = this.yHeadRot;
        if (this.isLocalInstanceAuthoritative()) {
            if (this.playerJumpPendingScale > 0.0f && !this.isJumping()) {
                this.executeRidersJump(this.playerJumpPendingScale, entityhuman);
            }
            this.playerJumpPendingScale = 0.0f;
        }
    }

    @Override
    protected void travelInWater(Vec3 vec3d, double d0, boolean flag, double d1) {
        float f = this.getSpeed();
        this.moveRelative(f, vec3d);
        this.move(MoverType.SELF, this.getDeltaMovement());
        this.setDeltaMovement(this.getDeltaMovement().scale(0.9));
    }

    @Override
    protected float getRiddenSpeed(Player entityhuman) {
        return this.isInWater() ? 0.0325f * (float)this.getAttributeValue(Attributes.MOVEMENT_SPEED) : 0.02f * (float)this.getAttributeValue(Attributes.MOVEMENT_SPEED);
    }

    protected void doPlayerRide(Player entityhuman) {
        if (!this.level().isClientSide()) {
            entityhuman.startRiding(this);
            if (!this.isVehicle()) {
                this.clearHome();
            }
        }
    }

    private int getNautilusRestrictionRadius() {
        return !this.isBaby() && this.getItemBySlot(EquipmentSlot.SADDLE).isEmpty() ? 32 : 16;
    }

    protected void checkRestriction() {
        if (!this.isLeashed() && !this.isVehicle() && this.isTame()) {
            int i = this.getNautilusRestrictionRadius();
            if (!this.hasHome() || !this.getHomePosition().closerThan(this.blockPosition(), i + 8) || i != this.getHomeRadius()) {
                this.setHomeTo(this.blockPosition(), i);
            }
        }
    }

    @Override
    protected void customServerAiStep(ServerLevel worldserver) {
        this.checkRestriction();
        super.customServerAiStep(worldserver);
    }

    private void applyEffects(Level world) {
        Entity entity = this.getFirstPassenger();
        if (entity instanceof Player) {
            boolean flag1;
            Player entityhuman = (Player)entity;
            boolean flag = entityhuman.hasEffect(MobEffects.BREATH_OF_THE_NAUTILUS);
            boolean bl = flag1 = world.getGameTime() % 40L == 0L;
            if (!flag || flag1) {
                entityhuman.addEffect(new MobEffectInstance(MobEffects.BREATH_OF_THE_NAUTILUS, 60, 0, true, true, true));
            }
        }
    }

    private void spawnBubbles() {
        double d0 = this.getDeltaMovement().length();
        double d1 = Mth.clamp(d0 * 2.0, (double)0.15f, 1.0);
        if ((double)this.random.nextFloat() < d1) {
            float f = this.getYRot();
            float f1 = Mth.clamp(this.getXRot(), -10.0f, 10.0f);
            Vec3 vec3d = this.calculateViewVector(f1, f);
            double d2 = this.random.nextDouble() * 0.8 * (1.0 + d0);
            double d3 = ((double)this.random.nextFloat() - 0.5) * d2;
            double d4 = ((double)this.random.nextFloat() - 0.5) * d2;
            double d5 = ((double)this.random.nextFloat() - 0.5) * d2;
            this.level().addParticle(ParticleTypes.BUBBLE, this.getX() - vec3d.x * 1.1, this.getY() - vec3d.y + 0.25, this.getZ() - vec3d.z * 1.1, d3, d4, d5);
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.level().isClientSide()) {
            this.applyEffects(this.level());
        }
        if (this.isDashing() && this.dashCooldown < 35) {
            this.setDashing(false);
        }
        if (this.dashCooldown > 0) {
            --this.dashCooldown;
            if (this.dashCooldown == 0) {
                this.makeSound(this.getDashReadySound());
            }
        }
        if (this.isInWater()) {
            this.spawnBubbles();
        }
    }

    @Override
    public boolean canJump() {
        return this.isSaddled();
    }

    @Override
    public void onPlayerJump(int i) {
        if (this.isSaddled() && this.dashCooldown <= 0) {
            this.playerJumpPendingScale = this.getPlayerJumpPendingScale(i);
        }
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder datawatcher_a) {
        super.defineSynchedData(datawatcher_a);
        datawatcher_a.define(DASH, false);
    }

    public boolean isDashing() {
        return this.entityData.get(DASH);
    }

    public void setDashing(boolean flag) {
        this.entityData.set(DASH, flag);
    }

    protected void executeRidersJump(float f, Player entityhuman) {
        this.addDeltaMovement(entityhuman.getLookAngle().scale((double)((this.isInWater() ? 1.2f : 0.5f) * f) * this.getAttributeValue(Attributes.MOVEMENT_SPEED) * (double)this.getBlockSpeedFactor()));
        this.dashCooldown = 40;
        this.setDashing(true);
        this.needsSync = true;
    }

    @Override
    public void handleStartJump(int i) {
        this.makeSound(this.getDashSound());
        this.gameEvent(GameEvent.ENTITY_ACTION);
        this.setDashing(true);
    }

    @Override
    public int getJumpCooldown() {
        return this.dashCooldown;
    }

    @Override
    public void onSyncedDataUpdated(EntityDataAccessor<?> datawatcherobject) {
        if (!this.firstTick && DASH.equals(datawatcherobject)) {
            this.dashCooldown = this.dashCooldown == 0 ? 40 : this.dashCooldown;
        }
        super.onSyncedDataUpdated(datawatcherobject);
    }

    @Override
    public void handleStopJump() {
    }

    @Override
    protected void playStepSound(BlockPos blockposition, BlockState iblockdata) {
    }

    protected @Nullable SoundEvent getDashSound() {
        return null;
    }

    protected @Nullable SoundEvent getDashReadySound() {
        return null;
    }

    @Override
    public InteractionResult interact(Player entityhuman, InteractionHand enumhand) {
        this.setPersistenceRequired();
        return super.interact(entityhuman, enumhand);
    }

    @Override
    public InteractionResult mobInteract(Player entityhuman, InteractionHand enumhand) {
        ItemStack itemstack = entityhuman.getItemInHand(enumhand);
        if (this.isBaby()) {
            return super.mobInteract(entityhuman, enumhand);
        }
        if (this.isTame() && entityhuman.isSecondaryUseActive()) {
            this.openCustomInventoryScreen(entityhuman);
            return InteractionResult.SUCCESS;
        }
        if (!itemstack.isEmpty()) {
            if (!this.level().isClientSide() && !this.isTame() && this.isFood(itemstack)) {
                this.usePlayerItem(entityhuman, enumhand, itemstack);
                this.tryToTame(entityhuman);
                return InteractionResult.SUCCESS_SERVER;
            }
            if (this.isFood(itemstack) && this.getHealth() < this.getMaxHealth()) {
                FoodProperties foodinfo = itemstack.get(DataComponents.FOOD);
                this.heal(foodinfo != null ? (float)(2 * foodinfo.nutrition()) : 1.0f);
                this.usePlayerItem(entityhuman, enumhand, itemstack);
                this.playEatingSound();
                return InteractionResult.SUCCESS;
            }
            InteractionResult enuminteractionresult = itemstack.interactLivingEntity(entityhuman, this, enumhand);
            if (enuminteractionresult.consumesAction()) {
                return enuminteractionresult;
            }
        }
        if (this.isTame() && !entityhuman.isSecondaryUseActive() && !this.isFood(itemstack)) {
            this.doPlayerRide(entityhuman);
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(entityhuman, enumhand);
    }

    private void tryToTame(Player entityhuman) {
        if (this.random.nextInt(3) == 0) {
            this.tame(entityhuman);
            this.navigation.stop();
            this.level().broadcastEntityEvent(this, (byte)7);
        } else {
            this.level().broadcastEntityEvent(this, (byte)6);
        }
        this.playEatingSound();
    }

    @Override
    public boolean removeWhenFarAway(double d0) {
        return true;
    }

    @Override
    public boolean hurtServer(ServerLevel worldserver, DamageSource damagesource, float f) {
        Entity entity;
        boolean flag = super.hurtServer(worldserver, damagesource, f);
        if (flag && (entity = damagesource.getEntity()) instanceof LivingEntity) {
            LivingEntity entityliving = (LivingEntity)entity;
            NautilusAi.setAngerTarget(worldserver, this, entityliving);
        }
        return flag;
    }

    @Override
    public boolean canBeAffected(MobEffectInstance mobeffect) {
        return mobeffect.getEffect() == MobEffects.POISON ? false : super.canBeAffected(mobeffect);
    }

    @Override
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor worldaccess, DifficultyInstance difficultydamagescaler, EntitySpawnReason entityspawnreason, @Nullable SpawnGroupData groupdataentity) {
        RandomSource randomsource = worldaccess.getRandom();
        NautilusAi.initMemories(this, randomsource);
        return super.finalizeSpawn(worldaccess, difficultydamagescaler, entityspawnreason, groupdataentity);
    }

    @Override
    protected Holder<SoundEvent> getEquipSound(EquipmentSlot enumitemslot, ItemStack itemstack, Equippable equippable) {
        return enumitemslot == EquipmentSlot.SADDLE && this.isUnderWater() ? SoundEvents.NAUTILUS_SADDLE_UNDERWATER_EQUIP : (enumitemslot == EquipmentSlot.SADDLE ? SoundEvents.NAUTILUS_SADDLE_EQUIP : super.getEquipSound(enumitemslot, itemstack, equippable));
    }

    public final int getInventorySize() {
        return AbstractMountInventoryMenu.getInventorySize(this.getInventoryColumns());
    }

    protected void createInventory() {
        SimpleContainer inventorysubcontainer = this.inventory;
        this.inventory = new SimpleContainer(this.getInventorySize(), (InventoryHolder)((org.bukkit.entity.AbstractNautilus)this.getBukkitEntity()));
        if (inventorysubcontainer != null) {
            int i = Math.min(inventorysubcontainer.getContainerSize(), this.inventory.getContainerSize());
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = inventorysubcontainer.getItem(j);
                if (itemstack.isEmpty()) continue;
                this.inventory.setItem(j, itemstack.copy());
            }
        }
    }

    @Override
    public void openCustomInventoryScreen(Player entityhuman) {
        if (!this.level().isClientSide() && (!this.isVehicle() || this.hasPassenger(entityhuman)) && this.isTame()) {
            entityhuman.openNautilusInventory(this, this.inventory);
        }
    }

    @Override
    public @Nullable SlotAccess getSlot(int i) {
        int j = i - 500;
        return j >= 0 && j < this.inventory.getContainerSize() ? this.inventory.getSlot(j) : super.getSlot(i);
    }

    public boolean hasInventoryChanged(Container iinventory) {
        return this.inventory != iinventory;
    }

    public int getInventoryColumns() {
        return 0;
    }

    protected boolean isMobControlled() {
        return this.getFirstPassenger() instanceof Mob;
    }

    protected boolean isAggravated() {
        return this.getBrain().hasMemoryValue(MemoryModuleType.ANGRY_AT) || this.getBrain().hasMemoryValue(MemoryModuleType.ATTACK_TARGET);
    }
}

