/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.nautilus;

import com.mojang.serialization.Dynamic;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.nautilus.AbstractNautilus;
import net.minecraft.world.entity.animal.nautilus.ZombieNautilusAi;
import net.minecraft.world.entity.animal.nautilus.ZombieNautilusVariant;
import net.minecraft.world.entity.animal.nautilus.ZombieNautilusVariants;
import net.minecraft.world.entity.variant.SpawnContext;
import net.minecraft.world.entity.variant.VariantUtils;
import net.minecraft.world.item.EitherHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jspecify.annotations.Nullable;

public class ZombieNautilus
extends AbstractNautilus {
    private static final EntityDataAccessor<Holder<ZombieNautilusVariant>> DATA_VARIANT_ID = SynchedEntityData.defineId(ZombieNautilus.class, EntityDataSerializers.ZOMBIE_NAUTILUS_VARIANT);

    public ZombieNautilus(EntityType<? extends ZombieNautilus> var0, Level var1) {
        super((EntityType<? extends AbstractNautilus>)var0, var1);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return AbstractNautilus.createAttributes().add(Attributes.MOVEMENT_SPEED, 1.1f);
    }

    @Override
    public @Nullable ZombieNautilus getBreedOffspring(ServerLevel var0, AgeableMob var1) {
        return null;
    }

    @Override
    protected EquipmentSlot sunProtectionSlot() {
        return EquipmentSlot.BODY;
    }

    protected Brain.Provider<ZombieNautilus> brainProvider() {
        return ZombieNautilusAi.brainProvider();
    }

    @Override
    protected Brain<?> makeBrain(Dynamic<?> var0) {
        return ZombieNautilusAi.makeBrain(this.brainProvider().makeBrain(var0));
    }

    public Brain<ZombieNautilus> getBrain() {
        return super.getBrain();
    }

    @Override
    protected void customServerAiStep(ServerLevel var0) {
        ProfilerFiller var1 = Profiler.get();
        var1.push("zombieNautilusBrain");
        this.getBrain().tick(var0, this);
        var1.pop();
        var1.push("zombieNautilusActivityUpdate");
        ZombieNautilusAi.updateActivity(this);
        var1.pop();
        super.customServerAiStep(var0);
    }

    @Override
    protected SoundEvent getAmbientSound() {
        return this.isUnderWater() ? SoundEvents.ZOMBIE_NAUTILUS_AMBIENT : SoundEvents.ZOMBIE_NAUTILUS_AMBIENT_ON_LAND;
    }

    @Override
    protected SoundEvent getHurtSound(DamageSource var0) {
        return this.isUnderWater() ? SoundEvents.ZOMBIE_NAUTILUS_HURT : SoundEvents.ZOMBIE_NAUTILUS_HURT_ON_LAND;
    }

    @Override
    protected SoundEvent getDeathSound() {
        return this.isUnderWater() ? SoundEvents.ZOMBIE_NAUTILUS_DEATH : SoundEvents.ZOMBIE_NAUTILUS_DEATH_ON_LAND;
    }

    @Override
    protected SoundEvent getDashSound() {
        return this.isUnderWater() ? SoundEvents.ZOMBIE_NAUTILUS_DASH : SoundEvents.ZOMBIE_NAUTILUS_DASH_ON_LAND;
    }

    @Override
    protected SoundEvent getDashReadySound() {
        return this.isUnderWater() ? SoundEvents.ZOMBIE_NAUTILUS_DASH_READY : SoundEvents.ZOMBIE_NAUTILUS_DASH_READY_ON_LAND;
    }

    @Override
    protected void playEatingSound() {
        this.makeSound(SoundEvents.ZOMBIE_NAUTILUS_EAT);
    }

    @Override
    protected SoundEvent getSwimSound() {
        return SoundEvents.ZOMBIE_NAUTILUS_SWIM;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder var0) {
        super.defineSynchedData(var0);
        var0.define(DATA_VARIANT_ID, VariantUtils.getDefaultOrAny(this.registryAccess(), ZombieNautilusVariants.TEMPERATE));
    }

    @Override
    protected void readAdditionalSaveData(ValueInput var0) {
        super.readAdditionalSaveData(var0);
        VariantUtils.readVariant(var0, Registries.ZOMBIE_NAUTILUS_VARIANT).ifPresent(this::setVariant);
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput var0) {
        super.addAdditionalSaveData(var0);
        VariantUtils.writeVariant(var0, this.getVariant());
    }

    public void setVariant(Holder<ZombieNautilusVariant> var0) {
        this.entityData.set(DATA_VARIANT_ID, var0);
    }

    public Holder<ZombieNautilusVariant> getVariant() {
        return this.entityData.get(DATA_VARIANT_ID);
    }

    @Override
    public <T> @Nullable T get(DataComponentType<? extends T> var0) {
        if (var0 == DataComponents.ZOMBIE_NAUTILUS_VARIANT) {
            return ZombieNautilus.castComponentValue(var0, new EitherHolder<ZombieNautilusVariant>(this.getVariant()));
        }
        return super.get(var0);
    }

    @Override
    protected void applyImplicitComponents(DataComponentGetter var0) {
        this.applyImplicitComponentIfPresent(var0, DataComponents.ZOMBIE_NAUTILUS_VARIANT);
        super.applyImplicitComponents(var0);
    }

    @Override
    protected <T> boolean applyImplicitComponent(DataComponentType<T> var0, T var1) {
        if (var0 == DataComponents.ZOMBIE_NAUTILUS_VARIANT) {
            Optional<Holder<ZombieNautilusVariant>> var2 = ZombieNautilus.castComponentValue(DataComponents.ZOMBIE_NAUTILUS_VARIANT, var1).unwrap(this.registryAccess());
            if (var2.isPresent()) {
                this.setVariant(var2.get());
                return true;
            }
            return false;
        }
        return super.applyImplicitComponent(var0, var1);
    }

    @Override
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor var0, DifficultyInstance var1, EntitySpawnReason var2, @Nullable SpawnGroupData var3) {
        VariantUtils.selectVariantToSpawn(SpawnContext.create(var0, this.blockPosition()), Registries.ZOMBIE_NAUTILUS_VARIANT).ifPresent(this::setVariant);
        return super.finalizeSpawn(var0, var1, var2, var3);
    }

    @Override
    public boolean canBeLeashed() {
        return !this.isAggravated() && !this.isMobControlled();
    }

    @Override
    public boolean isBaby() {
        return false;
    }

    @Override
    public /* synthetic */ @Nullable AgeableMob getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        return this.getBreedOffspring(serverLevel, ageableMob);
    }
}

