/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.wolf;

import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.animal.wolf.WolfSoundVariant;

public class WolfSoundVariants {
    public static final ResourceKey<WolfSoundVariant> CLASSIC = WolfSoundVariants.createKey(SoundSet.CLASSIC);
    public static final ResourceKey<WolfSoundVariant> PUGLIN = WolfSoundVariants.createKey(SoundSet.PUGLIN);
    public static final ResourceKey<WolfSoundVariant> SAD = WolfSoundVariants.createKey(SoundSet.SAD);
    public static final ResourceKey<WolfSoundVariant> ANGRY = WolfSoundVariants.createKey(SoundSet.ANGRY);
    public static final ResourceKey<WolfSoundVariant> GRUMPY = WolfSoundVariants.createKey(SoundSet.GRUMPY);
    public static final ResourceKey<WolfSoundVariant> BIG = WolfSoundVariants.createKey(SoundSet.BIG);
    public static final ResourceKey<WolfSoundVariant> CUTE = WolfSoundVariants.createKey(SoundSet.CUTE);

    private static ResourceKey<WolfSoundVariant> createKey(SoundSet var0) {
        return ResourceKey.create(Registries.WOLF_SOUND_VARIANT, Identifier.withDefaultNamespace(var0.getIdentifier()));
    }

    public static void bootstrap(BootstrapContext<WolfSoundVariant> var0) {
        WolfSoundVariants.register(var0, CLASSIC, SoundSet.CLASSIC);
        WolfSoundVariants.register(var0, PUGLIN, SoundSet.PUGLIN);
        WolfSoundVariants.register(var0, SAD, SoundSet.SAD);
        WolfSoundVariants.register(var0, ANGRY, SoundSet.ANGRY);
        WolfSoundVariants.register(var0, GRUMPY, SoundSet.GRUMPY);
        WolfSoundVariants.register(var0, BIG, SoundSet.BIG);
        WolfSoundVariants.register(var0, CUTE, SoundSet.CUTE);
    }

    private static void register(BootstrapContext<WolfSoundVariant> var0, ResourceKey<WolfSoundVariant> var1, SoundSet var2) {
        var0.register(var1, SoundEvents.WOLF_SOUNDS.get((Object)var2));
    }

    public static Holder<WolfSoundVariant> pickRandomSoundVariant(RegistryAccess var0, RandomSource var1) {
        return var0.lookupOrThrow(Registries.WOLF_SOUND_VARIANT).getRandom(var1).orElseThrow();
    }

    public static enum SoundSet {
        CLASSIC("classic", ""),
        PUGLIN("puglin", "_puglin"),
        SAD("sad", "_sad"),
        ANGRY("angry", "_angry"),
        GRUMPY("grumpy", "_grumpy"),
        BIG("big", "_big"),
        CUTE("cute", "_cute");

        private final String identifier;
        private final String soundEventSuffix;

        private SoundSet(String var2, String var3) {
            this.identifier = var2;
            this.soundEventSuffix = var3;
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public String getSoundEventSuffix() {
            return this.soundEventSuffix;
        }
    }
}

