/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.boss.enderdragon;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.dimension.end.EndDragonFight;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.ExplosionPrimeEvent;
import org.jspecify.annotations.Nullable;

public class EndCrystal
extends Entity {
    private static final EntityDataAccessor<Optional<BlockPos>> DATA_BEAM_TARGET = SynchedEntityData.defineId(EndCrystal.class, EntityDataSerializers.OPTIONAL_BLOCK_POS);
    private static final EntityDataAccessor<Boolean> DATA_SHOW_BOTTOM = SynchedEntityData.defineId(EndCrystal.class, EntityDataSerializers.BOOLEAN);
    private static final boolean DEFAULT_SHOW_BOTTOM = true;
    public int time;

    public EndCrystal(EntityType<? extends EndCrystal> entitytypes, Level world) {
        super(entitytypes, world);
        this.blocksBuilding = true;
        this.time = this.random.nextInt(100000);
    }

    public EndCrystal(Level world, double d0, double d1, double d2) {
        this((EntityType<? extends EndCrystal>)EntityType.END_CRYSTAL, world);
        this.setPos(d0, d1, d2);
    }

    @Override
    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.NONE;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder datawatcher_a) {
        datawatcher_a.define(DATA_BEAM_TARGET, Optional.empty());
        datawatcher_a.define(DATA_SHOW_BOTTOM, true);
    }

    @Override
    public void tick() {
        ++this.time;
        this.applyEffectsFromBlocks();
        this.handlePortal();
        if (this.level() instanceof ServerLevel) {
            BlockPos blockposition = this.blockPosition();
            if (((ServerLevel)this.level()).getDragonFight() != null && this.level().getBlockState(blockposition).isAir() && !CraftEventFactory.callBlockIgniteEvent(this.level(), blockposition, this).isCancelled()) {
                this.level().setBlockAndUpdate(blockposition, BaseFireBlock.getState(this.level(), blockposition));
            }
        }
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput valueoutput) {
        valueoutput.storeNullable("beam_target", BlockPos.CODEC, this.getBeamTarget());
        valueoutput.putBoolean("ShowBottom", this.showsBottom());
    }

    @Override
    protected void readAdditionalSaveData(ValueInput valueinput) {
        this.setBeamTarget(valueinput.read("beam_target", BlockPos.CODEC).orElse(null));
        this.setShowBottom(valueinput.getBooleanOr("ShowBottom", true));
    }

    @Override
    public boolean isPickable() {
        return true;
    }

    @Override
    public final boolean hurtClient(DamageSource damagesource) {
        return this.isInvulnerableToBase(damagesource) ? false : !(damagesource.getEntity() instanceof EnderDragon);
    }

    @Override
    public final boolean hurtServer(ServerLevel worldserver, DamageSource damagesource, float f) {
        if (this.isInvulnerableToBase(damagesource)) {
            return false;
        }
        if (damagesource.getEntity() instanceof EnderDragon) {
            return false;
        }
        if (!this.isRemoved()) {
            if (CraftEventFactory.handleNonLivingEntityDamageEvent(this, damagesource, f, false)) {
                return false;
            }
            if (!damagesource.is(DamageTypeTags.IS_EXPLOSION)) {
                DamageSource damagesource1 = damagesource.getEntity() != null ? this.damageSources().explosion(this, damagesource.getEntity()) : null;
                ExplosionPrimeEvent event = CraftEventFactory.callExplosionPrimeEvent(this, 6.0f, false);
                if (event.isCancelled()) {
                    return false;
                }
                this.remove(Entity.RemovalReason.KILLED, EntityRemoveEvent.Cause.EXPLODE);
                worldserver.explode(this, damagesource1, null, this.getX(), this.getY(), this.getZ(), event.getRadius(), event.getFire(), Level.ExplosionInteraction.BLOCK);
            } else {
                this.remove(Entity.RemovalReason.KILLED, EntityRemoveEvent.Cause.DEATH);
            }
            this.onDestroyedBy(worldserver, damagesource);
        }
        return true;
    }

    @Override
    public void kill(ServerLevel worldserver) {
        this.onDestroyedBy(worldserver, this.damageSources().generic());
        super.kill(worldserver);
    }

    private void onDestroyedBy(ServerLevel worldserver, DamageSource damagesource) {
        EndDragonFight enderdragonbattle = worldserver.getDragonFight();
        if (enderdragonbattle != null) {
            enderdragonbattle.onCrystalDestroyed(this, damagesource);
        }
    }

    public void setBeamTarget(@Nullable BlockPos blockposition) {
        this.getEntityData().set(DATA_BEAM_TARGET, Optional.ofNullable(blockposition));
    }

    public @Nullable BlockPos getBeamTarget() {
        return this.getEntityData().get(DATA_BEAM_TARGET).orElse(null);
    }

    public void setShowBottom(boolean flag) {
        this.getEntityData().set(DATA_SHOW_BOTTOM, flag);
    }

    public boolean showsBottom() {
        return this.getEntityData().get(DATA_SHOW_BOTTOM);
    }

    @Override
    public boolean shouldRenderAtSqrDistance(double d0) {
        return super.shouldRenderAtSqrDistance(d0) || this.getBeamTarget() != null;
    }

    @Override
    public ItemStack getPickResult() {
        return new ItemStack(Items.END_CRYSTAL);
    }
}

