/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.boss.enderdragon.phases;

import com.mojang.logging.LogUtils;
import java.util.Objects;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonPhaseInstance;
import net.minecraft.world.entity.boss.enderdragon.phases.EnderDragonPhase;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftEnderDragon;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EnderDragonChangePhaseEvent;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class EnderDragonPhaseManager {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final EnderDragon dragon;
    private final @Nullable DragonPhaseInstance[] phases = new DragonPhaseInstance[EnderDragonPhase.getCount()];
    private @Nullable DragonPhaseInstance currentPhase;

    public EnderDragonPhaseManager(EnderDragon entityenderdragon) {
        this.dragon = entityenderdragon;
        this.setPhase(EnderDragonPhase.HOVERING);
    }

    public void setPhase(EnderDragonPhase<?> dragoncontrollerphase) {
        if (this.currentPhase == null || dragoncontrollerphase != this.currentPhase.getPhase()) {
            if (this.currentPhase != null) {
                this.currentPhase.end();
            }
            EnderDragonChangePhaseEvent event = new EnderDragonChangePhaseEvent((org.bukkit.entity.EnderDragon)((CraftEnderDragon)this.dragon.getBukkitEntity()), this.currentPhase == null ? null : CraftEnderDragon.getBukkitPhase(this.currentPhase.getPhase()), CraftEnderDragon.getBukkitPhase(dragoncontrollerphase));
            this.dragon.level().getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            dragoncontrollerphase = CraftEnderDragon.getMinecraftPhase(event.getNewPhase());
            this.currentPhase = this.getPhase(dragoncontrollerphase);
            if (!this.dragon.level().isClientSide()) {
                this.dragon.getEntityData().set(EnderDragon.DATA_PHASE, dragoncontrollerphase.getId());
            }
            LOGGER.debug("Dragon is now in phase {} on the {}", (Object)dragoncontrollerphase, (Object)(this.dragon.level().isClientSide() ? "client" : "server"));
            this.currentPhase.begin();
        }
    }

    public DragonPhaseInstance getCurrentPhase() {
        return Objects.requireNonNull(this.currentPhase);
    }

    public <T extends DragonPhaseInstance> T getPhase(EnderDragonPhase<T> dragoncontrollerphase) {
        int i = dragoncontrollerphase.getId();
        DragonPhaseInstance idragoncontroller = this.phases[i];
        if (idragoncontroller == null) {
            this.phases[i] = idragoncontroller = dragoncontrollerphase.createInstance(this.dragon);
        }
        return (T)idragoncontroller;
    }
}

