/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.decoration;

import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.BlockAttachedEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DiodeBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.Validate;

public abstract class HangingEntity
extends BlockAttachedEntity {
    private static final EntityDataAccessor<Direction> DATA_DIRECTION = SynchedEntityData.defineId(HangingEntity.class, EntityDataSerializers.DIRECTION);
    private static final Direction DEFAULT_DIRECTION = Direction.SOUTH;

    protected HangingEntity(EntityType<? extends HangingEntity> var0, Level var1) {
        super((EntityType<? extends BlockAttachedEntity>)var0, var1);
    }

    protected HangingEntity(EntityType<? extends HangingEntity> var0, Level var1, BlockPos var2) {
        this(var0, var1);
        this.pos = var2;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder var0) {
        var0.define(DATA_DIRECTION, DEFAULT_DIRECTION);
    }

    @Override
    public void onSyncedDataUpdated(EntityDataAccessor<?> var0) {
        super.onSyncedDataUpdated(var0);
        if (var0.equals(DATA_DIRECTION)) {
            this.setDirection(this.getDirection());
        }
    }

    @Override
    public Direction getDirection() {
        return this.entityData.get(DATA_DIRECTION);
    }

    protected void setDirectionRaw(Direction var0) {
        this.entityData.set(DATA_DIRECTION, var0);
    }

    public void setDirection(Direction var0) {
        Objects.requireNonNull(var0);
        Validate.isTrue((boolean)var0.getAxis().isHorizontal());
        this.setDirectionRaw(var0);
        this.setYRot(var0.get2DDataValue() * 90);
        this.yRotO = this.getYRot();
        this.recalculateBoundingBox();
    }

    @Override
    protected void recalculateBoundingBox() {
        if (this.getDirection() == null) {
            return;
        }
        AABB var0 = this.calculateBoundingBox(this.pos, this.getDirection());
        Vec3 var1 = var0.getCenter();
        this.setPosRaw(var1.x, var1.y, var1.z);
        this.setBoundingBox(var0);
    }

    protected abstract AABB calculateBoundingBox(BlockPos var1, Direction var2);

    @Override
    public boolean survives() {
        if (this.hasLevelCollision(this.getPopBox())) {
            return false;
        }
        boolean var02 = BlockPos.betweenClosedStream(this.calculateSupportBox()).allMatch(var0 -> {
            BlockState var1 = this.level().getBlockState((BlockPos)var0);
            return var1.isSolid() || DiodeBlock.isDiode(var1);
        });
        return var02 && this.canCoexist(false);
    }

    protected AABB calculateSupportBox() {
        return this.getBoundingBox().move(this.getDirection().step().mul(-0.5f)).deflate(1.0E-7);
    }

    protected boolean canCoexist(boolean var0) {
        Predicate<HangingEntity> var12 = var1 -> {
            boolean var2 = !var0 && var1.getType() == this.getType();
            boolean var3 = var1.getDirection() == this.getDirection();
            return var1 != this && (var2 || var3);
        };
        return !this.level().hasEntities(EntityTypeTest.forClass(HangingEntity.class), this.getPopBox(), var12);
    }

    protected boolean hasLevelCollision(AABB var0) {
        Level var1 = this.level();
        return !var1.noBlockCollision(this, var0) || !var1.noBorderCollision(this, var0);
    }

    protected AABB getPopBox() {
        return this.getBoundingBox();
    }

    public abstract void playPlacementSound();

    @Override
    public ItemEntity spawnAtLocation(ServerLevel var0, ItemStack var1, float var2) {
        ItemEntity var3 = new ItemEntity(this.level(), this.getX() + (double)((float)this.getDirection().getStepX() * 0.15f), this.getY() + (double)var2, this.getZ() + (double)((float)this.getDirection().getStepZ() * 0.15f), var1);
        var3.setDefaultPickUpDelay();
        this.level().addFreshEntity(var3);
        return var3;
    }

    @Override
    public float rotate(Rotation var0) {
        Direction var1 = this.getDirection();
        if (var1.getAxis() != Direction.Axis.Y) {
            switch (var0) {
                case CLOCKWISE_180: {
                    var1 = var1.getOpposite();
                    break;
                }
                case COUNTERCLOCKWISE_90: {
                    var1 = var1.getCounterClockWise();
                    break;
                }
                case CLOCKWISE_90: {
                    var1 = var1.getClockWise();
                    break;
                }
            }
            this.setDirection(var1);
        }
        float var2 = Mth.wrapDegrees(this.getYRot());
        return switch (var0) {
            case Rotation.CLOCKWISE_180 -> var2 + 180.0f;
            case Rotation.COUNTERCLOCKWISE_90 -> var2 + 90.0f;
            case Rotation.CLOCKWISE_90 -> var2 + 270.0f;
            default -> var2;
        };
    }

    @Override
    public float mirror(Mirror var0) {
        return this.rotate(var0.getRotation(this.getDirection()));
    }
}

