/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import java.util.EnumSet;
import java.util.function.BooleanSupplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.hurtingprojectile.LargeFireball;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jspecify.annotations.Nullable;

public class Ghast
extends Mob
implements Enemy {
    private static final EntityDataAccessor<Boolean> DATA_IS_CHARGING = SynchedEntityData.defineId(Ghast.class, EntityDataSerializers.BOOLEAN);
    private static final byte DEFAULT_EXPLOSION_POWER = 1;
    private int explosionPower = 1;

    public Ghast(EntityType<? extends Ghast> entitytypes, Level world) {
        super((EntityType<? extends Mob>)entitytypes, world);
        this.xpReward = 5;
        this.moveControl = new GhastMoveControl(this, false, () -> false);
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(5, new RandomFloatAroundGoal(this));
        this.goalSelector.addGoal(7, new GhastLookGoal(this));
        this.goalSelector.addGoal(7, new GhastShootFireballGoal(this));
        this.targetSelector.addGoal(1, new NearestAttackableTargetGoal<Player>(this, Player.class, 10, true, false, (entityliving, worldserver) -> Math.abs(entityliving.getY() - this.getY()) <= 4.0));
    }

    public boolean isCharging() {
        return this.entityData.get(DATA_IS_CHARGING);
    }

    public void setCharging(boolean flag) {
        this.entityData.set(DATA_IS_CHARGING, flag);
    }

    public int getExplosionPower() {
        return this.explosionPower;
    }

    private static boolean isReflectedFireball(DamageSource damagesource) {
        return damagesource.getDirectEntity() instanceof LargeFireball && damagesource.getEntity() instanceof Player;
    }

    @Override
    public boolean isInvulnerableTo(ServerLevel worldserver, DamageSource damagesource) {
        return this.isInvulnerable() && !damagesource.is(DamageTypeTags.BYPASSES_INVULNERABILITY) || !Ghast.isReflectedFireball(damagesource) && super.isInvulnerableTo(worldserver, damagesource);
    }

    @Override
    protected void checkFallDamage(double d0, boolean flag, BlockState iblockdata, BlockPos blockposition) {
    }

    @Override
    public boolean onClimbable() {
        return false;
    }

    @Override
    public void travel(Vec3 vec3d) {
        this.travelFlying(vec3d, 0.02f);
    }

    @Override
    public boolean hurtServer(ServerLevel worldserver, DamageSource damagesource, float f) {
        if (Ghast.isReflectedFireball(damagesource)) {
            super.hurtServer(worldserver, damagesource, 1000.0f);
            return true;
        }
        return this.isInvulnerableTo(worldserver, damagesource) ? false : super.hurtServer(worldserver, damagesource, f);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder datawatcher_a) {
        super.defineSynchedData(datawatcher_a);
        datawatcher_a.define(DATA_IS_CHARGING, false);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 10.0).add(Attributes.FOLLOW_RANGE, 100.0).add(Attributes.CAMERA_DISTANCE, 8.0).add(Attributes.FLYING_SPEED, 0.06);
    }

    @Override
    public SoundSource getSoundSource() {
        return SoundSource.HOSTILE;
    }

    @Override
    protected SoundEvent getAmbientSound() {
        return SoundEvents.GHAST_AMBIENT;
    }

    @Override
    protected SoundEvent getHurtSound(DamageSource damagesource) {
        return SoundEvents.GHAST_HURT;
    }

    @Override
    protected SoundEvent getDeathSound() {
        return SoundEvents.GHAST_DEATH;
    }

    @Override
    protected float getSoundVolume() {
        return 5.0f;
    }

    public static boolean checkGhastSpawnRules(EntityType<Ghast> entitytypes, LevelAccessor generatoraccess, EntitySpawnReason entityspawnreason, BlockPos blockposition, RandomSource randomsource) {
        return generatoraccess.getDifficulty() != Difficulty.PEACEFUL && randomsource.nextInt(20) == 0 && Ghast.checkMobSpawnRules(entitytypes, generatoraccess, entityspawnreason, blockposition, randomsource);
    }

    @Override
    public int getMaxSpawnClusterSize() {
        return 1;
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput valueoutput) {
        super.addAdditionalSaveData(valueoutput);
        valueoutput.putByte("ExplosionPower", (byte)this.explosionPower);
    }

    @Override
    protected void readAdditionalSaveData(ValueInput valueinput) {
        super.readAdditionalSaveData(valueinput);
        this.explosionPower = valueinput.getByteOr("ExplosionPower", (byte)1);
    }

    @Override
    public boolean supportQuadLeashAsHolder() {
        return true;
    }

    @Override
    public double leashElasticDistance() {
        return 10.0;
    }

    @Override
    public double leashSnapDistance() {
        return 16.0;
    }

    public static void faceMovementDirection(Mob entityinsentient) {
        if (entityinsentient.getTarget() == null) {
            Vec3 vec3d = entityinsentient.getDeltaMovement();
            entityinsentient.setYRot(-((float)Mth.atan2(vec3d.x, vec3d.z)) * 57.295776f);
            entityinsentient.yBodyRot = entityinsentient.getYRot();
        } else {
            LivingEntity entityliving = entityinsentient.getTarget();
            double d0 = 64.0;
            if (entityliving.distanceToSqr(entityinsentient) < 4096.0) {
                double d1 = entityliving.getX() - entityinsentient.getX();
                double d2 = entityliving.getZ() - entityinsentient.getZ();
                entityinsentient.setYRot(-((float)Mth.atan2(d1, d2)) * 57.295776f);
                entityinsentient.yBodyRot = entityinsentient.getYRot();
            }
        }
    }

    public static class GhastMoveControl
    extends MoveControl {
        private final Mob ghast;
        private int floatDuration;
        private final boolean careful;
        private final BooleanSupplier shouldBeStopped;

        public GhastMoveControl(Mob entityinsentient, boolean flag, BooleanSupplier booleansupplier) {
            super(entityinsentient);
            this.ghast = entityinsentient;
            this.careful = flag;
            this.shouldBeStopped = booleansupplier;
        }

        @Override
        public void tick() {
            if (this.shouldBeStopped.getAsBoolean()) {
                this.operation = MoveControl.Operation.WAIT;
                this.ghast.stopInPlace();
            }
            if (this.operation == MoveControl.Operation.MOVE_TO && this.floatDuration-- <= 0) {
                this.floatDuration += this.ghast.getRandom().nextInt(5) + 2;
                Vec3 vec3d = new Vec3(this.wantedX - this.ghast.getX(), this.wantedY - this.ghast.getY(), this.wantedZ - this.ghast.getZ());
                if (this.canReach(vec3d)) {
                    this.ghast.setDeltaMovement(this.ghast.getDeltaMovement().add(vec3d.normalize().scale(this.ghast.getAttributeValue(Attributes.FLYING_SPEED) * 5.0 / 3.0)));
                } else {
                    this.operation = MoveControl.Operation.WAIT;
                }
            }
        }

        private boolean canReach(Vec3 vec3d) {
            AABB axisalignedbb = this.ghast.getBoundingBox();
            AABB axisalignedbb1 = axisalignedbb.move(vec3d);
            if (this.careful) {
                for (BlockPos blockposition : BlockPos.betweenClosed(axisalignedbb1.inflate(1.0))) {
                    if (this.blockTraversalPossible(this.ghast.level(), null, null, blockposition, false, false)) continue;
                    return false;
                }
            }
            boolean flag = this.ghast.isInWater();
            boolean flag1 = this.ghast.isInLava();
            Vec3 vec3d1 = this.ghast.position();
            Vec3 vec3d2 = vec3d1.add(vec3d);
            return BlockGetter.forEachBlockIntersectedBetween(vec3d1, vec3d2, axisalignedbb1, (blockposition1, i) -> axisalignedbb.intersects(blockposition1) ? true : this.blockTraversalPossible(this.ghast.level(), vec3d1, vec3d2, blockposition1, flag, flag1));
        }

        private boolean blockTraversalPossible(BlockGetter iblockaccess, @Nullable Vec3 vec3d, @Nullable Vec3 vec3d1, BlockPos blockposition, boolean flag, boolean flag1) {
            boolean flag3;
            boolean flag2;
            BlockState iblockdata = iblockaccess.getBlockState(blockposition);
            if (iblockdata.isAir()) {
                return true;
            }
            boolean bl = flag2 = vec3d != null && vec3d1 != null;
            boolean bl2 = flag2 ? !this.ghast.collidedWithShapeMovingFrom(vec3d, vec3d1, iblockdata.getCollisionShape(iblockaccess, blockposition).move(new Vec3(blockposition)).toAabbs()) : (flag3 = iblockdata.getCollisionShape(iblockaccess, blockposition).isEmpty());
            if (!this.careful) {
                return flag3;
            }
            if (iblockdata.is(BlockTags.HAPPY_GHAST_AVOIDS)) {
                return false;
            }
            FluidState fluid = iblockaccess.getFluidState(blockposition);
            if (!(fluid.isEmpty() || flag2 && !this.ghast.collidedWithFluid(fluid, blockposition, vec3d, vec3d1))) {
                if (fluid.is(FluidTags.WATER)) {
                    return flag;
                }
                if (fluid.is(FluidTags.LAVA)) {
                    return flag1;
                }
            }
            return flag3;
        }
    }

    public static class RandomFloatAroundGoal
    extends Goal {
        private static final int MAX_ATTEMPTS = 64;
        private final Mob ghast;
        private final int distanceToBlocks;

        public RandomFloatAroundGoal(Mob entityinsentient) {
            this(entityinsentient, 0);
        }

        public RandomFloatAroundGoal(Mob entityinsentient, int i) {
            this.ghast = entityinsentient;
            this.distanceToBlocks = i;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        @Override
        public boolean canUse() {
            double d2;
            double d1;
            MoveControl controllermove = this.ghast.getMoveControl();
            if (!controllermove.hasWanted()) {
                return true;
            }
            double d0 = controllermove.getWantedX() - this.ghast.getX();
            double d3 = d0 * d0 + (d1 = controllermove.getWantedY() - this.ghast.getY()) * d1 + (d2 = controllermove.getWantedZ() - this.ghast.getZ()) * d2;
            return d3 < 1.0 || d3 > 3600.0;
        }

        @Override
        public boolean canContinueToUse() {
            return false;
        }

        @Override
        public void start() {
            Vec3 vec3d = RandomFloatAroundGoal.getSuitableFlyToPosition(this.ghast, this.distanceToBlocks);
            this.ghast.getMoveControl().setWantedPosition(vec3d.x(), vec3d.y(), vec3d.z(), 1.0);
        }

        public static Vec3 getSuitableFlyToPosition(Mob entityinsentient, int i) {
            BlockPos blockposition;
            int k;
            Level world = entityinsentient.level();
            RandomSource randomsource = entityinsentient.getRandom();
            Vec3 vec3d = entityinsentient.position();
            Vec3 vec3d1 = null;
            for (int j = 0; j < 64; ++j) {
                vec3d1 = RandomFloatAroundGoal.chooseRandomPositionWithRestriction(entityinsentient, vec3d, randomsource);
                if (vec3d1 == null || !RandomFloatAroundGoal.isGoodTarget(world, vec3d1, i)) continue;
                return vec3d1;
            }
            if (vec3d1 == null) {
                vec3d1 = RandomFloatAroundGoal.chooseRandomPosition(vec3d, randomsource);
            }
            if ((k = world.getHeight(Heightmap.Types.MOTION_BLOCKING, (blockposition = BlockPos.containing(vec3d1)).getX(), blockposition.getZ())) < blockposition.getY() && k > world.getMinY()) {
                vec3d1 = new Vec3(vec3d1.x(), entityinsentient.getY() - Math.abs(entityinsentient.getY() - vec3d1.y()), vec3d1.z());
            }
            return vec3d1;
        }

        private static boolean isGoodTarget(Level world, Vec3 vec3d, int i) {
            if (i <= 0) {
                return true;
            }
            BlockPos blockposition = BlockPos.containing(vec3d);
            if (!world.getBlockState(blockposition).isAir()) {
                return false;
            }
            for (Direction enumdirection : Direction.values()) {
                for (int j = 1; j < i; ++j) {
                    BlockPos blockposition1 = blockposition.relative(enumdirection, j);
                    if (world.getBlockState(blockposition1).isAir()) continue;
                    return true;
                }
            }
            return false;
        }

        private static Vec3 chooseRandomPosition(Vec3 vec3d, RandomSource randomsource) {
            double d0 = vec3d.x() + (double)((randomsource.nextFloat() * 2.0f - 1.0f) * 16.0f);
            double d1 = vec3d.y() + (double)((randomsource.nextFloat() * 2.0f - 1.0f) * 16.0f);
            double d2 = vec3d.z() + (double)((randomsource.nextFloat() * 2.0f - 1.0f) * 16.0f);
            return new Vec3(d0, d1, d2);
        }

        private static @Nullable Vec3 chooseRandomPositionWithRestriction(Mob entityinsentient, Vec3 vec3d, RandomSource randomsource) {
            Vec3 vec3d1 = RandomFloatAroundGoal.chooseRandomPosition(vec3d, randomsource);
            return entityinsentient.hasHome() && !entityinsentient.isWithinHome(vec3d1) ? null : vec3d1;
        }
    }

    public static class GhastLookGoal
    extends Goal {
        private final Mob ghast;

        public GhastLookGoal(Mob entityinsentient) {
            this.ghast = entityinsentient;
            this.setFlags(EnumSet.of(Goal.Flag.LOOK));
        }

        @Override
        public boolean canUse() {
            return true;
        }

        @Override
        public boolean requiresUpdateEveryTick() {
            return true;
        }

        @Override
        public void tick() {
            Ghast.faceMovementDirection(this.ghast);
        }
    }

    private static class GhastShootFireballGoal
    extends Goal {
        private final Ghast ghast;
        public int chargeTime;

        public GhastShootFireballGoal(Ghast entityghast) {
            this.ghast = entityghast;
        }

        @Override
        public boolean canUse() {
            return this.ghast.getTarget() != null;
        }

        @Override
        public void start() {
            this.chargeTime = 0;
        }

        @Override
        public void stop() {
            this.ghast.setCharging(false);
        }

        @Override
        public boolean requiresUpdateEveryTick() {
            return true;
        }

        @Override
        public void tick() {
            LivingEntity entityliving = this.ghast.getTarget();
            if (entityliving != null) {
                double d0 = 64.0;
                if (entityliving.distanceToSqr(this.ghast) < 4096.0 && this.ghast.hasLineOfSight(entityliving)) {
                    Level world = this.ghast.level();
                    ++this.chargeTime;
                    if (this.chargeTime == 10 && !this.ghast.isSilent()) {
                        world.levelEvent(null, 1015, this.ghast.blockPosition(), 0);
                    }
                    if (this.chargeTime == 20) {
                        double d1 = 4.0;
                        Vec3 vec3d = this.ghast.getViewVector(1.0f);
                        double d2 = entityliving.getX() - (this.ghast.getX() + vec3d.x * 4.0);
                        double d3 = entityliving.getY(0.5) - (0.5 + this.ghast.getY(0.5));
                        double d4 = entityliving.getZ() - (this.ghast.getZ() + vec3d.z * 4.0);
                        Vec3 vec3d1 = new Vec3(d2, d3, d4);
                        if (!this.ghast.isSilent()) {
                            world.levelEvent(null, 1016, this.ghast.blockPosition(), 0);
                        }
                        LargeFireball entitylargefireball = new LargeFireball(world, (LivingEntity)this.ghast, vec3d1.normalize(), this.ghast.getExplosionPower());
                        entitylargefireball.explosionPower = this.ghast.getExplosionPower();
                        entitylargefireball.bukkitYield = entitylargefireball.explosionPower;
                        entitylargefireball.setPos(this.ghast.getX() + vec3d.x * 4.0, this.ghast.getY(0.5) + 0.5, entitylargefireball.getZ() + vec3d.z * 4.0);
                        world.addFreshEntity(entitylargefireball);
                        this.chargeTime = -40;
                    }
                } else if (this.chargeTime > 0) {
                    --this.chargeTime;
                }
                this.ghast.setCharging(this.chargeTime > 10);
            }
        }
    }
}

