/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.Identifier;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ItemBasedSteering;
import net.minecraft.world.entity.ItemSteerable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.zombie.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.jspecify.annotations.Nullable;

public class Strider
extends Animal
implements ItemSteerable {
    private static final Identifier SUFFOCATING_MODIFIER_ID = Identifier.withDefaultNamespace("suffocating");
    private static final AttributeModifier SUFFOCATING_MODIFIER = new AttributeModifier(SUFFOCATING_MODIFIER_ID, -0.34f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
    private static final float SUFFOCATE_STEERING_MODIFIER = 0.35f;
    private static final float STEERING_MODIFIER = 0.55f;
    private static final EntityDataAccessor<Integer> DATA_BOOST_TIME = SynchedEntityData.defineId(Strider.class, EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> DATA_SUFFOCATING = SynchedEntityData.defineId(Strider.class, EntityDataSerializers.BOOLEAN);
    public final ItemBasedSteering steering;
    private @Nullable TemptGoal temptGoal;

    public Strider(EntityType<? extends Strider> entitytypes, Level world) {
        super((EntityType<? extends Animal>)entitytypes, world);
        this.steering = new ItemBasedSteering(this.entityData, DATA_BOOST_TIME);
        this.blocksBuilding = true;
        this.setPathfindingMalus(PathType.WATER, -1.0f);
        this.setPathfindingMalus(PathType.LAVA, 0.0f);
        this.setPathfindingMalus(PathType.DANGER_FIRE, 0.0f);
        this.setPathfindingMalus(PathType.DAMAGE_FIRE, 0.0f);
    }

    public static boolean checkStriderSpawnRules(EntityType<Strider> entitytypes, LevelAccessor generatoraccess, EntitySpawnReason entityspawnreason, BlockPos blockposition, RandomSource randomsource) {
        BlockPos.MutableBlockPos blockposition_mutableblockposition = blockposition.mutable();
        do {
            blockposition_mutableblockposition.move(Direction.UP);
        } while (generatoraccess.getFluidState(blockposition_mutableblockposition).is(FluidTags.LAVA));
        return generatoraccess.getBlockState(blockposition_mutableblockposition).isAir();
    }

    @Override
    public void onSyncedDataUpdated(EntityDataAccessor<?> datawatcherobject) {
        if (DATA_BOOST_TIME.equals(datawatcherobject) && this.level().isClientSide()) {
            this.steering.onSynced();
        }
        super.onSyncedDataUpdated(datawatcherobject);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder datawatcher_a) {
        super.defineSynchedData(datawatcher_a);
        datawatcher_a.define(DATA_BOOST_TIME, 0);
        datawatcher_a.define(DATA_SUFFOCATING, false);
    }

    @Override
    public boolean canUseSlot(EquipmentSlot enumitemslot) {
        return enumitemslot != EquipmentSlot.SADDLE ? super.canUseSlot(enumitemslot) : this.isAlive() && !this.isBaby();
    }

    @Override
    protected boolean canDispenserEquipIntoSlot(EquipmentSlot enumitemslot) {
        return enumitemslot == EquipmentSlot.SADDLE || super.canDispenserEquipIntoSlot(enumitemslot);
    }

    @Override
    protected Holder<SoundEvent> getEquipSound(EquipmentSlot enumitemslot, ItemStack itemstack, Equippable equippable) {
        return enumitemslot == EquipmentSlot.SADDLE ? SoundEvents.STRIDER_SADDLE : super.getEquipSound(enumitemslot, itemstack, equippable);
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(1, new PanicGoal(this, 1.65));
        this.goalSelector.addGoal(2, new BreedGoal(this, 1.0));
        this.temptGoal = new TemptGoal(this, 1.4, itemstack -> itemstack.is(ItemTags.STRIDER_TEMPT_ITEMS), false);
        this.goalSelector.addGoal(3, this.temptGoal);
        this.goalSelector.addGoal(4, new StriderGoToLavaGoal(this, 1.0));
        this.goalSelector.addGoal(5, new FollowParentGoal(this, 1.0));
        this.goalSelector.addGoal(7, new RandomStrollGoal(this, 1.0, 60));
        this.goalSelector.addGoal(8, new LookAtPlayerGoal(this, Player.class, 8.0f));
        this.goalSelector.addGoal(8, new RandomLookAroundGoal(this));
        this.goalSelector.addGoal(9, new LookAtPlayerGoal(this, Strider.class, 8.0f));
    }

    public void setSuffocating(boolean flag) {
        this.entityData.set(DATA_SUFFOCATING, flag);
        AttributeInstance attributemodifiable = this.getAttribute(Attributes.MOVEMENT_SPEED);
        if (attributemodifiable != null) {
            if (flag) {
                attributemodifiable.addOrUpdateTransientModifier(SUFFOCATING_MODIFIER);
            } else {
                attributemodifiable.removeModifier(SUFFOCATING_MODIFIER_ID);
            }
        }
    }

    public boolean isSuffocating() {
        return this.entityData.get(DATA_SUFFOCATING);
    }

    @Override
    public boolean canStandOnFluid(FluidState fluid) {
        return fluid.is(FluidTags.LAVA);
    }

    @Override
    protected Vec3 getPassengerAttachmentPoint(Entity entity, EntityDimensions entitysize, float f) {
        if (!this.level().isClientSide()) {
            return super.getPassengerAttachmentPoint(entity, entitysize, f);
        }
        float f1 = Math.min(0.25f, this.walkAnimation.speed());
        float f2 = this.walkAnimation.position();
        float f3 = 0.12f * Mth.cos(f2 * 1.5f) * 2.0f * f1;
        return super.getPassengerAttachmentPoint(entity, entitysize, f).add(0.0, f3 * f, 0.0);
    }

    @Override
    public boolean checkSpawnObstruction(LevelReader iworldreader) {
        return iworldreader.isUnobstructed(this);
    }

    @Override
    public @Nullable LivingEntity getControllingPassenger() {
        Player entityhuman;
        Entity entity;
        if (this.isSaddled() && (entity = this.getFirstPassenger()) instanceof Player && (entityhuman = (Player)entity).isHolding(Items.WARPED_FUNGUS_ON_A_STICK)) {
            return entityhuman;
        }
        return super.getControllingPassenger();
    }

    @Override
    public Vec3 getDismountLocationForPassenger(LivingEntity entityliving) {
        Vec3[] avec3d = new Vec3[]{Strider.getCollisionHorizontalEscapeVector(this.getBbWidth(), entityliving.getBbWidth(), entityliving.getYRot()), Strider.getCollisionHorizontalEscapeVector(this.getBbWidth(), entityliving.getBbWidth(), entityliving.getYRot() - 22.5f), Strider.getCollisionHorizontalEscapeVector(this.getBbWidth(), entityliving.getBbWidth(), entityliving.getYRot() + 22.5f), Strider.getCollisionHorizontalEscapeVector(this.getBbWidth(), entityliving.getBbWidth(), entityliving.getYRot() - 45.0f), Strider.getCollisionHorizontalEscapeVector(this.getBbWidth(), entityliving.getBbWidth(), entityliving.getYRot() + 45.0f)};
        LinkedHashSet set = Sets.newLinkedHashSet();
        double d0 = this.getBoundingBox().maxY;
        double d1 = this.getBoundingBox().minY - 0.5;
        BlockPos.MutableBlockPos blockposition_mutableblockposition = new BlockPos.MutableBlockPos();
        for (Vec3 vec3d : avec3d) {
            blockposition_mutableblockposition.set(this.getX() + vec3d.x, d0, this.getZ() + vec3d.z);
            for (double d2 = d0; d2 > d1; d2 -= 1.0) {
                set.add(blockposition_mutableblockposition.immutable());
                blockposition_mutableblockposition.move(Direction.DOWN);
            }
        }
        for (BlockPos blockposition : set) {
            double d3;
            if (this.level().getFluidState(blockposition).is(FluidTags.LAVA) || !DismountHelper.isBlockFloorValid(d3 = this.level().getBlockFloorHeight(blockposition))) continue;
            Vec3 vec3d1 = Vec3.upFromBottomCenterOf(blockposition, d3);
            for (Pose entitypose : entityliving.getDismountPoses()) {
                AABB axisalignedbb = entityliving.getLocalBoundsForPose(entitypose);
                if (!DismountHelper.canDismountTo(this.level(), entityliving, axisalignedbb.move(vec3d1))) continue;
                entityliving.setPose(entitypose);
                return vec3d1;
            }
        }
        return new Vec3(this.getX(), this.getBoundingBox().maxY, this.getZ());
    }

    @Override
    protected void tickRidden(Player entityhuman, Vec3 vec3d) {
        this.setRot(entityhuman.getYRot(), entityhuman.getXRot() * 0.5f);
        this.yBodyRot = this.yHeadRot = this.getYRot();
        this.yRotO = this.yHeadRot;
        this.steering.tickBoost();
        super.tickRidden(entityhuman, vec3d);
    }

    @Override
    protected Vec3 getRiddenInput(Player entityhuman, Vec3 vec3d) {
        return new Vec3(0.0, 0.0, 1.0);
    }

    @Override
    protected float getRiddenSpeed(Player entityhuman) {
        return (float)(this.getAttributeValue(Attributes.MOVEMENT_SPEED) * (double)(this.isSuffocating() ? 0.35f : 0.55f) * (double)this.steering.boostFactor());
    }

    @Override
    protected float nextStep() {
        return this.moveDist + 0.6f;
    }

    @Override
    protected void playStepSound(BlockPos blockposition, BlockState iblockdata) {
        this.playSound(this.isInLava() ? SoundEvents.STRIDER_STEP_LAVA : SoundEvents.STRIDER_STEP, 1.0f, 1.0f);
    }

    @Override
    public boolean boost() {
        return this.steering.boost(this.getRandom());
    }

    @Override
    protected void checkFallDamage(double d0, boolean flag, BlockState iblockdata, BlockPos blockposition) {
        if (this.isInLava()) {
            this.resetFallDistance();
        } else {
            super.checkFallDamage(d0, flag, iblockdata, blockposition);
        }
    }

    @Override
    public void tick() {
        if (this.isBeingTempted() && this.random.nextInt(140) == 0) {
            this.makeSound(SoundEvents.STRIDER_HAPPY);
        } else if (this.isPanicking() && this.random.nextInt(60) == 0) {
            this.makeSound(SoundEvents.STRIDER_RETREAT);
        }
        if (!this.isNoAi()) {
            boolean suffocating;
            Strider entitystrider;
            BlockState iblockdata = this.level().getBlockState(this.blockPosition());
            BlockState iblockdata1 = this.getBlockStateOnLegacy();
            boolean flag = iblockdata.is(BlockTags.STRIDER_WARM_BLOCKS) || iblockdata1.is(BlockTags.STRIDER_WARM_BLOCKS) || this.getFluidHeight(FluidTags.LAVA) > 0.0;
            Entity entity = this.getVehicle();
            boolean flag1 = entity instanceof Strider && (entitystrider = (Strider)entity).isSuffocating();
            boolean flag2 = flag1;
            boolean bl = suffocating = !flag || flag2;
            if (suffocating ^ this.isSuffocating() && CraftEventFactory.callStriderTemperatureChangeEvent(this, suffocating)) {
                this.setSuffocating(suffocating);
            }
        }
        super.tick();
        this.floatStrider();
    }

    private boolean isBeingTempted() {
        return this.temptGoal != null && this.temptGoal.isRunning();
    }

    @Override
    protected boolean shouldPassengersInheritMalus() {
        return true;
    }

    private void floatStrider() {
        if (this.isInLava()) {
            CollisionContext voxelshapecollision = CollisionContext.of(this);
            if (voxelshapecollision.isAbove(LiquidBlock.SHAPE_STABLE, this.blockPosition(), true) && !this.level().getFluidState(this.blockPosition().above()).is(FluidTags.LAVA)) {
                this.setOnGround(true);
            } else {
                this.setDeltaMovement(this.getDeltaMovement().scale(0.5).add(0.0, 0.05, 0.0));
            }
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.createAnimalAttributes().add(Attributes.MOVEMENT_SPEED, 0.175f);
    }

    @Override
    protected @Nullable SoundEvent getAmbientSound() {
        return !this.isPanicking() && !this.isBeingTempted() ? SoundEvents.STRIDER_AMBIENT : null;
    }

    @Override
    protected SoundEvent getHurtSound(DamageSource damagesource) {
        return SoundEvents.STRIDER_HURT;
    }

    @Override
    protected SoundEvent getDeathSound() {
        return SoundEvents.STRIDER_DEATH;
    }

    @Override
    protected boolean canAddPassenger(Entity entity) {
        return !this.isVehicle() && !this.isEyeInFluid(FluidTags.LAVA);
    }

    @Override
    public boolean isSensitiveToWater() {
        return true;
    }

    @Override
    public boolean isOnFire() {
        return false;
    }

    @Override
    protected PathNavigation createNavigation(Level world) {
        return new StriderPathNavigation(this, world);
    }

    @Override
    public float getWalkTargetValue(BlockPos blockposition, LevelReader iworldreader) {
        return iworldreader.getBlockState(blockposition).getFluidState().is(FluidTags.LAVA) ? 10.0f : (this.isInLava() ? Float.NEGATIVE_INFINITY : 0.0f);
    }

    @Override
    public @Nullable Strider getBreedOffspring(ServerLevel worldserver, AgeableMob entityageable) {
        return EntityType.STRIDER.create(worldserver, EntitySpawnReason.BREEDING);
    }

    @Override
    public boolean isFood(ItemStack itemstack) {
        return itemstack.is(ItemTags.STRIDER_FOOD);
    }

    @Override
    public InteractionResult mobInteract(Player entityhuman, InteractionHand enumhand) {
        boolean flag = this.isFood(entityhuman.getItemInHand(enumhand));
        if (!flag && this.isSaddled() && !this.isVehicle() && !entityhuman.isSecondaryUseActive()) {
            if (!this.level().isClientSide()) {
                entityhuman.startRiding(this);
            }
            return InteractionResult.SUCCESS;
        }
        InteractionResult enuminteractionresult = super.mobInteract(entityhuman, enumhand);
        if (!enuminteractionresult.consumesAction()) {
            ItemStack itemstack = entityhuman.getItemInHand(enumhand);
            return this.isEquippableInSlot(itemstack, EquipmentSlot.SADDLE) ? itemstack.interactLivingEntity(entityhuman, this, enumhand) : InteractionResult.PASS;
        }
        if (flag && !this.isSilent()) {
            this.level().playSound((Entity)null, this.getX(), this.getY(), this.getZ(), SoundEvents.STRIDER_EAT, this.getSoundSource(), 1.0f, 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.2f);
        }
        return enuminteractionresult;
    }

    @Override
    public Vec3 getLeashOffset() {
        return new Vec3(0.0, 0.6f * this.getEyeHeight(), this.getBbWidth() * 0.4f);
    }

    @Override
    public @Nullable SpawnGroupData finalizeSpawn(ServerLevelAccessor worldaccess, DifficultyInstance difficultydamagescaler, EntitySpawnReason entityspawnreason, @Nullable SpawnGroupData groupdataentity) {
        if (this.isBaby()) {
            return super.finalizeSpawn(worldaccess, difficultydamagescaler, entityspawnreason, groupdataentity);
        }
        RandomSource randomsource = worldaccess.getRandom();
        if (randomsource.nextInt(30) == 0) {
            Mob entityinsentient = EntityType.ZOMBIFIED_PIGLIN.create(worldaccess.getLevel(), EntitySpawnReason.JOCKEY);
            if (entityinsentient != null) {
                groupdataentity = this.spawnJockey(worldaccess, difficultydamagescaler, entityinsentient, new Zombie.ZombieGroupData(Zombie.getSpawnAsBabyOdds(randomsource), false));
                entityinsentient.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack(Items.WARPED_FUNGUS_ON_A_STICK));
                this.setItemSlot(EquipmentSlot.SADDLE, new ItemStack(Items.SADDLE));
                this.setGuaranteedDrop(EquipmentSlot.SADDLE);
            }
        } else if (randomsource.nextInt(10) == 0) {
            AgeableMob entityageable = EntityType.STRIDER.create(worldaccess.getLevel(), EntitySpawnReason.JOCKEY);
            if (entityageable != null) {
                entityageable.setAge(-24000);
                groupdataentity = this.spawnJockey(worldaccess, difficultydamagescaler, entityageable, null);
            }
        } else {
            groupdataentity = new AgeableMob.AgeableMobGroupData(0.5f);
        }
        return super.finalizeSpawn(worldaccess, difficultydamagescaler, entityspawnreason, groupdataentity);
    }

    private SpawnGroupData spawnJockey(ServerLevelAccessor worldaccess, DifficultyInstance difficultydamagescaler, Mob entityinsentient, @Nullable SpawnGroupData groupdataentity) {
        entityinsentient.snapTo(this.getX(), this.getY(), this.getZ(), this.getYRot(), 0.0f);
        entityinsentient.finalizeSpawn(worldaccess, difficultydamagescaler, EntitySpawnReason.JOCKEY, groupdataentity);
        entityinsentient.startRiding(this, true, false);
        return new AgeableMob.AgeableMobGroupData(0.0f);
    }

    private static class StriderGoToLavaGoal
    extends MoveToBlockGoal {
        private final Strider strider;

        StriderGoToLavaGoal(Strider entitystrider, double d0) {
            super(entitystrider, d0, 8, 2);
            this.strider = entitystrider;
        }

        @Override
        public BlockPos getMoveToTarget() {
            return this.blockPos;
        }

        @Override
        public boolean canContinueToUse() {
            return !this.strider.isInLava() && this.isValidTarget(this.strider.level(), this.blockPos);
        }

        @Override
        public boolean canUse() {
            return !this.strider.isInLava() && super.canUse();
        }

        @Override
        public boolean shouldRecalculatePath() {
            return this.tryTicks % 20 == 0;
        }

        @Override
        protected boolean isValidTarget(LevelReader iworldreader, BlockPos blockposition) {
            return iworldreader.getBlockState(blockposition).is(Blocks.LAVA) && iworldreader.getBlockState(blockposition.above()).isPathfindable(PathComputationType.LAND);
        }
    }

    private static class StriderPathNavigation
    extends GroundPathNavigation {
        StriderPathNavigation(Strider entitystrider, Level world) {
            super(entitystrider, world);
        }

        @Override
        protected PathFinder createPathFinder(int i) {
            this.nodeEvaluator = new WalkNodeEvaluator();
            return new PathFinder(this.nodeEvaluator, i);
        }

        @Override
        protected boolean hasValidPathType(PathType pathtype) {
            return pathtype != PathType.LAVA && pathtype != PathType.DAMAGE_FIRE && pathtype != PathType.DANGER_FIRE ? super.hasValidPathType(pathtype) : true;
        }

        @Override
        public boolean isStableDestination(BlockPos blockposition) {
            return this.level.getBlockState(blockposition).is(Blocks.LAVA) || super.isStableDestination(blockposition);
        }
    }
}

