/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.zombie;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.animal.camel.CamelHusk;
import net.minecraft.world.entity.monster.skeleton.Parched;
import net.minecraft.world.entity.monster.zombie.Zombie;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.jspecify.annotations.Nullable;

public class Husk
extends Zombie {
    public Husk(EntityType<? extends Husk> entitytypes, Level world) {
        super((EntityType<? extends Zombie>)entitytypes, world);
    }

    @Override
    protected boolean isSunSensitive() {
        return false;
    }

    @Override
    protected SoundEvent getAmbientSound() {
        return SoundEvents.HUSK_AMBIENT;
    }

    @Override
    protected SoundEvent getHurtSound(DamageSource damagesource) {
        return SoundEvents.HUSK_HURT;
    }

    @Override
    protected SoundEvent getDeathSound() {
        return SoundEvents.HUSK_DEATH;
    }

    @Override
    protected SoundEvent getStepSound() {
        return SoundEvents.HUSK_STEP;
    }

    @Override
    public boolean doHurtTarget(ServerLevel worldserver, Entity entity) {
        boolean flag = super.doHurtTarget(worldserver, entity);
        if (flag && this.getMainHandItem().isEmpty() && entity instanceof LivingEntity) {
            float f = worldserver.getCurrentDifficultyAt(this.blockPosition()).getEffectiveDifficulty();
            ((LivingEntity)entity).addEffect(new MobEffectInstance(MobEffects.HUNGER, 140 * (int)f), this, EntityPotionEffectEvent.Cause.ATTACK);
        }
        return flag;
    }

    @Override
    protected boolean convertsInWater() {
        return true;
    }

    @Override
    protected void doUnderWaterConversion(ServerLevel worldserver) {
        this.convertToZombieType(worldserver, EntityType.ZOMBIE);
        if (!this.isSilent()) {
            worldserver.levelEvent(null, 1041, this.blockPosition(), 0);
        }
    }

    @Override
    public @Nullable SpawnGroupData finalizeSpawn(ServerLevelAccessor worldaccess, DifficultyInstance difficultydamagescaler, EntitySpawnReason entityspawnreason, @Nullable SpawnGroupData groupdataentity) {
        RandomSource randomsource = worldaccess.getRandom();
        groupdataentity = super.finalizeSpawn(worldaccess, difficultydamagescaler, entityspawnreason, groupdataentity);
        float f = difficultydamagescaler.getSpecialMultiplier();
        if (entityspawnreason != EntitySpawnReason.CONVERSION) {
            this.setCanPickUpLoot(randomsource.nextFloat() < 0.55f * f);
        }
        if (groupdataentity != null) {
            groupdataentity = new HuskGroupData((Zombie.ZombieGroupData)groupdataentity);
            boolean bl = ((HuskGroupData)groupdataentity).triedToSpawnCamelHusk = entityspawnreason != EntitySpawnReason.NATURAL;
        }
        if (groupdataentity instanceof HuskGroupData) {
            BlockPos blockposition;
            HuskGroupData entityzombiehusk_a = (HuskGroupData)groupdataentity;
            if (!entityzombiehusk_a.triedToSpawnCamelHusk && worldaccess.noCollision(EntityType.CAMEL_HUSK.getSpawnAABB((double)(blockposition = this.blockPosition()).getX() + 0.5, blockposition.getY(), (double)blockposition.getZ() + 0.5))) {
                entityzombiehusk_a.triedToSpawnCamelHusk = true;
                if (randomsource.nextFloat() < 0.1f) {
                    this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack(Items.IRON_SPEAR));
                    CamelHusk camelhusk = EntityType.CAMEL_HUSK.create(this.level(), EntitySpawnReason.NATURAL);
                    if (camelhusk != null) {
                        camelhusk.setPos(this.getX(), this.getY(), this.getZ());
                        camelhusk.finalizeSpawn(worldaccess, difficultydamagescaler, entityspawnreason, null);
                        this.startRiding(camelhusk, true, true);
                        worldaccess.addFreshEntity(camelhusk);
                        Parched parched = EntityType.PARCHED.create(this.level(), EntitySpawnReason.NATURAL);
                        if (parched != null) {
                            parched.snapTo(this.getX(), this.getY(), this.getZ(), this.getYRot(), 0.0f);
                            parched.finalizeSpawn(worldaccess, difficultydamagescaler, entityspawnreason, null);
                            parched.startRiding(camelhusk, false, false);
                            worldaccess.addFreshEntityWithPassengers(parched);
                        }
                    }
                }
            }
        }
        return groupdataentity;
    }

    public static class HuskGroupData
    extends Zombie.ZombieGroupData {
        public boolean triedToSpawnCamelHusk = false;

        public HuskGroupData(Zombie.ZombieGroupData entityzombie_groupdatazombie) {
            super(entityzombie_groupdatazombie.isBaby, entityzombie_groupdatazombie.canSpawnJockey);
        }
    }
}

