/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.zombie;

import com.google.common.annotations.VisibleForTesting;
import java.util.EnumSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ReputationEventHandler;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.gossip.GossipContainer;
import net.minecraft.world.entity.ai.village.ReputationEventType;
import net.minecraft.world.entity.monster.zombie.Zombie;
import net.minecraft.world.entity.npc.villager.Villager;
import net.minecraft.world.entity.npc.villager.VillagerData;
import net.minecraft.world.entity.npc.villager.VillagerDataHolder;
import net.minecraft.world.entity.npc.villager.VillagerType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityTransformEvent;
import org.jspecify.annotations.Nullable;

public class ZombieVillager
extends Zombie
implements VillagerDataHolder {
    public static final EntityDataAccessor<Boolean> DATA_CONVERTING_ID = SynchedEntityData.defineId(ZombieVillager.class, EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<VillagerData> DATA_VILLAGER_DATA = SynchedEntityData.defineId(ZombieVillager.class, EntityDataSerializers.VILLAGER_DATA);
    private static final int VILLAGER_CONVERSION_WAIT_MIN = 3600;
    private static final int VILLAGER_CONVERSION_WAIT_MAX = 6000;
    private static final int MAX_SPECIAL_BLOCKS_COUNT = 14;
    private static final int SPECIAL_BLOCK_RADIUS = 4;
    private static final int NOT_CONVERTING = -1;
    private static final int DEFAULT_XP = 0;
    private static final Set<EntitySpawnReason> REASONS_NOT_TO_SET_TYPE = EnumSet.of(EntitySpawnReason.LOAD, new EntitySpawnReason[]{EntitySpawnReason.DIMENSION_TRAVEL, EntitySpawnReason.CONVERSION, EntitySpawnReason.SPAWN_ITEM_USE, EntitySpawnReason.SPAWNER, EntitySpawnReason.TRIAL_SPAWNER});
    public int villagerConversionTime;
    public @Nullable UUID conversionStarter;
    private @Nullable GossipContainer gossips;
    private @Nullable MerchantOffers tradeOffers;
    private int villagerXp = 0;
    private int lastTick = MinecraftServer.currentTick;

    public ZombieVillager(EntityType<? extends ZombieVillager> entitytypes, Level world) {
        super((EntityType<? extends Zombie>)entitytypes, world);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder datawatcher_a) {
        super.defineSynchedData(datawatcher_a);
        datawatcher_a.define(DATA_CONVERTING_ID, false);
        datawatcher_a.define(DATA_VILLAGER_DATA, this.initializeVillagerData());
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput valueoutput) {
        super.addAdditionalSaveData(valueoutput);
        valueoutput.store("VillagerData", VillagerData.CODEC, this.getVillagerData());
        valueoutput.storeNullable("Offers", MerchantOffers.CODEC, this.tradeOffers);
        valueoutput.storeNullable("Gossips", GossipContainer.CODEC, this.gossips);
        valueoutput.putInt("ConversionTime", this.isConverting() ? this.villagerConversionTime : -1);
        valueoutput.storeNullable("ConversionPlayer", UUIDUtil.CODEC, this.conversionStarter);
        valueoutput.putInt("Xp", this.villagerXp);
    }

    @Override
    protected void readAdditionalSaveData(ValueInput valueinput) {
        super.readAdditionalSaveData(valueinput);
        this.entityData.set(DATA_VILLAGER_DATA, valueinput.read("VillagerData", VillagerData.CODEC).orElseGet(this::initializeVillagerData));
        this.tradeOffers = valueinput.read("Offers", MerchantOffers.CODEC).orElse(null);
        this.gossips = valueinput.read("Gossips", GossipContainer.CODEC).orElse(null);
        int i = valueinput.getIntOr("ConversionTime", -1);
        if (i != -1) {
            UUID uuid = valueinput.read("ConversionPlayer", UUIDUtil.CODEC).orElse(null);
            this.startConverting(uuid, i);
        } else {
            this.getEntityData().set(DATA_CONVERTING_ID, false);
            this.villagerConversionTime = -1;
        }
        this.villagerXp = valueinput.getIntOr("Xp", 0);
    }

    @Override
    public @Nullable SpawnGroupData finalizeSpawn(ServerLevelAccessor worldaccess, DifficultyInstance difficultydamagescaler, EntitySpawnReason entityspawnreason, @Nullable SpawnGroupData groupdataentity) {
        if (!REASONS_NOT_TO_SET_TYPE.contains((Object)entityspawnreason)) {
            this.setVillagerData(this.getVillagerData().withType(worldaccess.registryAccess(), VillagerType.byBiome(worldaccess.getBiome(this.blockPosition()))));
        }
        return super.finalizeSpawn(worldaccess, difficultydamagescaler, entityspawnreason, groupdataentity);
    }

    private VillagerData initializeVillagerData() {
        Optional optional = BuiltInRegistries.VILLAGER_PROFESSION.getRandom(this.random);
        VillagerData villagerdata = Villager.createDefaultVillagerData();
        if (optional.isPresent()) {
            villagerdata = villagerdata.withProfession(optional.get());
        }
        return villagerdata;
    }

    @Override
    public void tick() {
        if (!this.level().isClientSide() && this.isAlive() && this.isConverting()) {
            int i = this.getConversionProgress();
            int elapsedTicks = MinecraftServer.currentTick - this.lastTick;
            this.villagerConversionTime -= (i *= elapsedTicks);
            if (this.villagerConversionTime <= 0) {
                this.finishConversion((ServerLevel)this.level());
            }
        }
        super.tick();
        this.lastTick = MinecraftServer.currentTick;
    }

    @Override
    public InteractionResult mobInteract(Player entityhuman, InteractionHand enumhand) {
        ItemStack itemstack = entityhuman.getItemInHand(enumhand);
        if (itemstack.is(Items.GOLDEN_APPLE)) {
            if (this.hasEffect(MobEffects.WEAKNESS)) {
                itemstack.consume(1, entityhuman);
                if (!this.level().isClientSide()) {
                    this.startConverting(entityhuman.getUUID(), this.random.nextInt(2401) + 3600);
                }
                return InteractionResult.SUCCESS_SERVER;
            }
            return InteractionResult.CONSUME;
        }
        return super.mobInteract(entityhuman, enumhand);
    }

    @Override
    protected boolean convertsInWater() {
        return false;
    }

    @Override
    public boolean removeWhenFarAway(double d0) {
        return !this.isConverting() && this.villagerXp == 0;
    }

    public boolean isConverting() {
        return this.getEntityData().get(DATA_CONVERTING_ID);
    }

    public void startConverting(@Nullable UUID uuid, int i) {
        this.conversionStarter = uuid;
        this.villagerConversionTime = i;
        this.getEntityData().set(DATA_CONVERTING_ID, true);
        this.removeEffect(MobEffects.WEAKNESS, EntityPotionEffectEvent.Cause.CONVERSION);
        this.addEffect(new MobEffectInstance(MobEffects.STRENGTH, i, Math.min(this.level().getDifficulty().getId() - 1, 0)), EntityPotionEffectEvent.Cause.CONVERSION);
        this.level().broadcastEntityEvent(this, (byte)16);
    }

    @Override
    public void handleEntityEvent(byte b0) {
        if (b0 == 16) {
            if (!this.isSilent()) {
                this.level().playLocalSound(this.getX(), this.getEyeY(), this.getZ(), SoundEvents.ZOMBIE_VILLAGER_CURE, this.getSoundSource(), 1.0f + this.random.nextFloat(), this.random.nextFloat() * 0.7f + 0.3f, false);
            }
        } else {
            super.handleEntityEvent(b0);
        }
    }

    private void finishConversion(ServerLevel worldserver) {
        Villager converted = this.convertTo(EntityType.VILLAGER, ConversionParams.single(this, false, false), entityvillager -> {
            Player entityhuman;
            this.forceDrops = false;
            for (EquipmentSlot enumitemslot : this.dropPreservedEquipment(worldserver, itemstack -> !EnchantmentHelper.has(itemstack, EnchantmentEffectComponents.PREVENT_ARMOR_CHANGE))) {
                SlotAccess slotaccess = entityvillager.getSlot(enumitemslot.getIndex() + 300);
                if (slotaccess == null) continue;
                slotaccess.set(this.getItemBySlot(enumitemslot));
            }
            entityvillager.setVillagerData(this.getVillagerData());
            if (this.gossips != null) {
                entityvillager.setGossips(this.gossips);
            }
            if (this.tradeOffers != null) {
                entityvillager.setOffers(this.tradeOffers.copy());
            }
            entityvillager.setVillagerXp(this.villagerXp);
            entityvillager.finalizeSpawn(worldserver, worldserver.getCurrentDifficultyAt(entityvillager.blockPosition()), EntitySpawnReason.CONVERSION, null);
            entityvillager.refreshBrain(worldserver);
            if (this.conversionStarter != null && (entityhuman = worldserver.getPlayerByUUID(this.conversionStarter)) instanceof ServerPlayer) {
                CriteriaTriggers.CURED_ZOMBIE_VILLAGER.trigger((ServerPlayer)entityhuman, this, (Villager)entityvillager);
                worldserver.onReputationEvent(ReputationEventType.ZOMBIE_VILLAGER_CURED, entityhuman, (ReputationEventHandler)((Object)entityvillager));
            }
            entityvillager.addEffect(new MobEffectInstance(MobEffects.NAUSEA, 200, 0), EntityPotionEffectEvent.Cause.CONVERSION);
            if (!this.isSilent()) {
                worldserver.levelEvent(null, 1027, this.blockPosition(), 0);
            }
        }, EntityTransformEvent.TransformReason.CURED, CreatureSpawnEvent.SpawnReason.CURED);
        if (converted == null) {
            ((org.bukkit.entity.ZombieVillager)this.getBukkitEntity()).setConversionTime(-1);
        }
    }

    @VisibleForTesting
    public void setVillagerConversionTime(int i) {
        this.villagerConversionTime = i;
    }

    private int getConversionProgress() {
        int i = 1;
        if (this.random.nextFloat() < 0.01f) {
            int j = 0;
            BlockPos.MutableBlockPos blockposition_mutableblockposition = new BlockPos.MutableBlockPos();
            for (int k = (int)this.getX() - 4; k < (int)this.getX() + 4 && j < 14; ++k) {
                for (int l = (int)this.getY() - 4; l < (int)this.getY() + 4 && j < 14; ++l) {
                    for (int i1 = (int)this.getZ() - 4; i1 < (int)this.getZ() + 4 && j < 14; ++i1) {
                        BlockState iblockdata = this.level().getBlockState(blockposition_mutableblockposition.set(k, l, i1));
                        if (!iblockdata.is(Blocks.IRON_BARS) && !(iblockdata.getBlock() instanceof BedBlock)) continue;
                        if (this.random.nextFloat() < 0.3f) {
                            ++i;
                        }
                        ++j;
                    }
                }
            }
        }
        return i;
    }

    @Override
    public float getVoicePitch() {
        return this.isBaby() ? (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 2.0f : (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f;
    }

    @Override
    public SoundEvent getAmbientSound() {
        return SoundEvents.ZOMBIE_VILLAGER_AMBIENT;
    }

    @Override
    public SoundEvent getHurtSound(DamageSource damagesource) {
        return SoundEvents.ZOMBIE_VILLAGER_HURT;
    }

    @Override
    public SoundEvent getDeathSound() {
        return SoundEvents.ZOMBIE_VILLAGER_DEATH;
    }

    @Override
    public SoundEvent getStepSound() {
        return SoundEvents.ZOMBIE_VILLAGER_STEP;
    }

    public void setTradeOffers(MerchantOffers merchantrecipelist) {
        this.tradeOffers = merchantrecipelist;
    }

    public void setGossips(GossipContainer reputation) {
        this.gossips = reputation;
    }

    @Override
    public void setVillagerData(VillagerData villagerdata) {
        VillagerData villagerdata1 = this.getVillagerData();
        if (!villagerdata1.profession().equals(villagerdata.profession())) {
            this.tradeOffers = null;
        }
        this.entityData.set(DATA_VILLAGER_DATA, villagerdata);
    }

    @Override
    public VillagerData getVillagerData() {
        return this.entityData.get(DATA_VILLAGER_DATA);
    }

    public int getVillagerXp() {
        return this.villagerXp;
    }

    public void setVillagerXp(int i) {
        this.villagerXp = i;
    }

    @Override
    public <T> @Nullable T get(DataComponentType<? extends T> datacomponenttype) {
        return datacomponenttype == DataComponents.VILLAGER_VARIANT ? ZombieVillager.castComponentValue(datacomponenttype, this.getVillagerData().type()) : super.get(datacomponenttype);
    }

    @Override
    protected void applyImplicitComponents(DataComponentGetter datacomponentgetter) {
        this.applyImplicitComponentIfPresent(datacomponentgetter, DataComponents.VILLAGER_VARIANT);
        super.applyImplicitComponents(datacomponentgetter);
    }

    @Override
    protected <T> boolean applyImplicitComponent(DataComponentType<T> datacomponenttype, T t0) {
        if (datacomponenttype == DataComponents.VILLAGER_VARIANT) {
            Holder<VillagerType> holder = ZombieVillager.castComponentValue(DataComponents.VILLAGER_VARIANT, t0);
            this.setVillagerData(this.getVillagerData().withType(holder));
            return true;
        }
        return super.applyImplicitComponent(datacomponenttype, t0);
    }
}

