/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.npc;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.StructureTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.animal.feline.Cat;
import net.minecraft.world.level.CustomSpawner;
import net.minecraft.world.phys.AABB;

public class CatSpawner
implements CustomSpawner {
    private static final int TICK_DELAY = 1200;
    private int nextTick;

    @Override
    public void tick(ServerLevel var0, boolean var1) {
        --this.nextTick;
        if (this.nextTick > 0) {
            return;
        }
        this.nextTick = 1200;
        ServerPlayer var2 = var0.getRandomPlayer();
        if (var2 == null) {
            return;
        }
        RandomSource var3 = var0.random;
        int var4 = (8 + var3.nextInt(24)) * (var3.nextBoolean() ? -1 : 1);
        int var5 = (8 + var3.nextInt(24)) * (var3.nextBoolean() ? -1 : 1);
        BlockPos var6 = var2.blockPosition().offset(var4, 0, var5);
        int var7 = 10;
        if (!var0.hasChunksAt(var6.getX() - 10, var6.getZ() - 10, var6.getX() + 10, var6.getZ() + 10)) {
            return;
        }
        if (SpawnPlacements.isSpawnPositionOk(EntityType.CAT, var0, var6)) {
            if (var0.isCloseToVillage(var6, 2)) {
                this.spawnInVillage(var0, var6);
            } else if (var0.structureManager().getStructureWithPieceAt(var6, StructureTags.CATS_SPAWN_IN).isValid()) {
                this.spawnInHut(var0, var6);
            }
        }
    }

    private void spawnInVillage(ServerLevel var02, BlockPos var1) {
        List<Cat> var3;
        int var2 = 48;
        if (var02.getPoiManager().getCountInRange(var0 -> var0.is(PoiTypes.HOME), var1, 48, PoiManager.Occupancy.IS_OCCUPIED) > 4L && (var3 = var02.getEntitiesOfClass(Cat.class, new AABB(var1).inflate(48.0, 8.0, 48.0))).size() < 5) {
            this.spawnCat(var1, var02, false);
        }
    }

    private void spawnInHut(ServerLevel var0, BlockPos var1) {
        int var2 = 16;
        List<Cat> var3 = var0.getEntitiesOfClass(Cat.class, new AABB(var1).inflate(16.0, 8.0, 16.0));
        if (var3.isEmpty()) {
            this.spawnCat(var1, var0, true);
        }
    }

    private void spawnCat(BlockPos var0, ServerLevel var1, boolean var2) {
        Cat var3 = EntityType.CAT.create(var1, EntitySpawnReason.NATURAL);
        if (var3 == null) {
            return;
        }
        var3.finalizeSpawn(var1, var1.getCurrentDifficultyAt(var0), EntitySpawnReason.NATURAL, null);
        if (var2) {
            var3.setPersistenceRequired();
        }
        var3.snapTo(var0, 0.0f, 0.0f);
        var1.addFreshEntityWithPassengers(var3);
    }
}

